/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import java.awt.Rectangle;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class AlignmentEdit
implements UndoableEdit {
    public static final int INSERT = 0;
    public static final int DELETE = 1;
    private int type;
    private Rectangle rect;
    private MultipleAlignment alignment;

    public AlignmentEdit(Rectangle rect, int type, MultipleAlignment alignment) {
        this.alignment = alignment;
        this.rect = rect;
        this.type = type;
    }

    public void undo() throws CannotUndoException {
        if (this.type == 1) {
            this.alignment.insertChar('-', this.rect);
        } else if (this.type == 0) {
            this.alignment.delete(this.rect);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void redo() throws CannotRedoException {
        if (this.type == 0) {
            this.alignment.insertChar('-', this.rect);
        } else if (this.type == 1) {
            this.alignment.delete(this.rect);
        }
    }

    public boolean canRedo() {
        return true;
    }

    public void die() {
    }

    public boolean addEdit(UndoableEdit arg0) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit arg0) {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public String getPresentationName() {
        return "edit operation";
    }

    public String getUndoPresentationName() {
        return "edit operation";
    }

    public String getRedoPresentationName() {
        return "edit operation";
    }
}

