/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import java.awt.Font;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FontSizeChooser
implements MouseWheelListener {
    private JComponent editor;
    JTextField sizeField = new JTextField();

    public FontSizeChooser(JComponent editor) {
        this.sizeField.setEditable(false);
        this.editor = editor;
        editor.addMouseWheelListener(this);
        this.sizeField.setText(String.valueOf(editor.getFont().getSize()));
    }

    private void increaseFont(int steps) {
        Font f = this.editor.getFont();
        int size = f.getSize();
        size = Math.min(24, size + 2 * steps);
        this.editor.setFont(new Font(f.getFontName(), f.getStyle(), size));
        this.sizeField.setText(String.valueOf(size));
    }

    private void decreaseFont(int steps) {
        Font f = this.editor.getFont();
        int size = f.getSize();
        size = Math.max(2, size - 2 * steps);
        this.editor.setFont(new Font(f.getFontName(), f.getStyle(), size));
        this.sizeField.setText(String.valueOf(size));
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrolled = e.getWheelRotation();
        if (scrolled > 0) {
            this.increaseFont(scrolled);
        } else {
            this.decreaseFont(Math.abs(scrolled));
        }
    }
}

