/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.RenderUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class MACharacterRenderer {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private Shape[] shapes;
    private HashMap<Color, BufferedImage> cache;
    private int size;
    private Font font;
    double offsetX;
    double offsetY;

    public MACharacterRenderer() {
        this.setFont(new Font("Curier", 1, 12));
    }

    private void setSize(int s) {
        this.size = s;
        this.cache = new HashMap();
        this.shapes = new Shape[3];
        Area start = new Area(new RoundRectangle2D.Double(0.0, 0.0, 2 * s, s, s, s));
        start.subtract(new Area(new Rectangle2D.Double(1.5 * (double)s, 0.0, s, s)));
        this.shapes[0] = start;
        this.shapes[1] = new Rectangle2D.Double(0.0, 0.0, s, s);
        Area end = new Area(new RoundRectangle2D.Double(-s / 2, 0.0, 2 * s, s, s, s));
        end.subtract(new Area(new Rectangle2D.Double(-s / 2, 0.0, s / 2, s)));
        this.shapes[2] = end;
    }

    public void setFont(Font font) {
        this.font = font;
        this.setSize(RenderUtils.pixelSizeForFont(font) + 2);
        this.cache = new HashMap();
        BufferedImage img = new BufferedImage(10, 10, 2);
        FontRenderContext frc = ((Graphics2D)img.getGraphics()).getFontRenderContext();
        TextLayout layout = new TextLayout(new Character('U').toString(), font, frc);
        Rectangle2D bounds = layout.getBounds();
        this.offsetX = ((double)this.size - bounds.getWidth()) / 2.0;
        this.offsetY = ((double)this.size - bounds.getHeight()) / 2.0;
    }

    public void renderSymbol(Graphics2D g, Character character, Color color, int state, boolean selected, boolean highlighted, boolean doCaching) {
        if (selected) {
            g.setColor(color);
            g.fill(this.shapes[state]);
        } else if (state == 1 && doCaching) {
            BufferedImage buffer = this.cache.get(color);
            if (buffer == null) {
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.size, color, false);
                buffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.size, this.size);
                Graphics2D g2 = (Graphics2D)buffer.getGraphics();
                g2.setPaint(paint);
                g2.fill(this.shapes[state]);
                this.cache.put(color, buffer);
            }
            g.drawImage(buffer, null, 0, 0);
        } else {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.size, color, false);
            g.setPaint(paint);
            g.fill(this.shapes[state]);
        }
        if (selected) {
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.BLACK);
        } else {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(color);
        }
        g.draw(this.shapes[state]);
        if (this.font.getSize() >= 6) {
            if (selected) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.setFont(this.font);
            if (state == 0) {
                g.drawString(character.toString(), (int)(this.offsetX + (double)(this.size / 2)), (int)((double)this.size - this.offsetY));
            } else {
                g.drawString(character.toString(), (int)this.offsetX, (int)((double)this.size - this.offsetY));
            }
        }
    }
}

