/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.events.AlignmentChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentListener;
import de.biozentrum.bioinformatik.alignment.events.AlignmentStructureChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.sequence.Sequence;
import de.biozentrum.bioinformatik.sequence.SequenceAlphabet;
import de.biozentrum.bioinformatik.sequence.events.SequenceChangedEvent;
import de.biozentrum.bioinformatik.sequence.events.SequenceListener;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAlignment
implements Iterable<Sequence>,
SequenceListener {
    protected ArrayList<AlignmentListener> listeners = new ArrayList();
    protected ArrayList<Sequence> sequences;
    private SequenceAlphabet alphabet;

    public MultipleAlignment() {
        this.sequences = new ArrayList();
    }

    public MultipleAlignment(ArrayList<Sequence> sequences) {
        this.sequences = sequences;
    }

    public void setAlphabet(SequenceAlphabet alphabet) {
        this.alphabet = alphabet;
    }

    public void insertChar(char c, Rectangle rect) {
        char[] str = new char[(int)rect.getWidth()];
        char[] gaps = new char[(int)rect.getWidth()];
        int i = 0;
        while (i < str.length) {
            str[i] = c;
            gaps[i] = 45;
            ++i;
        }
        int seq = 0;
        while (seq < this.sequences.size()) {
            if (seq >= (int)rect.getMinY() && seq < (int)rect.getMaxY()) {
                this.sequences.get(seq).insert(this, str, (int)rect.getMinX());
            } else {
                this.sequences.get(seq).insert(this, gaps, this.sequences.get(seq).length());
            }
            ++seq;
        }
        if ((int)rect.getMinY() > 0) {
            this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, new Rectangle(this.sequences.get(0).length() - gaps.length - 1, 0, gaps.length, (int)rect.getMinY() + 1), MAEvent.MAEventType.INSERT, true));
        }
        if ((int)rect.getMaxY() < this.sequences.size()) {
            this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, new Rectangle(this.sequences.get(0).length() - gaps.length - 1, (int)rect.getMaxY() + 1, gaps.length, this.sequences.size() - (int)rect.getMaxY()), MAEvent.MAEventType.INSERT, true));
        }
        this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, rect, MAEvent.MAEventType.INSERT, false));
    }

    public void insertChar(char c, int sequence, int position) {
        this.insertChar(c, new Rectangle(position, sequence, 0, 0));
    }

    public void delete(Rectangle rect) {
        this.deleteAdjusting(rect, false);
    }

    public void deleteAdjusting(Rectangle rect, boolean isAdjusting) {
        if (rect.getHeight() != (double)this.sequences.size()) {
            char[] gaps = new char[(int)rect.getWidth()];
            int i = 0;
            while (i < gaps.length) {
                gaps[i] = 45;
                ++i;
            }
            int seq = (int)rect.getMinY();
            while (seq < (int)rect.getMaxY()) {
                this.sequences.get(seq).insert(this, gaps, this.sequences.get(seq).length());
                ++seq;
            }
            this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, new Rectangle((int)((double)this.length() - rect.getWidth()), (int)rect.getMinY(), (int)rect.getWidth(), (int)rect.getHeight()), MAEvent.MAEventType.DELETE, true));
        }
        int seq = (int)rect.getMinY();
        while (seq < (int)rect.getMaxY()) {
            this.sequences.get(seq).delete(this, (int)rect.getMinX(), (int)rect.getMaxX());
            ++seq;
        }
        this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, rect, MAEvent.MAEventType.DELETE, isAdjusting));
    }

    public void pack() {
        int col = this.length() - 1;
        while (this.isGapOnlyColumn(col) && col > 0) {
            --col;
        }
        if (col != this.length() - 1) {
            this.deleteAdjusting(new Rectangle(col + 1, 0, this.length() - (col + 1), this.sequences.size()), true);
        }
        col = 0;
        while (this.isGapOnlyColumn(col) && col < this.length()) {
            ++col;
        }
        if (col != 0) {
            this.deleteAdjusting(new Rectangle(col - 1, 0, col - 0, this.sequences.size()), true);
        }
    }

    public void makeEqualLength() {
        int maxLength = 0;
        for (Sequence sequence : this.sequences) {
            maxLength = Math.max(maxLength, sequence.length());
        }
        for (Sequence sequence : this.sequences) {
            sequence.fillUpWithGaps(maxLength);
        }
    }

    protected boolean isGapOnlyColumn(int column) {
        char[] col = this.getColumn(column);
        boolean flag = true;
        int i = 0;
        while (i < col.length) {
            boolean bl = flag = col[i] == '-';
            if (!flag) break;
            ++i;
        }
        return flag;
    }

    protected boolean onlyGapsInColumn(int column, int seqFrom, int seqTo) {
        boolean flag = true;
        int i = seqFrom;
        while (i <= seqTo) {
            boolean bl = flag = this.sequences.get(i).charAt(column) == '-';
            if (!flag) break;
            ++i;
        }
        return flag;
    }

    protected boolean onlyGapsInColumnExclusive(int column, int seqFrom, int seqTo) {
        return this.onlyGapsInColumn(column, 0, seqFrom - 1) && this.onlyGapsInColumn(column, seqTo + 1, this.sequences.size() - 1);
    }

    public void deleteChar(int sequence, int position) {
        this.delete(new Rectangle(position, sequence, 0, 0));
    }

    public int rows() {
        return this.sequences.size();
    }

    public void addSequence(Sequence sequenceModel) {
        this.sequences.add(sequenceModel);
        this.makeEqualLength();
        this.fireAlignmentModelEvent(new AlignmentStructureChangedEvent(this, this.sequences.size() - 1, this.sequences.size() - 1, AlignmentStructureChangedEvent.ModifiedStructure.ROWS, MAEvent.MAEventType.INSERT));
    }

    public void addSequence(int pos, Sequence sequenceModel) {
        this.sequences.add(pos, sequenceModel);
        this.makeEqualLength();
        this.fireAlignmentModelEvent(new AlignmentStructureChangedEvent(this, pos, pos, AlignmentStructureChangedEvent.ModifiedStructure.ROWS, MAEvent.MAEventType.INSERT));
    }

    public void removeSequence(int seqPos) {
        this.sequences.remove(seqPos);
        AlignmentStructureChangedEvent e = new AlignmentStructureChangedEvent(this, seqPos, seqPos, AlignmentStructureChangedEvent.ModifiedStructure.ROWS, MAEvent.MAEventType.DELETE);
        this.fireAlignmentModelEvent(e);
    }

    public Sequence getSequence(int position) {
        if (position >= 0 && this.sequences.size() > position) {
            return this.sequences.get(position);
        }
        return null;
    }

    public int getSequenceIndex(Sequence sequence) {
        return this.sequences.indexOf(sequence);
    }

    public char[] getColumn(int position) {
        char[] column = new char[this.sequences.size()];
        int col = 0;
        for (Sequence sequence : this.sequences) {
            if (sequence.length() > position) {
                column[col] = sequence.charAt(position);
            }
            ++col;
        }
        return column;
    }

    public Map<Character, Integer> getSymbolCounts(int position) {
        char[] column;
        HashMap<Character, Integer> symbolMap = new HashMap<Character, Integer>();
        char[] cArray = column = this.getColumn(position);
        int n = column.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (symbolMap.containsKey(c)) {
                symbolMap.put(c, (Integer)symbolMap.get(c) + 1);
            } else {
                symbolMap.put(c, 1);
            }
            ++n2;
        }
        return symbolMap;
    }

    public double getColumnConservation(int position) {
        int max = 0;
        for (Map.Entry<Character, Integer> entry : this.getSymbolCounts(position).entrySet()) {
            if (entry.getKey().charValue() == '-') continue;
            max = Math.max(entry.getValue(), max);
        }
        return (double)max / (double)this.getSequenceCount();
    }

    public double getSymbolConservation(char symbol, int position) {
        if (!this.getSymbolCounts(position).containsKey(Character.valueOf(symbol))) {
            return 0.0;
        }
        return (double)this.getSymbolCounts(position).get(Character.valueOf(symbol)).intValue() / (double)this.getSequenceCount();
    }

    public int length() {
        if (this.sequences.size() > 0) {
            return this.sequences.get(0).length();
        }
        return 0;
    }

    public void addAlignmentListener(AlignmentListener listener) {
        this.listeners.add(listener);
    }

    public void removeAlignmentListener(AlignmentListener listener) {
        this.listeners.remove(listener);
    }

    public Character characterAt(int sequence, int position) {
        return new Character(this.getColumn(position)[sequence]);
    }

    public int getSequenceCount() {
        return this.rows();
    }

    public int getLength() {
        return this.length();
    }

    public SequenceAlphabet getAlphabet() {
        return this.alphabet;
    }

    protected void fireAlignmentModelEvent(AlignmentStructureChangedEvent e) {
        for (AlignmentListener listener : this.listeners) {
            listener.alignmentStructureChanged(e);
        }
    }

    protected void fireAlignmentModelEvent(AlignmentChangedEvent e) {
        for (AlignmentListener listener : this.listeners) {
            listener.alignmentChanged(e);
        }
    }

    protected void fireAlignmentModelEvent(SequenceChangedEvent e) {
        int seq = this.sequences.indexOf(e.getSource());
        this.fireAlignmentModelEvent(new AlignmentChangedEvent(this, new Rectangle(e.getFirstPos(), seq, e.getLastPos() - e.getFirstPos(), seq), e.getType(), false));
    }

    @Override
    public void sequenceChanged(SequenceChangedEvent e) {
        if (!e.getSource().equals(this)) {
            this.fireAlignmentModelEvent(e);
        }
    }

    public ArrayList<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this.sequences.iterator();
    }

    public Matcher[] match(String regex) {
        Matcher[] matcher = new Matcher[this.getSequenceCount()];
        int i = 0;
        while (i < matcher.length) {
            matcher[i] = this.sequences.get(i).match(regex, true);
            ++i;
        }
        return matcher;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (Sequence sequence : this) {
            s.append(String.valueOf(sequence.getAlignedSequence()) + "\n");
        }
        return s.toString();
    }

    public void moveSequence(int from, int to) {
        Sequence seq = this.getSequence(from);
        this.sequences.remove(from);
        this.sequences.add(to, seq);
        AlignmentStructureChangedEvent e = new AlignmentStructureChangedEvent(this, Math.min(from, to), Math.max(from, to), AlignmentStructureChangedEvent.ModifiedStructure.ROWS, MAEvent.MAEventType.UPDATE);
        this.fireAlignmentModelEvent(e);
    }
}

