/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.MultipleAlignmentView;
import de.biozentrum.bioinformatik.alignment.RenderUtils;
import de.biozentrum.bioinformatik.alignment.events.AlignmentChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentListener;
import de.biozentrum.bioinformatik.alignment.events.AlignmentStructureChangedEvent;
import de.biozentrum.bioinformatik.alignment.visibility.SequenceVisibilityModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseWheelListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class MultipleAlignmentPanel
extends JPanel {
    private NameModel nameModel = new NameModel();
    private JScrollPane alignmentScroll;
    private SequenceNameList nameList = new SequenceNameList(this.nameModel);
    private MultipleAlignmentView alignmentView;
    private SequenceVisibilityModel visibilityModel;

    public MultipleAlignmentPanel() {
        JScrollPane nameScroll = new JScrollPane(this.nameList);
        nameScroll.setHorizontalScrollBarPolicy(31);
        nameScroll.setVerticalScrollBarPolicy(21);
        this.alignmentView = new MultipleAlignmentView();
        this.nameList.setSelectionModel(this.alignmentView.getSequenceSelectionModel());
        this.alignmentScroll = new JScrollPane(this.alignmentView);
        this.alignmentScroll.getVerticalScrollBar().setModel(nameScroll.getVerticalScrollBar().getModel());
        this.alignmentScroll.setHorizontalScrollBarPolicy(31);
        this.alignmentScroll.setVerticalScrollBarPolicy(21);
        JScrollBar horizontalSequenceBar = this.alignmentScroll.getHorizontalScrollBar();
        JScrollBar verticalSequenceBar = this.alignmentScroll.getVerticalScrollBar();
        JPanel alignmentPanel = new JPanel();
        alignmentPanel.setLayout(new BorderLayout());
        alignmentPanel.add((Component)horizontalSequenceBar, "North");
        alignmentPanel.add((Component)this.alignmentScroll, "Center");
        JScrollPane headerPane = new JScrollPane(this.alignmentView.getLogoView());
        headerPane.setHorizontalScrollBarPolicy(31);
        headerPane.setVerticalScrollBarPolicy(21);
        headerPane.getHorizontalScrollBar().setModel(horizontalSequenceBar.getModel());
        headerPane.setBorder(null);
        int scrollBarWidth = (int)verticalSequenceBar.getPreferredSize().getWidth();
        JPanel scrollSpacer = new JPanel();
        scrollSpacer.setBackground(Color.WHITE);
        scrollSpacer.setPreferredSize(new Dimension(scrollBarWidth, 10));
        JPanel headerView = new JPanel();
        headerView.setLayout(new BorderLayout());
        headerView.add((Component)headerPane, "Center");
        headerView.add((Component)scrollSpacer, "East");
        JPanel verticalScrollBarWrapper = new JPanel();
        JPanel cornerView = new JPanel();
        cornerView.setBackground(Color.WHITE);
        cornerView.setPreferredSize(new Dimension(scrollBarWidth, scrollBarWidth));
        verticalScrollBarWrapper.setLayout(new BorderLayout());
        verticalScrollBarWrapper.add((Component)cornerView, "North");
        verticalScrollBarWrapper.add((Component)verticalSequenceBar, "Center");
        JPanel alignmentScroller = new JPanel();
        alignmentScroller.setLayout(new BorderLayout());
        alignmentScroller.add((Component)headerView, "North");
        alignmentScroller.add((Component)alignmentPanel, "Center");
        alignmentScroller.add((Component)verticalScrollBarWrapper, "East");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)nameScroll.getHorizontalScrollBar(), "North");
        leftPanel.add((Component)nameScroll, "Center");
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(0, 30));
        spacer.setBackground(Color.WHITE);
        JPanel namesScroller = new JPanel();
        namesScroller.setLayout(new BorderLayout());
        namesScroller.add((Component)spacer, "North");
        namesScroller.add((Component)leftPanel, "Center");
        JSplitPane split = new JSplitPane(1);
        split.add((Component)namesScroller, 2);
        split.add((Component)alignmentScroller, 4);
        split.setDividerLocation(200);
        split.setResizeWeight(0.0);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        this.setFont(new Font("d", 1, 12));
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.alignmentView != null) {
            this.alignmentView.setFont(font);
        }
        if (this.nameList != null) {
            this.nameList.setFont(font);
        }
    }

    public JList getNameList() {
        return this.nameList;
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        super.addMouseWheelListener(listener);
        this.alignmentScroll.getViewport().addMouseWheelListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        super.removeMouseWheelListener(listener);
        this.alignmentScroll.getViewport().removeMouseWheelListener(listener);
    }

    public MultipleAlignmentView getAlignmentView() {
        return this.alignmentView;
    }

    public void setAlignment(MultipleAlignment alignment) {
        ((NameModel)this.nameList.getModel()).setModel(alignment);
        this.alignmentView.setAlignment(alignment);
        this.visibilityModel = new SequenceVisibilityModel(alignment);
        this.alignmentView.setVisibilityModel(this.visibilityModel);
    }

    public void showSelectedSequences() {
        ListSelectionModel selectionModel = this.alignmentView.getSequenceSelectionModel();
        int i = 0;
        while (i < this.alignmentView.getAlignment().getSequenceCount()) {
            if (selectionModel.isSelectedIndex(i)) {
                this.visibilityModel.show(i, i);
            }
            ++i;
        }
    }

    public void hideSelectedSequences() {
        ListSelectionModel selectionModel = this.alignmentView.getSequenceSelectionModel();
        int i = 0;
        while (i < this.alignmentView.getAlignment().getSequenceCount()) {
            if (selectionModel.isSelectedIndex(i)) {
                this.visibilityModel.hide(i, i);
            }
            ++i;
        }
    }

    private class NameModel
    extends DefaultListModel
    implements AlignmentListener {
        private MultipleAlignment model;

        private NameModel() {
        }

        public void setModel(MultipleAlignment model) {
            this.model = model;
            model.addAlignmentListener(this);
            this.fireContentsChanged(this, 0, model.getLength());
        }

        public int getSize() {
            if (this.model == null) {
                return 0;
            }
            return this.model.rows();
        }

        public Object getElementAt(int index) {
            return this.model.getSequence(index).getName();
        }

        public void alignmentChanged(AlignmentChangedEvent e) {
        }

        public void alignmentStructureChanged(AlignmentStructureChangedEvent e) {
            this.fireContentsChanged(this, 0, this.model.getLength());
        }
    }

    private class SequenceNameList
    extends JList {
        public SequenceNameList(ListModel model) {
            super(model);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.setFixedCellHeight(RenderUtils.pixelSizeForFont(font) + 5);
        }
    }
}

