/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.AlignmentEditor;
import de.biozentrum.bioinformatik.alignment.DefaultEditPolicy;
import de.biozentrum.bioinformatik.alignment.MACharacterRenderer;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.RenderUtils;
import de.biozentrum.bioinformatik.alignment.cursor.Cursor;
import de.biozentrum.bioinformatik.alignment.events.AlignmentChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentListener;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionListener;
import de.biozentrum.bioinformatik.alignment.events.AlignmentStructureChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.alignment.policy.AlignmentEditPolicy;
import de.biozentrum.bioinformatik.alignment.selection.AlignmentSelectionModel;
import de.biozentrum.bioinformatik.alignment.selection.DefaultAlignmentSelectionModel;
import de.biozentrum.bioinformatik.alignment.visibility.AlignmentVisibilityListener;
import de.biozentrum.bioinformatik.alignment.visibility.AlignmentVisibilityModel;
import de.biozentrum.bioinformatik.alignment.visibility.AlignmentVisibiltyChangedEvent;
import de.biozentrum.bioinformatik.alignment.visibility.DefaultVisibilityModel;
import de.biozentrum.bioinformatik.color.ColorChangedEvent;
import de.biozentrum.bioinformatik.color.ColorModelListener;
import de.biozentrum.bioinformatik.sequence.SequenceAlphabet;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;

public class MultipleAlignmentView
extends JPanel
implements AlignmentEditor,
KeyListener,
MouseListener,
MouseMotionListener,
AlignmentSelectionListener,
AlignmentListener,
AlignmentVisibilityListener,
ColorModelListener {
    private boolean needsRedraw = true;
    private boolean bufferedRedrawX;
    private boolean bufferedRedrawY;
    private AlignmentEditor.EditorMode editMode;
    private boolean editable = true;
    private int charBoxSize;
    private Rectangle2D currentViewRect;
    protected MultipleAlignment alignment;
    private BufferedImage buffer;
    private BufferedImage tmpBuffer;
    private MACharacterRenderer renderer = new MACharacterRenderer();
    private SequenceColorModel colorModel;
    private AlignmentVisibilityModel visibilityModel;
    private ListSelectionModel columnSelectionModel;
    private ListSelectionModel sequenceSelectionModel;
    private AlignmentSelectionModel maSelectionModel;
    private Point startDrag;
    private Point endDrag;
    protected Cursor cursor = new Cursor(new DefaultEditPolicy());
    private Rectangle2D draggedCursorRect;
    private Rectangle2D drawSelectionRect;
    private ConservationView conservationView;
    private LogoView logoView;
    private double currentX = 0.0;
    private double currentY = 0.0;
    private boolean ignoreGaps;
    private Rectangle alignmentScreenRect;
    boolean inSelectionProcess;

    public MultipleAlignmentView() {
        this.setEditorMode(AlignmentEditor.EditorMode.SELECT);
        this.setEditable(true);
        this.setFont(new Font("Curier", 1, 12));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.setVisibilityModel(new DefaultVisibilityModel());
        this.sequenceSelectionModel = new DefaultListSelectionModel();
        this.columnSelectionModel = new DefaultListSelectionModel();
        this.colorModel = SequenceColorModel.NUCLEOTIDE_MODEL;
        this.conservationView = new ConservationView();
        this.logoView = new LogoView();
    }

    public void setFont(Font font) {
        Rectangle rect;
        double centerX = 0.0;
        double centerY = 0.0;
        if (this.alignment != null) {
            rect = this.convertToRectangle(this.translateFromScreenRect(this.getVisibleRect()));
            centerX = rect.getCenterX();
            centerY = rect.getCenterY();
        }
        super.setFont(font);
        this.charBoxSize = RenderUtils.pixelSizeForFont(font) + 2;
        if (this.renderer != null) {
            this.renderer.setFont(font);
        }
        if (this.logoView != null) {
            this.logoView.setFont(font);
        }
        this.needsRedraw = true;
        if (this.alignment != null) {
            this.sizeToFit();
            rect = this.convertToRectangle(this.translateFromScreenRect(this.getVisibleRect()));
            double width = rect.getWidth();
            double height = rect.getHeight();
            double distX = width / 2.0;
            double distY = height / 2.0;
            double xAdjust = distX + centerX - (double)this.alignment.length();
            double yAdjust = distY + centerY - (double)this.alignment.getSequenceCount();
            if (xAdjust > 0.0) {
                width -= xAdjust;
            }
            if (yAdjust > 0.0) {
                height -= yAdjust;
            }
            double minX = centerX - distX;
            double minY = centerY - distY;
            if (minX < 0.0) {
                width += minX;
                minX = 0.0;
            }
            if (minY < 0.0) {
                height += minY;
                minY = 0.0;
            }
            Rectangle newRect = new Rectangle((int)minX, (int)minY, (int)width, (int)height);
            this.showRect(newRect);
        }
        this.repaint();
    }

    public JComponent getConservationView() {
        return this.conservationView;
    }

    public JComponent getLogoView() {
        return this.logoView;
    }

    public void setAlignment(MultipleAlignment model) {
        this.setAlignment(model, new DefaultAlignmentSelectionModel(model));
    }

    public void setAlignment(MultipleAlignment alignment, DefaultAlignmentSelectionModel model) {
        this.alignment = alignment;
        this.alignment.addAlignmentListener(this);
        this.alignment.addAlignmentListener(this.conservationView);
        this.alignment.addAlignmentListener(this.logoView);
        this.sizeToFit();
        if (alignment.getAlphabet().equals(SequenceAlphabet.AMINOACIDS)) {
            this.setSequenceColorModel(SequenceColorModel.AMINOACID_MODEL);
        } else if (alignment.getAlphabet().equals(SequenceAlphabet.RNA_STRUCTURE)) {
            this.setSequenceColorModel(SequenceColorModel.RNA_STRUCTURE_MODEL);
        } else {
            this.setSequenceColorModel(SequenceColorModel.NUCLEOTIDE_MODEL);
        }
        this.maSelectionModel = model;
        this.maSelectionModel.addAlignmentSelectionListener(this);
        this.cursor.setAlignment(alignment);
        this.logoView.setActive(true);
    }

    public void setSequenceColorModel(SequenceColorModel model) {
        this.colorModel = model;
        this.colorModel.addColorModelListener(this);
        this.needsRedraw = true;
        this.repaint();
    }

    public SequenceColorModel getSequenceColorModel() {
        return this.colorModel;
    }

    public MultipleAlignment getAlignment() {
        return this.alignment;
    }

    public void setEditPolicy(AlignmentEditPolicy editPolicy) {
        this.cursor.setEditPolicy(editPolicy);
    }

    public AlignmentEditPolicy getEditPolicy() {
        return this.cursor.getEditPolicy();
    }

    public void setVisibilityModel(AlignmentVisibilityModel visibilityModel) {
        this.visibilityModel = visibilityModel;
        visibilityModel.addVisibilityListener(this);
    }

    public void setSelectionModel(AlignmentSelectionModel model) {
        this.maSelectionModel = model;
        this.maSelectionModel.addAlignmentSelectionListener(this);
    }

    public void setIgnoreGaps(boolean flag) {
        this.ignoreGaps = flag;
    }

    public boolean ignoresGaps() {
        return this.ignoreGaps;
    }

    public AlignmentSelectionModel getSelectionModel() {
        return this.maSelectionModel;
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.columnSelectionModel;
    }

    public void setSequenceSelectionModel(ListSelectionModel model) {
        this.sequenceSelectionModel = model;
    }

    public ListSelectionModel getSequenceSelectionModel() {
        return this.sequenceSelectionModel;
    }

    public void showRect(Rectangle rect) {
        Rectangle r = this.convertToRectangle(this.translateToScreenRect(rect));
        this.scrollRectToVisible(r);
    }

    public void drawAlignment(Graphics2D g2, int seqFrom, int seqTo, int colFrom, int colTo, boolean doCaching) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = colFrom;
        while (i <= colTo) {
            AffineTransform old = g2.getTransform();
            int state = 1;
            AffineTransform right = new AffineTransform();
            if (i == 0) {
                state = 0;
                right.translate((double)this.charBoxSize * 1.5 + 2.0, 0.0);
            } else if (i == this.alignment.getLength() - 1) {
                state = 2;
            } else {
                right.translate(this.charBoxSize + 2, 0.0);
            }
            int j = seqFrom;
            while (j <= seqTo) {
                Character character = this.alignment.characterAt(j, i);
                boolean isSelected = this.maSelectionModel.isSelected(j, i, false);
                boolean isVisible = this.visibilityModel.isVisible(j, i);
                Color color = this.colorModel.getColorForChar(character.charValue());
                if (isSelected) {
                    color = this.colorModel.getSelectionColor();
                }
                if (isVisible) {
                    this.renderer.renderSymbol(g2, character, color, state, isSelected, true, doCaching);
                }
                g2.translate(0, this.charBoxSize + 3);
                ++j;
            }
            old.concatenate(right);
            g2.setTransform(old);
            ++i;
        }
    }

    public boolean isFocusable() {
        return true;
    }

    private void drawAlignment(Graphics2D g2) {
        Rectangle visibleRect = this.getVisibleRect();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
        int colFrom = this.xToColumn(((RectangularShape)visibleRect).getX());
        int colTo = Math.min(this.xToColumn(visibleRect.getMaxX()), this.alignment.getLength() - 1);
        int seqFrom = this.yToSequence(((RectangularShape)visibleRect).getY());
        int seqTo = Math.min(this.yToSequence(visibleRect.getMaxY()), this.alignment.getSequenceCount() - 1);
        g2.translate(this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
        this.drawAlignment(g2, seqFrom, seqTo, colFrom, colTo, true);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2;
        Rectangle visibleRect = this.getVisibleRect();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.buffer == null || ((RectangularShape)visibleRect).getHeight() != (double)this.buffer.getHeight() || ((RectangularShape)visibleRect).getWidth() != (double)this.buffer.getWidth()) {
            this.buffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
            this.tmpBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
            this.needsRedraw = true;
        }
        if (((RectangularShape)visibleRect).getX() != this.currentX) {
            this.currentX = ((RectangularShape)visibleRect).getX();
            this.currentY = ((RectangularShape)visibleRect).getY();
            this.bufferedRedrawX = true;
        }
        if (((RectangularShape)visibleRect).getY() != this.currentY) {
            this.currentX = ((RectangularShape)visibleRect).getX();
            this.currentY = ((RectangularShape)visibleRect).getY();
            this.bufferedRedrawY = true;
        }
        if (this.alignment != null && this.needsRedraw) {
            g2 = (Graphics2D)this.buffer.getGraphics();
            this.drawAlignment(g2);
            this.needsRedraw = false;
        } else if (this.alignment != null && (this.bufferedRedrawX || this.bufferedRedrawY)) {
            int seqTo;
            int seqFrom;
            int colTo;
            int colFrom;
            g2 = (Graphics2D)this.tmpBuffer.getGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform prev = g2.getTransform();
            g2.translate(this.currentViewRect.getX() - ((RectangularShape)visibleRect).getX(), this.currentViewRect.getY() - ((RectangularShape)visibleRect).getY());
            g2.drawImage((Image)this.buffer, 0, 0, null);
            g2.setTransform(prev);
            if (this.bufferedRedrawX) {
                if (((RectangularShape)visibleRect).getX() < this.currentViewRect.getX()) {
                    colFrom = this.xToColumn(((RectangularShape)visibleRect).getX());
                    colTo = Math.min(this.xToColumn(this.currentViewRect.getX()), this.alignment.getLength() - 1);
                    seqFrom = this.yToSequence(((RectangularShape)visibleRect).getY());
                    seqTo = Math.min(this.yToSequence(visibleRect.getMaxY()), this.alignment.getSequenceCount() - 1);
                    g2.translate(this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                    this.drawAlignment(g2, seqFrom, seqTo, colFrom, colTo, true);
                } else {
                    colFrom = this.xToColumn(this.currentViewRect.getMaxX());
                    colTo = Math.min(this.xToColumn(visibleRect.getMaxX()), this.alignment.getLength() - 1);
                    seqFrom = this.yToSequence(((RectangularShape)visibleRect).getY());
                    seqTo = Math.min(this.yToSequence(visibleRect.getMaxY()), this.alignment.getSequenceCount() - 1);
                    g2.translate(this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                    this.drawAlignment(g2, seqFrom, seqTo, colFrom, colTo, true);
                }
                this.bufferedRedrawX = false;
            }
            if (this.bufferedRedrawY) {
                if (((RectangularShape)visibleRect).getY() < this.currentViewRect.getY()) {
                    colFrom = this.xToColumn(visibleRect.getMinX());
                    colTo = Math.min(this.xToColumn(visibleRect.getMaxX()), this.alignment.length() - 1);
                    seqFrom = this.yToSequence(visibleRect.getMinY());
                    seqTo = Math.min(this.yToSequence(this.currentViewRect.getY()), this.alignment.getSequenceCount() - 1);
                    g2.translate(this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                    this.drawAlignment(g2, seqFrom, seqTo, colFrom, colTo, true);
                } else {
                    colFrom = this.xToColumn(visibleRect.getMinX());
                    colTo = Math.min(this.xToColumn(visibleRect.getMaxX()), this.alignment.length() - 1);
                    seqFrom = this.yToSequence(this.currentViewRect.getMaxY());
                    seqTo = Math.min(this.yToSequence(visibleRect.getMaxY()), this.alignment.getSequenceCount() - 1);
                    g2.translate(this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                    this.drawAlignment(g2, seqFrom, seqTo, colFrom, colTo, true);
                }
                this.bufferedRedrawY = false;
            }
            Graphics gb = this.buffer.getGraphics();
            gb.drawImage(this.tmpBuffer, 0, 0, null);
        }
        g.drawImage(this.buffer, (int)((RectangularShape)visibleRect).getX(), (int)((RectangularShape)visibleRect).getY(), null);
        if (this.editable && (this.cursor.isActive() || this.draggedCursorRect != null)) {
            Rectangle2D drawCursorRect = this.draggedCursorRect;
            if (drawCursorRect == null) {
                drawCursorRect = this.translateToScreenRect(this.cursor.getRect());
            }
            if (drawCursorRect != null) {
                Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
                g.setColor(c);
                ((Graphics2D)g).fill(drawCursorRect);
                if (this.isFocusOwner()) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                ((Graphics2D)g).draw(drawCursorRect);
            }
        }
        if (this.editMode == AlignmentEditor.EditorMode.SELECT && this.drawSelectionRect != null) {
            Color c = new Color(1.0f, 0.0f, 0.0f, 0.2f);
            g.setColor(c);
            ((Graphics2D)g).fill(this.drawSelectionRect);
            g.setColor(Color.RED);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            ((Graphics2D)g).draw(this.drawSelectionRect);
        }
        this.currentViewRect = visibleRect;
    }

    public double columnToX(int column) {
        if (column == 0) {
            return 0.0;
        }
        return column * (this.charBoxSize + 2) + this.charBoxSize / 2;
    }

    public double sequenceToY(int sequence) {
        return sequence * (this.charBoxSize + 3);
    }

    public int xToColumn(double x) {
        double tmp = x - (double)(this.charBoxSize / 2);
        if (tmp > 0.0) {
            return (int)(tmp / (double)(this.charBoxSize + 2));
        }
        return 0;
    }

    public int yToSequence(double y) {
        return (int)(y / (double)(this.charBoxSize + 3));
    }

    public String getToolTipText(MouseEvent e) {
        int seq = this.yToSequence(e.getY());
        int x = this.xToColumn(e.getX());
        if (seq > this.alignment.getSequenceCount() - 1 || x > this.alignment.getLength() - 1) {
            return "";
        }
        return "site:" + (x + 1) + " | " + this.alignment.getSequence(seq).getName();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.startDrag = e.getPoint();
        this.startDrag = new Point((int)this.columnToX(this.xToColumn(this.startDrag.getX())), (int)this.sequenceToY(this.yToSequence(this.startDrag.getY())));
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.endDrag = e.getPoint();
        this.endDrag = new Point((int)this.columnToX(this.xToColumn(this.endDrag.getX())), (int)this.sequenceToY(this.yToSequence(this.endDrag.getY())));
        double minXd = Math.min(this.startDrag.getX(), this.endDrag.getX());
        double minYd = Math.min(this.startDrag.getY(), this.endDrag.getY());
        double maxXd = Math.max(this.startDrag.getX(), this.endDrag.getX());
        double maxYd = Math.max(this.startDrag.getY(), this.endDrag.getY());
        minXd = Math.min(minXd, this.alignmentScreenRect.getMaxX());
        minYd = Math.min(minYd, this.alignmentScreenRect.getMaxY());
        maxXd = Math.min(maxXd, this.alignmentScreenRect.getMaxX());
        maxYd = Math.min(maxYd, this.alignmentScreenRect.getMaxY());
        int cols = this.alignment.getLength();
        int seqs = this.alignment.getSequenceCount();
        int minX = this.xToColumn(minXd);
        int minY = this.yToSequence(minYd);
        if (minX > cols - 1 || minY > seqs) {
            return;
        }
        minX = Math.min(minX, cols - 1);
        minY = Math.min(minY, seqs - 1);
        int maxX = Math.min(this.xToColumn(maxXd), cols - 1);
        int maxY = Math.min(this.yToSequence(maxYd), seqs - 1);
        if (this.editMode == AlignmentEditor.EditorMode.SELECT) {
            this.maSelectionModel.begin();
            Rectangle sel = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            if (this.maSelectionModel.isSelected(sel, this.ignoreGaps)) {
                if (!e.isShiftDown()) {
                    this.maSelectionModel.deselectAll();
                } else {
                    this.maSelectionModel.deselect(sel);
                }
            } else {
                if (!e.isShiftDown()) {
                    this.maSelectionModel.deselectAll();
                }
                this.maSelectionModel.select(sel, this.ignoreGaps);
            }
            this.drawSelectionRect = null;
            this.maSelectionModel.end();
        } else if (this.editMode == AlignmentEditor.EditorMode.EDIT) {
            this.draggedCursorRect = null;
            this.setCursorRect(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1));
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.endDrag = e.getPoint();
        this.endDrag = new Point((int)this.columnToX(this.xToColumn(this.endDrag.getX())), (int)this.sequenceToY(this.yToSequence(this.endDrag.getY())));
        double minXd = Math.min(this.startDrag.getX(), this.endDrag.getX());
        double minYd = Math.min(this.startDrag.getY(), this.endDrag.getY());
        double maxXd = Math.max(this.startDrag.getX(), this.endDrag.getX());
        double maxYd = Math.max(this.startDrag.getY(), this.endDrag.getY());
        if (this.editMode == AlignmentEditor.EditorMode.SELECT) {
            this.drawSelectionRect = new Rectangle2D.Double(minXd, minYd, maxXd - minXd + (double)this.charBoxSize, maxYd - minYd + (double)this.charBoxSize);
            this.drawSelectionRect = this.drawSelectionRect.createIntersection(this.alignmentScreenRect);
        } else if (this.editMode == AlignmentEditor.EditorMode.EDIT) {
            this.draggedCursorRect = new Rectangle2D.Double(minXd, minYd, maxXd - minXd + (double)this.charBoxSize, maxYd - minYd + (double)this.charBoxSize);
            this.draggedCursorRect = this.draggedCursorRect.createIntersection(this.alignmentScreenRect);
        }
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(r);
        this.repaint();
    }

    public void setCursorRect(Rectangle cursorRect) {
        if (this.cursor.getRect() != null && this.cursor.getRect().equals(cursorRect)) {
            return;
        }
        if (cursorRect.getMaxX() > (double)this.alignment.length() || cursorRect.getMaxY() > (double)this.alignment.getSequenceCount() || cursorRect.getMinX() < 0.0 || cursorRect.getMinY() < 0.0) {
            return;
        }
        this.cursor.setRect(cursorRect);
        this.cursor.setActive(true);
        this.showRect(cursorRect);
        this.repaint();
    }

    protected Rectangle2D translateToScreenRect(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        double minXd = this.columnToX((int)rect.getMinX());
        double minYd = this.sequenceToY((int)rect.getMinY());
        double maxXd = this.columnToX((int)rect.getMaxX());
        double maxYd = this.sequenceToY((int)rect.getMaxY());
        return new Rectangle2D.Double(minXd, minYd, maxXd - minXd, maxYd - minYd);
    }

    protected Rectangle2D translateFromScreenRect(Rectangle screenRect) {
        if (screenRect == null) {
            return null;
        }
        double minXd = this.xToColumn((int)screenRect.getMinX());
        double minYd = this.yToSequence((int)screenRect.getMinY());
        double maxXd = this.xToColumn((int)screenRect.getMaxX());
        double maxYd = this.yToSequence((int)screenRect.getMaxY());
        return new Rectangle2D.Double(minXd, minYd, maxXd - minXd, maxYd - minYd);
    }

    protected Rectangle convertToRectangle(Rectangle2D rectangle) {
        return new Rectangle((int)rectangle.getMinX(), (int)rectangle.getMinY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public void removeCursor() {
        this.cursor.setActive(false);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void selectionChanged(AlignmentSelectionEvent e) {
        if (!this.inSelectionProcess) {
            this.needsRedraw = true;
            this.repaint();
        }
    }

    public void selectionDidEnd() {
        this.inSelectionProcess = false;
        this.needsRedraw = true;
        this.repaint();
    }

    public void selectionWillBegin() {
        this.inSelectionProcess = true;
    }

    public void sizeToFit() {
        this.alignment.pack();
        int height = this.alignment.getSequenceCount() * (this.charBoxSize + 3);
        int width = (int)((double)((this.alignment.getLength() - 2) * (this.charBoxSize + 2) + 2) + 2.0 * (1.5 * (double)this.charBoxSize + 2.0));
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.alignmentScreenRect = new Rectangle(0, 0, width, height - 3);
        this.needsRedraw = true;
        this.conservationView.setPreferredSize(new Dimension(width, 30));
        this.conservationView.needsRedraw = true;
        this.conservationView.revalidate();
        this.conservationView.repaint();
        this.logoView.setPreferredSize(new Dimension(width, 30));
        this.logoView.needsRedraw = true;
        this.logoView.revalidate();
        this.logoView.repaint();
        this.revalidate();
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.cursor.isActive() && this.editable) {
            boolean beep = false;
            Rectangle cursorRect = this.cursor.getRect();
            switch (e.getKeyCode()) {
                case 127: {
                    if (this.cursor.delete()) break;
                    beep = true;
                    break;
                }
                case 8: {
                    if (this.cursor.performBackSpace()) break;
                    beep = true;
                    break;
                }
                case 32: {
                    if (this.cursor.insertChar('-')) break;
                    beep = true;
                    break;
                }
                case 37: {
                    Rectangle newCursor = new Rectangle((int)(cursorRect.getMinX() - 1.0), (int)cursorRect.getMinY(), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                    this.setCursorRect(newCursor);
                    e.consume();
                    break;
                }
                case 39: {
                    Rectangle newCursor = new Rectangle((int)(cursorRect.getMinX() + 1.0), (int)cursorRect.getMinY(), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                    this.setCursorRect(newCursor);
                    e.consume();
                    break;
                }
                case 38: {
                    Rectangle newCursor = new Rectangle((int)cursorRect.getMinX(), (int)(cursorRect.getMinY() - 1.0), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                    this.setCursorRect(newCursor);
                    e.consume();
                    break;
                }
                case 40: {
                    Rectangle newCursor = new Rectangle((int)cursorRect.getMinX(), (int)(cursorRect.getMinY() + 1.0), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                    this.setCursorRect(newCursor);
                    e.consume();
                    break;
                }
                default: {
                    if (this.cursor.insertChar(e.getKeyChar())) break;
                    beep = true;
                }
            }
            if (beep) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void alignmentChanged(AlignmentChangedEvent e) {
        Rectangle rect = e.getRectangle();
        Rectangle cursorRect = this.cursor.getRect();
        if (this.editable && cursorRect != null && (cursorRect.getMinY() >= rect.getMinY() && cursorRect.getMinY() < rect.getMaxY() || cursorRect.getMaxY() > rect.getMinY() && cursorRect.getMaxY() <= rect.getMaxY())) {
            Rectangle newCursor;
            if (cursorRect.getMinX() >= rect.getMinX() && e.getType() == MAEvent.MAEventType.INSERT) {
                newCursor = new Rectangle((int)(cursorRect.getMinX() + rect.getWidth()), (int)cursorRect.getY(), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                this.setCursorRect(newCursor);
            }
            if (cursorRect.getMinX() >= rect.getMaxX() && e.getType() == MAEvent.MAEventType.DELETE) {
                newCursor = new Rectangle((int)(cursorRect.getMinX() - rect.getWidth()), (int)cursorRect.getY(), (int)cursorRect.getWidth(), (int)cursorRect.getHeight());
                this.setCursorRect(newCursor);
            }
        }
        this.sizeToFit();
    }

    public void alignmentStructureChanged(AlignmentStructureChangedEvent e) {
        this.needsRedraw = true;
        if (e.getType() != MAEvent.MAEventType.UPDATE) {
            this.sizeToFit();
        }
        this.repaint();
    }

    public void visibiltyChanged(AlignmentVisibiltyChangedEvent e) {
        this.needsRedraw = true;
        this.repaint();
    }

    public void setEditorMode(AlignmentEditor.EditorMode editMode) {
        if (editMode == AlignmentEditor.EditorMode.EDIT) {
            this.cursor.setActive(true);
        } else if (editMode == AlignmentEditor.EditorMode.SELECT) {
            this.cursor.setActive(false);
        } else if (editMode == AlignmentEditor.EditorMode.NONE) {
            this.cursor.setActive(false);
        }
        this.editMode = editMode;
        this.repaint();
    }

    public AlignmentEditor.EditorMode getEditorMode() {
        return this.editMode;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setCursorMode(int cursorMode) {
        this.cursor.setCursorMode(cursorMode);
    }

    public int getCursorMode() {
        return this.cursor.getCursorMode();
    }

    public void colorModelChanged(ColorChangedEvent e) {
        this.needsRedraw = true;
        this.repaint();
    }

    private class ConservationView
    extends JPanel
    implements MouseListener,
    AlignmentListener {
        private boolean isActive = false;
        private boolean needsRecalculate = true;
        private boolean needsRedraw;
        private BufferedImage buffer;
        private BufferedImage tmpBuffer;
        private double currentX;
        private Rectangle2D currentViewRect;
        private ArrayList<Double> conservation;

        public ConservationView() {
            this.setPreferredSize(new Dimension(0, 30));
            this.setBackground(Color.WHITE);
            this.conservation = new ArrayList();
            this.addMouseListener(this);
        }

        public void setActive(boolean active) {
            if (active && this.needsRecalculate) {
                this.conservation.clear();
                int i = 0;
                while (i < MultipleAlignmentView.this.alignment.getLength()) {
                    this.conservation.add(i, this.getConservationAt(i));
                    ++i;
                }
                this.needsRecalculate = false;
            }
            this.isActive = active;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isActive) {
                Rectangle visibleRect = this.getVisibleRect();
                if (this.buffer == null || ((RectangularShape)visibleRect).getHeight() != (double)this.buffer.getHeight() || ((RectangularShape)visibleRect).getWidth() != (double)this.buffer.getWidth()) {
                    this.buffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    this.tmpBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    this.needsRedraw = true;
                }
                if (((RectangularShape)visibleRect).getX() != this.currentX) {
                    this.currentX = ((RectangularShape)visibleRect).getX();
                    MultipleAlignmentView.this.currentY = ((RectangularShape)visibleRect).getY();
                    MultipleAlignmentView.this.bufferedRedrawX = true;
                }
                if (MultipleAlignmentView.this.alignment != null && this.needsRedraw) {
                    Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
                    this.draw(g2);
                    this.needsRedraw = false;
                } else if (MultipleAlignmentView.this.alignment != null && MultipleAlignmentView.this.bufferedRedrawX) {
                    Graphics2D g2 = (Graphics2D)this.tmpBuffer.getGraphics();
                    g2.setColor(Color.WHITE);
                    g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    AffineTransform prev = g2.getTransform();
                    g2.translate(this.currentViewRect.getX() - ((RectangularShape)visibleRect).getX(), this.currentViewRect.getY() - ((RectangularShape)visibleRect).getY());
                    g2.drawImage((Image)this.buffer, 0, 0, null);
                    g2.setTransform(prev);
                    if (MultipleAlignmentView.this.bufferedRedrawX) {
                        int colFrom;
                        if (((RectangularShape)visibleRect).getX() < this.currentViewRect.getX()) {
                            colFrom = MultipleAlignmentView.this.xToColumn(((RectangularShape)visibleRect).getX());
                            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(this.currentViewRect.getX()), MultipleAlignmentView.this.alignment.getLength() - 1);
                            int seqFrom = MultipleAlignmentView.this.yToSequence(((RectangularShape)visibleRect).getY());
                            int seqTo = Math.min(MultipleAlignmentView.this.yToSequence(visibleRect.getMaxY()), MultipleAlignmentView.this.alignment.getSequenceCount() - 1);
                            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), MultipleAlignmentView.this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                            this.draw(g2, colFrom, colTo);
                        } else {
                            colFrom = MultipleAlignmentView.this.xToColumn(this.currentViewRect.getMaxX());
                            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(visibleRect.getMaxX()), MultipleAlignmentView.this.alignment.getLength() - 1);
                            int seqFrom = MultipleAlignmentView.this.yToSequence(((RectangularShape)visibleRect).getY());
                            int seqTo = Math.min(MultipleAlignmentView.this.yToSequence(visibleRect.getMaxY()), MultipleAlignmentView.this.alignment.getSequenceCount() - 1);
                            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), MultipleAlignmentView.this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                            this.draw(g2, colFrom, colTo);
                        }
                        MultipleAlignmentView.this.bufferedRedrawX = false;
                    }
                    Graphics gb = this.buffer.getGraphics();
                    gb.drawImage(this.tmpBuffer, 0, 0, null);
                }
                g.drawImage(this.buffer, (int)((RectangularShape)visibleRect).getX(), (int)((RectangularShape)visibleRect).getY(), null);
                this.currentViewRect = visibleRect;
            }
        }

        public void draw(Graphics2D g2) {
            Rectangle visibleRect = this.getVisibleRect();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), 30);
            int colFrom = MultipleAlignmentView.this.xToColumn(((RectangularShape)visibleRect).getX());
            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(visibleRect.getMaxX()), MultipleAlignmentView.this.alignment.getLength() - 1);
            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - visibleRect.getMinX(), 0.0);
            this.draw(g2, colFrom, colTo);
        }

        public void draw(Graphics2D g2, int colFrom, int colTo) {
            if (colFrom == 0) {
                g2.translate(MultipleAlignmentView.this.charBoxSize / 2, 0);
            }
            int i = colFrom;
            while (i <= colTo) {
                double conservation = this.conservation.get(i);
                double height = 26.0 * conservation;
                Rectangle2D.Double cRect = new Rectangle2D.Double(2.0, 30.0 - height - 2.0, MultipleAlignmentView.this.charBoxSize, height);
                Color fillColor = null;
                fillColor = conservation > 0.5 ? new Color((int)(255.0 * (1.0 - (conservation - 0.5) * 2.0)), 255, 0) : new Color(255, (int)(255.0 * conservation * 2.0), 0);
                g2.setColor(fillColor);
                g2.fill(cRect);
                g2.translate(MultipleAlignmentView.this.charBoxSize + 2, 0);
                ++i;
            }
        }

        public int getCharCount(int column, Character character) {
            int count = 0;
            int i = 0;
            while (i < MultipleAlignmentView.this.alignment.getSequenceCount()) {
                if (MultipleAlignmentView.this.alignment.characterAt(i, column).equals(character)) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public double getConservationAt(int column) {
            int max = 0;
            HashMap<Character, Integer> map = new HashMap<Character, Integer>();
            int i = 0;
            while (i < MultipleAlignmentView.this.alignment.getSequenceCount()) {
                Character character = MultipleAlignmentView.this.alignment.characterAt(i, column);
                if (character.charValue() != '-') {
                    Integer integer = (Integer)map.get(character);
                    integer = integer != null ? Integer.valueOf(integer + 1) : Integer.valueOf(1);
                    if (max < integer) {
                        max = integer;
                    }
                    map.put(character, integer);
                }
                ++i;
            }
            return (double)max / (double)MultipleAlignmentView.this.alignment.getSequenceCount();
        }

        public void mouseClicked(MouseEvent arg0) {
            this.setActive(!this.isActive);
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void alignmentChanged(AlignmentChangedEvent e) {
            if (this.isActive) {
                this.setActive(false);
            }
            this.needsRecalculate = true;
        }

        public void alignmentStructureChanged(AlignmentStructureChangedEvent e) {
            if (this.isActive) {
                this.setActive(false);
            }
            this.needsRecalculate = true;
        }
    }

    private class LogoView
    extends JPanel
    implements AlignmentListener,
    MouseListener {
        private boolean needsRedraw;
        private boolean isActive = false;
        private boolean needsRecalculate = true;
        private BufferedImage buffer;
        private BufferedImage tmpBuffer;
        private double currentX;
        private ArrayList<HashMap<Character, Double>> cache;
        private ArrayList<Double> hCache;
        private ArrayList<ArrayList<Character>> characterCache;
        private Font font;
        private Rectangle2D currentViewRect;
        private ArrayList<Double> conservation;
        private boolean showLogo = false;

        public LogoView() {
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(0, 30));
            this.cache = new ArrayList();
            this.hCache = new ArrayList();
            this.characterCache = new ArrayList();
            this.conservation = new ArrayList();
            this.setBackground(Color.WHITE);
        }

        public void setFont(Font f) {
            super.setFont(f);
            this.font = f;
            int size = f.getSize();
            this.font = new Font(f.getFontName(), f.getStyle(), size *= 2);
        }

        public void setActive(boolean active) {
            if (active && this.needsRecalculate) {
                this.cache.clear();
                this.hCache.clear();
                this.characterCache.clear();
                this.conservation.clear();
                int i = 0;
                while (i < MultipleAlignmentView.this.alignment.getLength()) {
                    this.fillCache(i);
                    ++i;
                }
                this.needsRecalculate = false;
            }
            this.isActive = active;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isActive) {
                Rectangle visibleRect = this.getVisibleRect();
                if (this.buffer == null || ((RectangularShape)visibleRect).getHeight() != (double)this.buffer.getHeight() || ((RectangularShape)visibleRect).getWidth() != (double)this.buffer.getWidth()) {
                    this.buffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    this.tmpBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    this.needsRedraw = true;
                }
                if (((RectangularShape)visibleRect).getX() != this.currentX) {
                    this.currentX = ((RectangularShape)visibleRect).getX();
                    MultipleAlignmentView.this.currentY = ((RectangularShape)visibleRect).getY();
                    MultipleAlignmentView.this.bufferedRedrawX = true;
                }
                if (MultipleAlignmentView.this.alignment != null && this.needsRedraw) {
                    Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
                    this.draw(g2);
                    this.needsRedraw = false;
                } else if (MultipleAlignmentView.this.alignment != null && MultipleAlignmentView.this.bufferedRedrawX) {
                    Graphics2D g2 = (Graphics2D)this.tmpBuffer.getGraphics();
                    g2.setColor(Color.WHITE);
                    g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
                    AffineTransform prev = g2.getTransform();
                    g2.translate(this.currentViewRect.getX() - ((RectangularShape)visibleRect).getX(), this.currentViewRect.getY() - ((RectangularShape)visibleRect).getY());
                    g2.drawImage((Image)this.buffer, 0, 0, null);
                    g2.setTransform(prev);
                    if (MultipleAlignmentView.this.bufferedRedrawX) {
                        int colFrom;
                        if (((RectangularShape)visibleRect).getX() < this.currentViewRect.getX()) {
                            colFrom = MultipleAlignmentView.this.xToColumn(((RectangularShape)visibleRect).getX());
                            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(this.currentViewRect.getX()), MultipleAlignmentView.this.alignment.getLength() - 1);
                            int seqFrom = MultipleAlignmentView.this.yToSequence(((RectangularShape)visibleRect).getY());
                            int seqTo = Math.min(MultipleAlignmentView.this.yToSequence(visibleRect.getMaxY()), MultipleAlignmentView.this.alignment.getSequenceCount() - 1);
                            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), MultipleAlignmentView.this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                            this.draw(g2, colFrom, colTo);
                        } else {
                            colFrom = MultipleAlignmentView.this.xToColumn(this.currentViewRect.getMaxX());
                            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(visibleRect.getMaxX()), MultipleAlignmentView.this.alignment.getLength() - 1);
                            int seqFrom = MultipleAlignmentView.this.yToSequence(((RectangularShape)visibleRect).getY());
                            int seqTo = Math.min(MultipleAlignmentView.this.yToSequence(visibleRect.getMaxY()), MultipleAlignmentView.this.alignment.getSequenceCount() - 1);
                            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), MultipleAlignmentView.this.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
                            this.draw(g2, colFrom, colTo);
                        }
                        MultipleAlignmentView.this.bufferedRedrawX = false;
                    }
                    Graphics gb = this.buffer.getGraphics();
                    gb.drawImage(this.tmpBuffer, 0, 0, null);
                }
                g.drawImage(this.buffer, (int)((RectangularShape)visibleRect).getX(), (int)((RectangularShape)visibleRect).getY(), null);
                this.currentViewRect = visibleRect;
            }
        }

        public void draw(Graphics2D g2) {
            Rectangle visibleRect = this.getVisibleRect();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), 30);
            int colFrom = MultipleAlignmentView.this.xToColumn(((RectangularShape)visibleRect).getX());
            int colTo = Math.min(MultipleAlignmentView.this.xToColumn(visibleRect.getMaxX()), MultipleAlignmentView.this.alignment.getLength() - 1);
            g2.translate(MultipleAlignmentView.this.columnToX(colFrom) - visibleRect.getMinX(), 0.0);
            this.draw(g2, colFrom, colTo);
        }

        public void draw(Graphics2D g2, int colFrom, int colTo) {
            if (this.showLogo && this.font.getSize() > 8) {
                g2.setFont(this.font);
                if (colFrom == 0) {
                    g2.translate(MultipleAlignmentView.this.charBoxSize / 2, 0);
                }
                int i = colFrom;
                while (i <= colTo) {
                    this.drawLogo(g2, i);
                    g2.translate(MultipleAlignmentView.this.charBoxSize + 2, 0);
                    ++i;
                }
            } else {
                if (colFrom == 0) {
                    g2.translate(MultipleAlignmentView.this.charBoxSize / 2, 0);
                }
                int i = colFrom;
                while (i <= colTo) {
                    double conservation = this.conservation.get(i);
                    double height = 26.0 * conservation;
                    Rectangle2D.Double cRect = new Rectangle2D.Double(2.0, 30.0 - height - 2.0, MultipleAlignmentView.this.charBoxSize, height);
                    Color fillColor = null;
                    fillColor = conservation > 0.5 ? new Color((int)(255.0 * (1.0 - (conservation - 0.5) * 2.0)), 255, 0) : new Color(255, (int)(255.0 * conservation * 2.0), 0);
                    g2.setColor(fillColor);
                    g2.fill(cRect);
                    g2.translate(MultipleAlignmentView.this.charBoxSize + 2, 0);
                    ++i;
                }
            }
        }

        public void fillCache(int column) {
            SequenceAlphabet alphabet = MultipleAlignmentView.this.alignment.getAlphabet();
            ArrayList<Character> characters = new ArrayList<Character>();
            HashMap<Character, Double> charToValue = new HashMap<Character, Double>();
            double h = 0.0;
            int i = 0;
            while (i < alphabet.size()) {
                Character c = alphabet.characterAt(i);
                double value = (double)this.getCharCount(column, c) / (double)MultipleAlignmentView.this.alignment.getSequenceCount();
                if (c.charValue() != '-' && value != 0.0) {
                    h += value * this.log2(value);
                    int j = 0;
                    j = 0;
                    while (j < characters.size()) {
                        if ((Double)charToValue.get(characters.get(j)) > value) break;
                        ++j;
                    }
                    characters.add(j, c);
                    charToValue.put(c, new Double(value));
                }
                ++i;
            }
            h = -h;
            this.cache.add(column, charToValue);
            this.hCache.add(column, h);
            this.characterCache.add(column, characters);
            this.conservation.add(column, this.getConservationAt(column));
        }

        public double getConservationAt(int column) {
            int max = 0;
            HashMap<Character, Integer> map = new HashMap<Character, Integer>();
            int i = 0;
            while (i < MultipleAlignmentView.this.alignment.getSequenceCount()) {
                Character character = MultipleAlignmentView.this.alignment.characterAt(i, column);
                if (character.charValue() != '-') {
                    Integer integer = (Integer)map.get(character);
                    integer = integer != null ? Integer.valueOf(integer + 1) : Integer.valueOf(1);
                    if (max < integer) {
                        max = integer;
                    }
                    map.put(character, integer);
                }
                ++i;
            }
            return (double)max / (double)MultipleAlignmentView.this.alignment.getSequenceCount();
        }

        public void drawLogo(Graphics2D g2, int column) {
            AffineTransform old = g2.getTransform();
            SequenceAlphabet alphabet = MultipleAlignmentView.this.alignment.getAlphabet();
            ArrayList<Character> characters = this.characterCache.get(column);
            double r = this.log2(alphabet.size() - 1) - this.hCache.get(column);
            g2.translate(0, 30);
            int i = 0;
            while (i < characters.size()) {
                Character c = characters.get(i);
                String s = String.valueOf(c.charValue());
                double height = 30.0 / this.log2(alphabet.size() - 1) * r * this.cache.get(column).get(c);
                TextLayout layout = new TextLayout(s, g2.getFont(), g2.getFontRenderContext());
                g2.setColor(MultipleAlignmentView.this.colorModel.getColorForChar(c.charValue()));
                g2.scale(1.0, height / layout.getBounds().getHeight());
                g2.drawString(s, (int)((17.0 - layout.getBounds().getWidth()) / 2.0), 0);
                g2.scale(1.0, layout.getBounds().getHeight() / height);
                g2.translate(0.0, -height);
                ++i;
            }
            g2.setTransform(old);
        }

        public double log2(double d) {
            return Math.log(d) / Math.log(2.0);
        }

        public int getCharCount(int column, Character character) {
            int count = 0;
            int i = 0;
            while (i < MultipleAlignmentView.this.alignment.getSequenceCount()) {
                if (MultipleAlignmentView.this.alignment.characterAt(i, column).equals(character)) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                this.setActive(!this.isActive);
            } else if (e.getButton() == 1) {
                this.showLogo = !this.showLogo;
                this.needsRedraw = true;
                this.repaint();
            }
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void alignmentChanged(AlignmentChangedEvent e) {
            if (this.isActive) {
                this.setActive(false);
            }
            this.needsRecalculate = true;
        }

        public void alignmentStructureChanged(AlignmentStructureChangedEvent e) {
            if (this.isActive) {
                this.setActive(false);
            }
            this.needsRecalculate = true;
        }
    }
}

