/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.MultipleAlignmentView;
import de.biozentrum.bioinformatik.alignment.RenderUtils;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionListener;
import de.biozentrum.bioinformatik.sequence.SequenceAlphabet;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SequenceLogoView
extends JPanel
implements MouseListener,
AlignmentSelectionListener,
ListSelectionListener {
    private boolean needsRedraw;
    private BufferedImage buffer;
    private double currentX;
    private double currentY;
    private boolean showLogo = true;
    private MultipleAlignmentView alignmentView;
    private MultipleAlignment alignment;
    private SequenceColorModel colorModel;
    private boolean inSelectionProcess;

    public SequenceLogoView(MultipleAlignmentView alignmentView) {
        this.colorModel = alignmentView.getSequenceColorModel();
        alignmentView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SequenceLogoView.this.needsRedraw = true;
                SequenceLogoView.this.repaint();
            }
        });
        this.alignmentView = alignmentView;
        this.alignment = alignmentView.getAlignment();
        this.addMouseListener(this);
        this.setBackground(Color.WHITE);
    }

    public void paintComponent(Graphics g) {
        this.alignment = this.alignmentView.getAlignment();
        this.setPreferredSize(new Dimension((int)this.alignmentView.getPreferredSize().getWidth(), 30));
        Rectangle visibleRect = this.getVisibleRect();
        if (this.buffer == null || ((RectangularShape)visibleRect).getHeight() != (double)this.buffer.getHeight() || ((RectangularShape)visibleRect).getWidth() != (double)this.buffer.getWidth()) {
            this.buffer = new BufferedImage((int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight(), 2);
            this.needsRedraw = true;
        }
        if (((RectangularShape)visibleRect).getX() != this.currentX || ((RectangularShape)visibleRect).getY() != this.currentY) {
            this.currentX = ((RectangularShape)visibleRect).getX();
            this.currentY = ((RectangularShape)visibleRect).getY();
            this.needsRedraw = true;
        }
        if (this.alignment == null || !this.needsRedraw) {
            // empty if block
        }
        Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
        this.draw(g2);
        this.needsRedraw = false;
        g.drawImage(this.buffer, (int)visibleRect.getMinX(), (int)visibleRect.getMinY(), null);
    }

    public void draw(Graphics2D g2) {
        this.setFont(this.alignmentView.getFont());
        int columnWidth = RenderUtils.pixelSizeForFont(this.alignmentView.getFont()) + 2;
        Rectangle visibleRect = this.alignmentView.getVisibleRect();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, (int)((RectangularShape)visibleRect).getWidth(), (int)((RectangularShape)visibleRect).getHeight());
        int colFrom = this.alignmentView.xToColumn(((RectangularShape)visibleRect).getX());
        int colTo = Math.min(this.alignmentView.xToColumn(visibleRect.getMaxX()), this.alignment.getLength() - 1);
        int seqFrom = this.alignmentView.yToSequence(((RectangularShape)visibleRect).getY());
        g2.translate(this.alignmentView.columnToX(colFrom) - ((RectangularShape)visibleRect).getX(), this.alignmentView.sequenceToY(seqFrom) - ((RectangularShape)visibleRect).getY());
        if (colFrom == 0) {
            g2.translate(columnWidth / 2, 0);
        }
        int i = colFrom;
        while (i <= colTo) {
            if (!this.showLogo) {
                double conservation = this.getConservationAt(i);
                double height = 26.0 * conservation;
                Rectangle2D.Double cRect = new Rectangle2D.Double(2.0, 30.0 - height - 2.0, columnWidth, height);
                Color fillColor = null;
                fillColor = conservation > 0.5 ? new Color((int)(255.0 * (1.0 - (conservation - 0.5) * 2.0)), 255, 0) : new Color(255, (int)(255.0 * conservation * 2.0), 0);
                g2.setColor(fillColor);
                g2.fill(cRect);
            } else {
                this.drawLogo(g2, i);
            }
            g2.translate(columnWidth + 2, 0);
            ++i;
        }
    }

    public void drawLogo(Graphics2D g2, int column) {
        AffineTransform old = g2.getTransform();
        g2.setFont(this.getFont());
        int columnWidth = RenderUtils.pixelSizeForFont(this.alignmentView.getFont()) + 2;
        SequenceAlphabet alphabet = this.alignment.getAlphabet();
        ArrayList<Character> characters = new ArrayList<Character>();
        HashMap<Character, Double> charToValue = new HashMap<Character, Double>();
        double h = 0.0;
        int i = 0;
        while (i < alphabet.size()) {
            Character c = alphabet.characterAt(i);
            double value = (double)this.getCharCount(column, c) / (double)this.alignment.getSequenceCount();
            if (c.charValue() != '-' && value != 0.0) {
                h += value * this.log2(value);
                int j = 0;
                j = 0;
                while (j < characters.size()) {
                    if ((Double)charToValue.get(characters.get(j)) > value) break;
                    ++j;
                }
                characters.add(j, c);
                charToValue.put(c, new Double(value));
            }
            ++i;
        }
        h = -h;
        double r = this.log2(alphabet.size() - 1) - h;
        g2.translate(0, 30);
        int i2 = 0;
        while (i2 < characters.size()) {
            Character c = (Character)characters.get(i2);
            String s = String.valueOf(c.charValue());
            double height = 30.0 / this.log2(alphabet.size() - 1) * r * (Double)charToValue.get(c);
            TextLayout layout = new TextLayout(s, g2.getFont(), g2.getFontRenderContext());
            g2.setColor(this.colorModel.getColorForChar(c.charValue()));
            int xOffset = (int)(((double)columnWidth - layout.getBounds().getWidth()) / 2.0);
            g2.translate(xOffset, 0);
            g2.scale(1.0, height / layout.getBounds().getHeight());
            g2.drawString(s, (int)((17.0 - layout.getBounds().getWidth()) / 2.0), 0);
            g2.scale(1.0, layout.getBounds().getHeight() / height);
            g2.translate((double)(-xOffset), -height);
            ++i2;
        }
        g2.setTransform(old);
    }

    public double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public int getCharCount(int column, Character character) {
        int count = 0;
        int i = 0;
        while (i < this.alignment.getSequenceCount()) {
            if (this.alignment.characterAt(i, column).equals(character)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public double getConservationAt(int column) {
        int max = 0;
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        int i = 0;
        while (i < this.alignment.getSequenceCount()) {
            Character character = this.alignment.characterAt(i, column);
            if (character.charValue() != '-') {
                Integer integer = (Integer)map.get(character);
                integer = integer != null ? new Integer(integer + 1) : new Integer(1);
                if (max < integer) {
                    max = integer;
                }
                map.put(character, integer);
            }
            ++i;
        }
        return (double)max / (double)this.alignment.getSequenceCount();
    }

    public void selectionChanged(AlignmentSelectionEvent e) {
        if (!this.inSelectionProcess) {
            this.needsRedraw = true;
            this.repaint();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        this.needsRedraw = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.showLogo = !this.showLogo;
        this.needsRedraw = true;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void selectionDidEnd() {
        this.inSelectionProcess = false;
        this.needsRedraw = true;
        this.repaint();
    }

    public void selectionWillBegin() {
        this.inSelectionProcess = true;
    }
}

