/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment.cursor;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.cursor.CursorMode;
import de.biozentrum.bioinformatik.alignment.cursor.ExclusiveCursorMode;
import de.biozentrum.bioinformatik.alignment.cursor.LeftSideCursorMode;
import de.biozentrum.bioinformatik.alignment.cursor.StandardCursorMode;
import de.biozentrum.bioinformatik.alignment.policy.AlignmentEditPolicy;
import java.awt.Rectangle;

public class Cursor {
    protected Rectangle rect;
    protected int cursorMode;
    protected CursorMode currentCursorMode;
    protected AlignmentEditPolicy editPolicy;
    protected MultipleAlignment alignment;
    protected boolean isActive;
    protected static CursorMode standardCursorMode = new StandardCursorMode();
    protected static CursorMode exclusiveCursorMode = new ExclusiveCursorMode();
    protected static CursorMode leftSideCursorMode = new LeftSideCursorMode();

    public Cursor(AlignmentEditPolicy editPolicy) {
        this.editPolicy = editPolicy;
        this.currentCursorMode = standardCursorMode;
        this.isActive = false;
    }

    public void setAlignment(MultipleAlignment alignment) {
        this.alignment = alignment;
        if (this.editPolicy != null) {
            this.editPolicy.setAlignment(alignment);
        }
    }

    public MultipleAlignment getAlignment() {
        return this.alignment;
    }

    public void setEditPolicy(AlignmentEditPolicy editPolicy) {
        this.editPolicy = editPolicy;
        if (this.alignment != null) {
            editPolicy.setAlignment(this.alignment);
        }
    }

    public AlignmentEditPolicy getEditPolicy() {
        return this.editPolicy;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean flag) {
        this.isActive = flag;
    }

    public boolean insertChar(char c) {
        return this.currentCursorMode.insertChar(c, this);
    }

    public boolean delete() {
        return this.currentCursorMode.delete(this);
    }

    public boolean performBackSpace() {
        return this.currentCursorMode.performBackSpace(this);
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void setCursorMode(int cursorMode) {
        this.cursorMode = cursorMode;
        switch (cursorMode) {
            case 0: {
                this.currentCursorMode = standardCursorMode;
                break;
            }
            case 2: {
                this.currentCursorMode = exclusiveCursorMode;
                break;
            }
            case 1: {
                this.currentCursorMode = leftSideCursorMode;
            }
        }
    }

    public int getCursorMode() {
        return this.cursorMode;
    }
}

