/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment.selection;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionListener;
import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.alignment.selection.AlignmentSelectionModel;
import de.biozentrum.bioinformatik.sequence.Sequence;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionEvent;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionListener;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultAlignmentSelectionModel
implements AlignmentSelectionModel,
SequenceSelectionListener {
    protected MultipleAlignment alignment;
    protected ArrayList<AlignmentSelectionListener> listeners;

    public DefaultAlignmentSelectionModel(MultipleAlignment alignment) {
        this.alignment = alignment;
        this.listeners = new ArrayList();
        for (Sequence sequence : alignment) {
            sequence.getSelectionModel().addSequenceSelectionListener(this);
        }
    }

    public MultipleAlignment getAlignment() {
        return this.alignment;
    }

    public void addAlignmentSelectionListener(AlignmentSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeAlignmentSelectionListener(AlignmentSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void begin() {
        Iterator<AlignmentSelectionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().selectionWillBegin();
        }
    }

    public void end() {
        Iterator<AlignmentSelectionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().selectionDidEnd();
        }
    }

    protected void fireSelectionChanged(AlignmentSelectionEvent e) {
        Iterator<AlignmentSelectionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().selectionChanged(e);
        }
    }

    public void select(Rectangle rect, boolean ignoreGaps) {
        if (this.isSelected(rect, ignoreGaps)) {
            return;
        }
        int seq = (int)rect.getMinY();
        while (seq < (int)rect.getMaxY()) {
            this.alignment.getSequence(seq).getSelectionModel().select((int)rect.getMinX(), (int)rect.getMaxX() - 1, ignoreGaps);
            ++seq;
        }
        AlignmentSelectionEvent e = new AlignmentSelectionEvent(this, null, rect, MAEvent.MAEventType.INSERT);
        this.fireSelectionChanged(e);
    }

    public void deselect(Rectangle rect) {
        if (this.isDeselected(rect, false)) {
            return;
        }
        int seq = (int)rect.getMinY();
        while (seq < (int)rect.getMaxY()) {
            this.alignment.getSequence(seq).getSelectionModel().deselect((int)rect.getMinX(), (int)rect.getMaxX() - 1);
            ++seq;
        }
        AlignmentSelectionEvent e = new AlignmentSelectionEvent(this, null, rect, MAEvent.MAEventType.DELETE);
        this.fireSelectionChanged(e);
    }

    public void deselectAll() {
        if (this.isDeselected(new Rectangle(0, 0, this.alignment.getLength(), this.alignment.getSequenceCount()), false)) {
            return;
        }
        for (Sequence sequence : this.alignment) {
            sequence.getSelectionModel().deselectAll(this);
        }
        AlignmentSelectionEvent e = new AlignmentSelectionEvent(this, null, new Rectangle(0, 0, this.alignment.length(), this.alignment.getSequenceCount()), MAEvent.MAEventType.DELETE);
        this.fireSelectionChanged(e);
    }

    public boolean isSelected(Rectangle rect, boolean ignoreGaps) {
        boolean tmp = true;
        int seq = (int)rect.getMinY();
        while (seq < (int)rect.getMaxY()) {
            if (!this.alignment.getSequence(seq).getSelectionModel().isSelected((int)rect.getMinX(), (int)rect.getMaxX() - 1, ignoreGaps)) {
                tmp = false;
                break;
            }
            ++seq;
        }
        return tmp;
    }

    public boolean isDeselected(Rectangle rect, boolean ignoreGaps) {
        boolean tmp = true;
        int seq = (int)rect.getMinY();
        while (seq < (int)rect.getMaxY()) {
            if (!this.alignment.getSequence(seq).getSelectionModel().isDeselected((int)rect.getMinX(), (int)rect.getMaxX() - 1, ignoreGaps)) {
                tmp = false;
                break;
            }
            ++seq;
        }
        return tmp;
    }

    public void select(int sequence, int column, boolean ignoreGaps) {
        this.select(new Rectangle(column, sequence, 1, 1), ignoreGaps);
    }

    public void deselect(int sequence, int column) {
        this.deselect(new Rectangle(column, sequence, 1, 1));
    }

    public boolean isSelected(int sequence, int column, boolean ignoreGaps) {
        return this.isSelected(new Rectangle(column, sequence, 1, 1), ignoreGaps);
    }

    public boolean isDeselected(int sequence, int column, boolean ignoreGaps) {
        return this.isDeselected(new Rectangle(column, sequence, 1, 1), ignoreGaps);
    }

    public void selectionChanged(SequenceSelectionEvent e) {
        if (e.getSource().equals(this)) {
            return;
        }
        int seq = -1;
        int i = 0;
        while (i < this.alignment.getSequenceCount()) {
            if (this.alignment.getSequence(i).getSelectionModel().equals(e.getSource())) {
                seq = i;
                break;
            }
            ++i;
        }
        AlignmentSelectionEvent ev = new AlignmentSelectionEvent(this, null, new Rectangle(e.getRange().getStart(), seq, e.getRange().getEnd() - e.getRange().getStart() + 1, 1), e.getType());
        this.fireSelectionChanged(ev);
    }
}

