/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.alignment.visibility;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.events.AlignmentChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentListener;
import de.biozentrum.bioinformatik.alignment.events.AlignmentStructureChangedEvent;
import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.alignment.visibility.AlignmentVisibiltyChangedEvent;
import de.biozentrum.bioinformatik.alignment.visibility.DefaultVisibilityModel;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SequenceVisibilityModel
extends DefaultVisibilityModel
implements AlignmentListener {
    private MultipleAlignment alignment;
    private ArrayList<Boolean> mask;

    public SequenceVisibilityModel(MultipleAlignment alignment) {
        this.alignment = alignment;
        alignment.addAlignmentListener(this);
        this.mask = new ArrayList(alignment.getSequenceCount());
        int i = 0;
        while (i < alignment.getSequenceCount()) {
            this.mask.add(true);
            ++i;
        }
    }

    private void setVisibility(int from, int to, boolean b) {
        int i = from;
        while (i <= to) {
            this.mask.set(i, b);
            ++i;
        }
    }

    public void show(int from, int to) {
        this.setVisibility(from, to, true);
        Rectangle r = new Rectangle(0, from, this.alignment.length(), to - from + 1);
        this.fireVisibilityChangedEvent(new AlignmentVisibiltyChangedEvent(this, r, AlignmentVisibiltyChangedEvent.Visibility.VISIBLE));
    }

    public void hide(int from, int to) {
        this.setVisibility(from, to, false);
        Rectangle r = new Rectangle(0, from, this.alignment.length(), to - from + 1);
        this.fireVisibilityChangedEvent(new AlignmentVisibiltyChangedEvent(this, r, AlignmentVisibiltyChangedEvent.Visibility.HIDDEN));
    }

    public boolean isVisible(int sequence, int column) {
        return this.mask.get(sequence);
    }

    public void alignmentChanged(AlignmentChangedEvent e) {
    }

    public void alignmentStructureChanged(AlignmentStructureChangedEvent e) {
        block3: {
            block2: {
                if (e.getType() != MAEvent.MAEventType.INSERT) break block2;
                int i = e.getFirstPos();
                while (i <= e.getLastPos()) {
                    this.mask.add(e.getFirstPos(), true);
                    ++i;
                }
                break block3;
            }
            if (e.getType() != MAEvent.MAEventType.DELETE) break block3;
            int i = e.getFirstPos();
            while (i <= e.getLastPos()) {
                this.mask.remove(e.getFirstPos());
                ++i;
            }
        }
    }
}

