/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.ca.CAComponentChangedEvent;
import de.biozentrum.bioinformatik.ca.CAComponentListener;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.CorrespondenceAnalysis;
import de.biozentrum.bioinformatik.ca.annotation.CAAnnotationProvider;
import de.biozentrum.bioinformatik.ca.annotation.CADefaultAnnotationProvider;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class CADefaultModel
implements CADataModel {
    protected int[] components;
    protected DoubleMatrix2D[] matrices = new DoubleMatrix2D[2];
    protected CAData[][] dataSets = new CAData[2][];
    protected ArrayList[] selection;
    protected ArrayList[] highlighting;
    protected ArrayList<CADataListener> dataListeners;
    protected ArrayList<CAComponentListener> componentListeners;
    private transient CAAnnotationProvider annotationProvider = new CADefaultAnnotationProvider();
    private DoubleMatrix1D information;
    private DoubleMatrix1D singularValues;
    private DoubleMatrix2D backupFF;
    private DoubleMatrix2D backupGG;
    protected double[][] componentValueRanges;

    public CADefaultModel(CorrespondenceAnalysis analysis) {
        this.componentValueRanges = new double[Math.min(analysis.getFF().rows(), analysis.getGG().rows())][2];
        this.setMatrix(0, analysis.getFF());
        this.setMatrix(1, analysis.getGG());
        this.backupFF = analysis.getFF().copy();
        this.backupGG = analysis.getGG().copy();
        this.information = analysis.getInformation();
        this.dataListeners = new ArrayList();
        this.componentListeners = new ArrayList();
        this.singularValues = analysis.getSingularValues();
        this.selection = new ArrayList[]{new ArrayList(), new ArrayList()};
        this.highlighting = new ArrayList[]{new ArrayList(), new ArrayList()};
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.components = nArray;
        this.setScaling(CADataModel.ScalingOptions.SPECIES);
    }

    public double[] getValues(int dataSetIdentifier, int position) {
        double[] values = new double[this.matrices[dataSetIdentifier].columns()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.matrices[dataSetIdentifier].get(position, i);
            ++i;
        }
        return values;
    }

    public CAData[] getDataInRect(int dataSetIdentifier, Rectangle2D rect) {
        ArrayList<CAData> list = new ArrayList<CAData>();
        int i = 0;
        while (i < this.dataSets[dataSetIdentifier].length) {
            double y;
            double x = this.dataSets[dataSetIdentifier][i].getValues()[0];
            if (rect.contains(x, y = this.dataSets[dataSetIdentifier][i].getValues()[1])) {
                list.add(this.getData(dataSetIdentifier, i));
            }
            ++i;
        }
        return list.toArray(new CAData[0]);
    }

    public void setMatrix(int dataSetIdentifier, DoubleMatrix2D matrix) {
        this.matrices[dataSetIdentifier] = matrix;
        this.dataSets[dataSetIdentifier] = new CADefaultData[matrix.rows()];
        int i = 0;
        while (i < matrix.rows()) {
            int j = 0;
            while (j < matrix.columns()) {
                double entry = matrix.get(i, j);
                if (this.componentValueRanges.length > j && entry > this.componentValueRanges[j][1]) {
                    this.componentValueRanges[j][1] = entry;
                }
                if (this.componentValueRanges.length > j && entry < this.componentValueRanges[j][0]) {
                    this.componentValueRanges[j][0] = entry;
                }
                ++j;
            }
            this.dataSets[dataSetIdentifier][i] = new CADefaultData(i, dataSetIdentifier);
            ++i;
        }
    }

    public DoubleMatrix2D getMatrix(int dataSetIdentifier) {
        return this.matrices[dataSetIdentifier];
    }

    public CAData[] getDataSet(int dataSetIdentifier) {
        if (dataSetIdentifier < 2) {
            return this.dataSets[dataSetIdentifier];
        }
        CAData[] bothSets = new CAData[this.dataSets[0].length + this.dataSets[1].length];
        System.arraycopy(this.dataSets[0], 0, bothSets, 0, this.dataSets[0].length);
        System.arraycopy(this.dataSets[1], 0, bothSets, this.dataSets[0].length, this.dataSets[1].length);
        return bothSets;
    }

    public void setComponents(int[] components) {
        int[] oldComponents = this.components;
        this.components = components;
        this.fireComponentChanged(oldComponents, components);
    }

    public void setScaling(CADataModel.ScalingOptions option) {
        DoubleMatrix2D speciesMatrix = this.backupFF.copy();
        DoubleMatrix2D siteMatrix = this.backupGG.copy();
        switch (option) {
            case SPECIES: {
                int i = 0;
                while (i < speciesMatrix.rows()) {
                    int j = 0;
                    while (j < this.singularValues.size()) {
                        speciesMatrix.setQuick(i, j, speciesMatrix.getQuick(i, j) / Math.sqrt(this.singularValues.getQuick(j)));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case SITES: {
                int i = 0;
                while (i < siteMatrix.rows()) {
                    int j = 0;
                    while (j < this.singularValues.size()) {
                        siteMatrix.setQuick(i, j, siteMatrix.getQuick(i, j) / Math.sqrt(this.singularValues.getQuick(j)));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case BOTH: {
                int j;
                int i = 0;
                while (i < speciesMatrix.rows()) {
                    j = 0;
                    while (j < this.singularValues.size()) {
                        speciesMatrix.setQuick(i, j, speciesMatrix.getQuick(i, j) / Math.sqrt(Math.sqrt(this.singularValues.getQuick(j))));
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < siteMatrix.rows()) {
                    j = 0;
                    while (j < this.singularValues.size()) {
                        siteMatrix.setQuick(i, j, siteMatrix.getQuick(i, j) / Math.sqrt(Math.sqrt(this.singularValues.getQuick(j))));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        this.setMatrix(0, speciesMatrix);
        this.setMatrix(1, siteMatrix);
        this.fireComponentChanged(this.getComponents(), this.getComponents());
    }

    protected void fireComponentChanged(int[] oldComponents, int[] newComponents) {
        CAComponentChangedEvent e = new CAComponentChangedEvent(this, oldComponents, newComponents);
        Iterator<CAComponentListener> it = this.componentListeners.iterator();
        while (it.hasNext()) {
            it.next().componentsChanged(e);
        }
    }

    public double getValue(int dataSetIdentifier, int position, int component) {
        return this.matrices[dataSetIdentifier].get(position, component);
    }

    public int[] getComponents() {
        return this.components;
    }

    public double minValueForComponent(int component) {
        return this.componentValueRanges[component][0];
    }

    public double maxValueForComponent(int component) {
        return this.componentValueRanges[component][1];
    }

    protected void fireSelectionChangedEvent(CADataChangedEvent e) {
        Iterator<CADataListener> it = this.dataListeners.iterator();
        while (it.hasNext()) {
            it.next().selectionChanged(e);
        }
    }

    protected void fireSelectedData(CAData[] data) {
        CADataChangedEvent e = new CADataChangedEvent(this, data, 0);
        this.fireSelectionChangedEvent(e);
    }

    protected void fireDeselectedData(CAData[] data) {
        CADataChangedEvent e = new CADataChangedEvent(this, data, 1);
        this.fireSelectionChangedEvent(e);
    }

    public void select(int dataSetIdentifier, int position) {
        CAData data = this.dataSets[dataSetIdentifier][position];
        if (!this.selection[dataSetIdentifier].contains(data)) {
            this.selection[dataSetIdentifier].add(data);
            this.fireSelectedData(new CAData[]{data});
        }
    }

    public void select(int[] dataSetIdentifier, int[] positions) {
        ArrayList<CAData> mySelection = new ArrayList<CAData>();
        int i = 0;
        while (i < dataSetIdentifier.length) {
            CAData data = this.dataSets[dataSetIdentifier[i]][positions[i]];
            if (!this.selection[dataSetIdentifier[i]].contains(data)) {
                this.selection[dataSetIdentifier[i]].add(data);
                mySelection.add(data);
            }
            ++i;
        }
        this.fireSelectedData(mySelection.toArray(new CAData[0]));
    }

    public void select(CAData[] data) {
        ArrayList<CAData> mySelection = new ArrayList<CAData>();
        int i = 0;
        while (i < data.length) {
            int dataSetIdentifier = data[i].getDataSetIdentifier();
            if (!this.selection[dataSetIdentifier].contains(data[i])) {
                this.selection[dataSetIdentifier].add(data[i]);
                mySelection.add(data[i]);
            }
            ++i;
        }
        this.fireSelectedData(mySelection.toArray(new CAData[0]));
    }

    public void removeSelection(int dataSetIdentifier, int position) {
        CAData data = this.dataSets[dataSetIdentifier][position];
        if (this.selection[dataSetIdentifier].contains(data)) {
            this.selection[dataSetIdentifier].remove(data);
            this.fireDeselectedData(new CAData[]{data});
        }
    }

    public void removeSelection(int[] dataSetIdentifier, int[] positions) {
        ArrayList<CAData> mySelection = new ArrayList<CAData>();
        int i = 0;
        while (i < dataSetIdentifier.length) {
            CAData data = this.dataSets[dataSetIdentifier[i]][positions[i]];
            if (!this.selection[dataSetIdentifier[i]].contains(data)) {
                this.selection[dataSetIdentifier[i]].remove(data);
                mySelection.add(data);
            }
            ++i;
        }
        this.fireDeselectedData(mySelection.toArray(new CAData[0]));
    }

    public void removeSelection(CAData[] data) {
        ArrayList<CAData> mySelection = new ArrayList<CAData>();
        int i = 0;
        while (i < data.length) {
            int dataSetIdentifier = data[i].getDataSetIdentifier();
            if (!this.selection[dataSetIdentifier].contains(data[i])) {
                this.selection[dataSetIdentifier].remove(data[i]);
                mySelection.add(data[i]);
            }
            ++i;
        }
        this.fireDeselectedData(mySelection.toArray(new CAData[0]));
    }

    public void clearSelection() {
        CAData[] data = this.getSelectedData();
        this.selection[0].clear();
        this.selection[1].clear();
        this.fireDeselectedData(data);
    }

    public CAData[] getSelectedData() {
        ArrayList sel = new ArrayList();
        sel.addAll(this.selection[0]);
        sel.addAll(this.selection[1]);
        CAData[] data = sel.toArray(new CAData[0]);
        return data;
    }

    public void addCADataListener(CADataListener listener) {
        if (!this.dataListeners.remove(listener)) {
            this.dataListeners.add(listener);
        }
    }

    public void removeCADataListener(CADataListener listener) {
        this.dataListeners.remove(listener);
    }

    public void addCAComponentListener(CAComponentListener listener) {
        if (!this.componentListeners.contains(listener)) {
            this.componentListeners.add(listener);
        }
    }

    public void removeCAComponentListener(CAComponentListener listener) {
        this.componentListeners.remove(listener);
    }

    public int numberOfComponents() {
        return Math.min(this.matrices[0].columns(), this.matrices[1].columns());
    }

    public int sizeOfDataSet(int dataSetIdentifer) {
        if (dataSetIdentifer < 2) {
            return this.dataSets[dataSetIdentifer].length;
        }
        if (dataSetIdentifer == 2) {
            return this.sizeOfDataSet(0) + this.sizeOfDataSet(1);
        }
        return 0;
    }

    public void setAnnotation(CAAnnotationProvider annotationProvider) {
        this.annotationProvider = annotationProvider;
    }

    public CAAnnotationProvider getAnnotation() {
        return this.annotationProvider;
    }

    public CAData getData(int dataSetIdentifier, int position) {
        return this.dataSets[dataSetIdentifier][position];
    }

    public CAData[] getSelectedData(int dataSetIdentifier) {
        switch (dataSetIdentifier) {
            case 0: 
            case 1: {
                return this.selection[dataSetIdentifier].toArray(new CAData[0]);
            }
        }
        return this.getSelectedData();
    }

    public DoubleMatrix1D getComponentInformations() {
        return this.information;
    }

    public void beginSelectionTransaction() {
        Iterator<CADataListener> it = this.dataListeners.iterator();
        while (it.hasNext()) {
            it.next().selectionTransactionWillBegin();
        }
    }

    public void commitSelectionTransaction() {
        Iterator<CADataListener> it = this.dataListeners.iterator();
        while (it.hasNext()) {
            it.next().selectionTransactionDidCommit();
        }
    }

    class CADefaultData
    implements CAData {
        private int dataSetIdentifier;
        private int position;
        private String name;

        public CADefaultData(String name, int position, int dataSet) {
            this.name = name;
            this.position = position;
            this.dataSetIdentifier = dataSet;
        }

        public CADefaultData(int position, int dataSet) {
            this.name = String.valueOf(dataSet) + "_" + position;
            this.position = position;
            this.dataSetIdentifier = dataSet;
        }

        public void select() {
            CADefaultModel.this.select(this.dataSetIdentifier, this.position);
        }

        public void deselect() {
            CADefaultModel.this.removeSelection(this.dataSetIdentifier, this.position);
        }

        public boolean isSelected() {
            return CADefaultModel.this.selection[this.dataSetIdentifier].contains(this);
        }

        public String getName() {
            return (String)CADefaultModel.this.annotationProvider.getAnnotation(this, "name");
        }

        public int getDataSetIdentifier() {
            return this.dataSetIdentifier;
        }

        public double[] getValues() {
            int[] components = CADefaultModel.this.getComponents();
            double[] values = CADefaultModel.this.getValues(this.dataSetIdentifier, this.position);
            double[] reducedValues = new double[components.length];
            int i = 0;
            while (i < components.length) {
                reducedValues[i] = values[components[i]];
                ++i;
            }
            return reducedValues;
        }

        public String identifier() {
            return String.valueOf(this.dataSetIdentifier) + "-" + this.position;
        }

        public int getPosition() {
            return this.position;
        }

        public Object getAnnotation(String key) {
            return CADefaultModel.this.annotationProvider.getAnnotation(this, key);
        }

        public String getAnnotationLabel(String key) {
            return CADefaultModel.this.annotationProvider.getLabel(key);
        }

        public Class getAnnotationClass(String key) {
            return CADefaultModel.this.annotationProvider.getClass(key);
        }

        public String[] getAnnotationKeys() {
            return CADefaultModel.this.annotationProvider.getKeys(this.dataSetIdentifier);
        }
    }
}

