/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.CADataProvider;
import de.biozentrum.bioinformatik.ca.CADefaultModel;
import java.io.Serializable;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrespondenceAnalysis
extends SwingWorker<CADataModel, Void>
implements Serializable {
    private static final long serialVersionUID = 1623928104529950183L;
    private transient CADataProvider dataProvider;
    private DoubleMatrix2D GG;
    private DoubleMatrix2D FF;
    private DoubleMatrix1D singularValues;
    private DoubleMatrix1D information;
    boolean transposed = false;

    public CorrespondenceAnalysis(CADataProvider provider) {
        this.dataProvider = provider;
    }

    public DoubleMatrix2D getFF() {
        return this.FF;
    }

    public DoubleMatrix2D getGG() {
        return this.GG;
    }

    public DoubleMatrix1D getSingularValues() {
        return this.singularValues;
    }

    public DoubleMatrix1D getInformation() {
        return this.information;
    }

    public DoubleMatrix1D getFirstValuesForComponent(int comp) {
        double[] row = new double[this.FF.columns()];
        int i = 0;
        while (i < this.FF.columns()) {
            row[i] = this.FF.getQuick(comp, i);
            ++i;
        }
        return new DenseDoubleMatrix1D(row);
    }

    public DoubleMatrix1D getSecondValuesForComponent(int comp) {
        double[] row = new double[this.GG.columns()];
        int i = 0;
        while (i < this.GG.columns()) {
            row[i] = this.GG.getQuick(comp, i);
            ++i;
        }
        return new DenseDoubleMatrix1D(row);
    }

    @Override
    protected CADataModel doInBackground() throws Exception {
        DoubleMatrix2D v;
        DoubleMatrix2D u;
        int j;
        this.setProgress(0);
        DoubleMatrix2D data = this.dataProvider.getDataMatrix();
        Algebra alg = new Algebra();
        if (data.rows() < data.columns()) {
            this.transposed = true;
            data = alg.transpose(data);
        }
        DoubleMatrix2D p = data.copy();
        double min = 0.0;
        int i = 0;
        while (i < p.rows()) {
            j = 0;
            while (j < p.columns()) {
                double tmp = p.getQuick(i, j);
                if (tmp < min) {
                    min = tmp;
                }
                ++j;
            }
            ++i;
        }
        min = Math.abs(min);
        i = 0;
        while (i < p.rows()) {
            j = 0;
            while (j < p.columns()) {
                p.setQuick(i, j, p.getQuick(i, j) + min + 1.0);
                ++j;
            }
            ++i;
        }
        this.setProgress(1);
        double sum = p.zSum();
        int i2 = 0;
        while (i2 < p.rows()) {
            int j2 = 0;
            while (j2 < p.columns()) {
                p.setQuick(i2, j2, p.getQuick(i2, j2) / sum);
                ++j2;
            }
            ++i2;
        }
        this.setProgress(2);
        DenseDoubleMatrix1D rowSums = new DenseDoubleMatrix1D(data.rows());
        DenseDoubleMatrix1D columnSums = new DenseDoubleMatrix1D(data.columns());
        int i3 = 0;
        while (i3 < p.rows()) {
            ((DoubleMatrix1D)rowSums).setQuick(i3, p.viewRow(i3).zSum());
            ++i3;
        }
        i3 = 0;
        while (i3 < p.columns()) {
            ((DoubleMatrix1D)columnSums).setQuick(i3, p.viewColumn(i3).zSum());
            ++i3;
        }
        this.setProgress(3);
        DoubleMatrix2D q = new DenseDoubleMatrix2D(rowSums.size(), columnSums.size());
        q = alg.multOuter(rowSums, columnSums, q);
        DoubleMatrix2D qSqrt = q.copy();
        qSqrt.assign(Functions.sqrt);
        DoubleMatrix2D f = p.copy();
        f = f.assign(q, Functions.minus);
        f.assign(qSqrt, Functions.div);
        p = null;
        q = null;
        qSqrt = null;
        data = null;
        data = null;
        this.setProgress(4);
        SingularValueDecomposition svd = new SingularValueDecomposition(f);
        this.setProgress(5);
        double[] singularValues = svd.getSingularValues();
        DenseDoubleMatrix1D sv = new DenseDoubleMatrix1D(singularValues);
        double svSum = ((DoubleMatrix1D)sv).zSum();
        double[] info = new double[singularValues.length];
        this.singularValues = sv;
        int i4 = 0;
        while (i4 < info.length) {
            info[i4] = ((DoubleMatrix1D)sv).getQuick(i4) / svSum;
            ++i4;
        }
        this.information = new DenseDoubleMatrix1D(info);
        this.FF = u = svd.getU();
        int i5 = 0;
        while (i5 < this.FF.rows()) {
            int j3 = 0;
            while (j3 < this.FF.columns()) {
                this.FF.setQuick(i5, j3, this.FF.getQuick(i5, j3) / Math.sqrt(((DoubleMatrix1D)rowSums).getQuick(i5)));
                ++j3;
            }
            ++i5;
        }
        this.setProgress(6);
        this.GG = v = svd.getV();
        int i6 = 0;
        while (i6 < this.GG.rows()) {
            int j4 = 0;
            while (j4 < this.GG.columns()) {
                this.GG.setQuick(i6, j4, this.GG.getQuick(i6, j4) / Math.sqrt(((DoubleMatrix1D)columnSums).getQuick(j4)));
                ++j4;
            }
            ++i6;
        }
        this.setProgress(7);
        if (this.transposed) {
            DoubleMatrix2D tmp = this.FF;
            this.FF = this.GG;
            this.GG = tmp;
        }
        return new CADefaultModel(this);
    }

    @Override
    public void done() {
        this.setProgress(8);
    }
}

