/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.MultipleAlignmentView;
import de.biozentrum.bioinformatik.alignment.selection.AlignmentSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class AlignmentComponent
extends JPanel {
    private MultipleAlignment model;
    private JList names;
    private ListSelectionModel sequenceSelectionModel;
    private MultipleAlignmentView view;

    public AlignmentComponent(MultipleAlignment model) {
        this.model = model;
        this.setLayout(new BorderLayout());
        this.names = new JList(new NameModel());
        this.sequenceSelectionModel = this.names.getSelectionModel();
        this.view = new MultipleAlignmentView();
        this.view.setAlignment(model);
        this.names.setFixedCellHeight((int)this.view.sequenceToY(1));
        JScrollPane pane = new JScrollPane(this.view);
        pane.setColumnHeaderView(this.view.getConservationView());
        pane.setBackground(Color.WHITE);
        pane.setRowHeaderView(this.names);
        this.add((Component)pane, "Center");
    }

    public AlignmentSelectionModel getAlignmentSelectionModel() {
        return this.view.getSelectionModel();
    }

    public ListSelectionModel getSequenceSelectionModel() {
        return this.sequenceSelectionModel;
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.view.getColumnSelectionModel();
    }

    private class NameModel
    extends DefaultListModel {
        private NameModel() {
        }

        public int getSize() {
            return AlignmentComponent.this.model.rows();
        }

        public Object getElementAt(int index) {
            return AlignmentComponent.this.model.getSequence(index).getName();
        }
    }
}

