/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment;

import de.biozentrum.bioinformatik.alignment.FontSizeChooser;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.MultipleAlignmentPanel;
import de.biozentrum.bioinformatik.alignment.MultipleAlignmentView;
import de.biozentrum.bioinformatik.alignment.selection.AlignmentSelectionModel;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import de.biozentrum.bioinformatik.ca.ext.alignment.CAMASelectionConverter;
import de.biozentrum.bioinformatik.ca.ext.alignment.MAExtension;
import de.biozentrum.bioinformatik.ca.ext.alignment.MAHMMPositionMap;
import de.biozentrum.bioinformatik.ca.gui.StatusComponent;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;

public class AlignmentExtension
implements MAExtension,
CAExtension,
CADataListener,
ListSelectionListener,
MAHMMPositionMap {
    private MultipleAlignment model;
    private AlphabetIndex alphabetIndex;
    private ListSelectionModel sequenceSelectionModel;
    private ListSelectionModel columnSelectionModel;
    private CADataModel caModel;
    private MultipleAlignmentPanel component;
    private FiniteAlphabet alphabet;
    private StatusComponent comp = new StatusComponent();
    private CAMASelectionConverter converter;
    private AlignmentSelectionModel maSelectionModel;
    private boolean[] columnMask;

    public MultipleAlignmentView getAlignmentView() {
        return this.component.getAlignmentView();
    }

    public void setAlignment(MultipleAlignment model, AlphabetIndex alphabetIndex, FiniteAlphabet alphabet) {
        this.model = model;
        this.alphabet = alphabet;
        this.alphabetIndex = alphabetIndex;
        this.component = new MultipleAlignmentPanel();
        this.component.getAlignmentView().addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                MultipleAlignmentView view = (MultipleAlignmentView)e.getSource();
                int seqPos = view.yToSequence(e.getY());
                int sitePos = view.xToColumn(e.getX());
                if (e.getButton() == 3) {
                    char c = view.getAlignment().getSequence(seqPos).charAt(sitePos);
                    SequenceColorModel colorModel = view.getSequenceColorModel();
                    Color newColor = JColorChooser.showDialog(AlignmentExtension.this.component.getParent(), "Choose Character Color", colorModel.getColorForChar(c));
                    if (newColor != null) {
                        colorModel.setColorForChar(newColor, c);
                    }
                }
            }
        });
        this.component.setAlignment(model);
        new FontSizeChooser(this.component);
        this.maSelectionModel = this.component.getAlignmentView().getSelectionModel();
        this.comp.setContent(this.component);
        this.comp.setStatus(0);
        this.sequenceSelectionModel = this.component.getNameList().getSelectionModel();
        this.sequenceSelectionModel.addListSelectionListener(this);
    }

    public void setColumnMask(boolean[] columnMask) {
        this.columnMask = columnMask;
    }

    public String getName() {
        return "Alignment View";
    }

    public void setModel(CADataModel model) {
        this.caModel = model;
        this.caModel.addCADataListener(this);
        this.converter = new CAMASelectionConverter(model, this.maSelectionModel, this.sequenceSelectionModel, this.columnSelectionModel, this.alphabetIndex, this.alphabet, this);
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void selectionChanged(CADataChangedEvent e) {
        CAData[] data = e.getData();
        if (e.getType() == 0) {
            int i = 0;
            while (i < data.length) {
                if (data[i].getDataSetIdentifier() == 0 && !this.sequenceSelectionModel.isSelectedIndex(data[i].getPosition())) {
                    this.sequenceSelectionModel.addSelectionInterval(data[i].getPosition(), data[i].getPosition());
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < data.length) {
                if (data[i].getDataSetIdentifier() == 0 && this.sequenceSelectionModel.isSelectedIndex(data[i].getPosition())) {
                    this.sequenceSelectionModel.removeSelectionInterval(data[i].getPosition(), data[i].getPosition());
                }
                ++i;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel listModel = (ListSelectionModel)e.getSource();
        CAData[] data = this.caModel.getDataSet(0);
        int i = e.getFirstIndex();
        while (i <= e.getLastIndex()) {
            if (data[i].isSelected() != listModel.isSelectedIndex(data[i].getPosition())) {
                if (listModel.isSelectedIndex(data[i].getPosition())) {
                    data[i].select();
                } else {
                    data[i].deselect();
                }
            }
            ++i;
        }
    }

    public int getHMMPosition(int maPosition) {
        int count = 1;
        if (!this.columnMask[maPosition]) {
            return -1;
        }
        int i = 0;
        while (i < maPosition) {
            if (this.columnMask[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getMAColumn(int hmmPosition) {
        int count = 0;
        while (hmmPosition > 0) {
            if (this.columnMask[count]) {
                --hmmPosition;
            }
            ++count;
        }
        return count - 1;
    }

    public void selectionTransactionDidCommit() {
    }

    public void selectionTransactionWillBegin() {
    }
}

