/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment;

import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataProvider;
import de.biozentrum.bioinformatik.ca.annotation.CAAnnotationProvider;
import de.biozentrum.bioinformatik.ca.ext.alignment.MAHMMPositionMap;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class CAMADataProvider
implements CAAnnotationProvider,
CADataProvider {
    private DoubleMatrix2D fisherScores;
    private MultipleAlignment model;
    private AlphabetIndex alphabetIndex;
    private MAHMMPositionMap positionMap;

    public CAMADataProvider(DoubleMatrix2D fisherScores, MultipleAlignment multipleAlignment, AlphabetIndex alphabetIndex) {
        this.fisherScores = fisherScores;
        this.model = multipleAlignment;
        this.alphabetIndex = alphabetIndex;
    }

    public void setPositionMap(MAHMMPositionMap positionMap) {
        this.positionMap = positionMap;
    }

    public DoubleMatrix2D getDataMatrix() {
        return this.fisherScores;
    }

    public Object getAnnotation(CAData data, String key) {
        if (key.equals("name")) {
            switch (data.getDataSetIdentifier()) {
                case 0: {
                    return this.model.getSequence(data.getPosition()).getName();
                }
                case 1: {
                    int column = data.getPosition() / this.alphabetIndex.getAlphabet().size() + 1;
                    Symbol c = this.alphabetIndex.symbolForIndex(data.getPosition() % this.alphabetIndex.getAlphabet().size());
                    String uppercase = "";
                    try {
                        uppercase = this.alphabetIndex.getAlphabet().getTokenization("token").tokenizeSymbol(c);
                    }
                    catch (IllegalSymbolException e) {
                        e.printStackTrace();
                    }
                    catch (BioException e) {
                        e.printStackTrace();
                    }
                    return String.valueOf(uppercase) + " (" + c.getName() + "), " + (this.positionMap != null ? this.positionMap.getMAColumn(column) + 1 : column + 1);
                }
            }
        } else if (key.equals("identifier")) {
            return String.valueOf(data.getDataSetIdentifier()) + "-" + data.getPosition();
        }
        return null;
    }

    public Class getClass(String key) {
        if (key.equals("name")) {
            return String.class;
        }
        if (key.equals("identifier")) {
            return String.class;
        }
        return null;
    }

    public String getLabel(String key) {
        return key;
    }

    public String getLabel(int dataSetIdentifier) {
        switch (dataSetIdentifier) {
            case 0: {
                return "Sequences";
            }
            case 1: {
                return "Aminoacids on HMM position";
            }
        }
        return "";
    }

    public String[] getKeys(int dataSetIdentifier) {
        return new String[]{"name", "identifier"};
    }
}

