/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionEvent;
import de.biozentrum.bioinformatik.alignment.events.AlignmentSelectionListener;
import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.alignment.selection.AlignmentSelectionModel;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.alignment.MAHMMPositionMap;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ListSelectionModel;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class CAMASelectionConverter
implements CADataListener,
AlignmentSelectionListener {
    private CADataModel caModel;
    private AlignmentSelectionModel maModel;
    private MultipleAlignment alignment;
    private AlphabetIndex alphabetIndex;
    private MAHMMPositionMap positionMap;
    private FiniteAlphabet alphabet;
    private Map<Character, Symbol> charToSym;
    private boolean blockedByCA = false;
    private boolean blockedByAlignment = false;
    private boolean multipleAlignmentSelections;
    private boolean multipleCASelections;

    public CAMASelectionConverter(CADataModel caModel, AlignmentSelectionModel maModel, ListSelectionModel sequenceModel, ListSelectionModel columnModel, AlphabetIndex alphabetIndex, FiniteAlphabet alphabet, MAHMMPositionMap positionMap) {
        this.caModel = caModel;
        this.maModel = maModel;
        this.alphabetIndex = alphabetIndex;
        this.alignment = maModel.getAlignment();
        this.positionMap = positionMap;
        this.alphabet = alphabet;
        this.charToSym = new HashMap<Character, Symbol>();
        caModel.addCADataListener(this);
        maModel.addAlignmentSelectionListener(this);
    }

    public void selectionChanged(CADataChangedEvent e) {
        if (!this.blockedByAlignment) {
            boolean wasBlocked = this.blockedByCA;
            this.blockedByCA = true;
            CAData[] data = e.getData();
            int i = 0;
            while (i < data.length) {
                int hmmCol;
                int col;
                if (data[i].getDataSetIdentifier() == 1 && (col = this.positionMap.getMAColumn(hmmCol = data[i].getPosition() / this.alphabetIndex.getAlphabet().size() + 1)) != -1) {
                    Symbol selectedSymbol = this.alphabetIndex.symbolForIndex(data[i].getPosition() % this.alphabetIndex.getAlphabet().size());
                    int j = 0;
                    while (j < this.alignment.getSequenceCount()) {
                        Character c = this.alignment.characterAt(j, col);
                        Symbol s = this.charToSym.get(c);
                        if (s == null) {
                            try {
                                s = this.alphabet.getTokenization("token").parseToken(String.valueOf(c));
                                this.charToSym.put(c, s);
                            }
                            catch (IllegalSymbolException e1) {
                                e1.printStackTrace();
                            }
                            catch (BioException e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (s.getMatches().contains(selectedSymbol) && !selectedSymbol.getMatches().getGapSymbol().equals(s)) {
                            if (e.getType() == 0) {
                                this.maModel.select(j, col, false);
                            } else {
                                this.maModel.deselect(j, col);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.blockedByCA = wasBlocked;
        }
    }

    public void updateWithEvent(AlignmentSelectionEvent e) {
        Rectangle rect = e.getRectangle();
        int seq = (int)rect.getMinY();
        while ((double)seq < rect.getMaxY()) {
            int column = (int)rect.getMinX();
            while ((double)column < rect.getMaxX()) {
                int hmmColumn;
                Character character = this.maModel.getAlignment().characterAt(seq, column);
                Symbol symbol = this.charToSym.get(character);
                if (symbol == null) {
                    try {
                        symbol = this.alphabet.getTokenization("token").parseToken(String.valueOf(character));
                        this.charToSym.put(character, symbol);
                    }
                    catch (IllegalSymbolException e1) {
                        e1.printStackTrace();
                    }
                    catch (BioException e1) {
                        e1.printStackTrace();
                    }
                }
                int maColumn = column;
                int i = 0;
                while (i < this.alignment.getSequenceCount()) {
                    if (this.alignment.characterAt(i, maColumn).equals(character)) {
                        if (e.getType() == MAEvent.MAEventType.INSERT && !this.maModel.isSelected(i, maColumn, false)) {
                            this.maModel.select(i, maColumn, false);
                        } else if (e.getType() == MAEvent.MAEventType.DELETE && this.maModel.isSelected(i, maColumn, false)) {
                            this.maModel.deselect(i, maColumn);
                        }
                    }
                    ++i;
                }
                if (character.charValue() != '-' && (hmmColumn = this.positionMap.getHMMPosition(maColumn)) != -1) {
                    Iterator<Symbol> iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
                    while (iterator.hasNext()) {
                        Symbol s = iterator.next();
                        if (s.equals(this.alphabet.getGapSymbol())) continue;
                        int fisherPos = -1;
                        try {
                            fisherPos = (hmmColumn - 1) * this.alphabetIndex.getAlphabet().size() + this.alphabetIndex.indexForSymbol(s);
                        }
                        catch (IllegalSymbolException e1) {
                            e1.printStackTrace();
                        }
                        if (fisherPos == -1) continue;
                        if (e.getType() == MAEvent.MAEventType.INSERT) {
                            this.caModel.select(1, fisherPos);
                            continue;
                        }
                        this.caModel.removeSelection(1, fisherPos);
                    }
                }
                ++column;
            }
            ++seq;
        }
    }

    public void selectionChanged(AlignmentSelectionEvent e) {
        if (!this.blockedByCA) {
            boolean wasBlocked = this.blockedByAlignment;
            this.blockedByAlignment = true;
            this.updateWithEvent(e);
            this.blockedByAlignment = wasBlocked;
        }
    }

    public void selectionDidEnd() {
        if (this.blockedByAlignment) {
            this.caModel.commitSelectionTransaction();
            this.blockedByAlignment = false;
            this.multipleAlignmentSelections = false;
        }
    }

    public void selectionWillBegin() {
        if (!this.blockedByCA) {
            this.blockedByAlignment = true;
            this.multipleAlignmentSelections = true;
            this.caModel.beginSelectionTransaction();
        }
    }

    public void selectionTransactionDidCommit() {
        if (this.blockedByCA) {
            this.maModel.end();
            this.blockedByCA = false;
            this.multipleCASelections = false;
        }
    }

    public void selectionTransactionWillBegin() {
        if (!this.blockedByAlignment) {
            this.blockedByCA = true;
            this.multipleCASelections = true;
            this.maModel.begin();
        }
    }
}

