/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojavax.Namespace;
import org.biojavax.SimpleNamespace;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AlignmentReader {
    private List<Sequence> order;
    private FiniteAlphabet alphabet;
    private File file;
    private Map<String, Sequence> map;
    private XMLReader reader;

    public AlignmentReader(File file, FiniteAlphabet alphabet, XMLReader reader) {
        this.alphabet = alphabet;
        this.file = file;
        this.map = new HashMap<String, Sequence>();
        this.order = new ArrayList<Sequence>();
        this.reader = reader;
    }

    public Sequence[] getSequenceOrder() {
        return this.order.toArray(new Sequence[1]);
    }

    public Alignment readAlignment() throws IOException, SAXException {
        ClustalHandler h = new ClustalHandler();
        this.reader.setContentHandler(h);
        this.reader.parse(new InputSource(new FileInputStream(this.file)));
        SimpleAlignment a = new SimpleAlignment(this.map);
        return a;
    }

    class ClustalHandler
    extends DefaultHandler {
        boolean startParse = false;
        String name = "";
        Namespace ns = null;

        ClustalHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("Sequence") && !atts.getValue("sequenceName").equals("CLUSTAL")) {
                this.startParse = true;
                this.name = atts.getValue("sequenceName");
                this.ns = new SimpleNamespace(namespaceURI);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("Sequence")) {
                this.startParse = false;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.startParse) {
                StringBuffer c = new StringBuffer();
                c.append(ch, start, length);
                try {
                    SimpleSymbolList list = new SimpleSymbolList(AlignmentReader.this.alphabet.getTokenization("token"), c.toString());
                    SimpleSequence s = new SimpleSequence(list, this.name, this.name, null);
                    AlignmentReader.this.map.put(s.getName(), s);
                    AlignmentReader.this.order.add(s);
                }
                catch (Exception e) {
                    System.out.println(c);
                    throw new SAXException(e.getMessage());
                }
            }
        }
    }
}

