/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.alignment.io;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.sequence.Sequence;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class ClustalReader
extends FileReader {
    public ClustalReader(String filename) throws FileNotFoundException {
        super(filename);
    }

    public MultipleAlignment readAlignment() throws IOException {
        MultipleAlignment model = new MultipleAlignment();
        BufferedReader br = new BufferedReader(this);
        ArrayList<StringBuffer> sequences = new ArrayList<StringBuffer>();
        ArrayList<String> names = new ArrayList<String>();
        int sequenceNum = 0;
        boolean isFirstBlock = true;
        String line = br.readLine();
        if (!line.startsWith("CLUSTAL W")) {
            throw new IOException();
        }
        br.readLine();
        br.readLine();
        line = br.readLine();
        while (line != null) {
            if (line.startsWith(" ")) {
                br.readLine();
            }
            if (line.startsWith(" ")) {
                sequenceNum = 0;
                line = br.readLine();
                isFirstBlock = false;
                continue;
            }
            if (isFirstBlock) {
                sequences.add(new StringBuffer(this.getSequence(line)));
                names.add(this.getName(line));
            } else {
                StringBuffer tmp = (StringBuffer)sequences.get(sequenceNum);
                tmp.append(this.getSequence(line));
            }
            ++sequenceNum;
            line = br.readLine();
        }
        int i = 0;
        while (i < sequences.size()) {
            model.addSequence(new Sequence((String)names.get(i), (StringBuffer)sequences.get(i)));
            ++i;
        }
        return model;
    }

    protected String getSequence(String line) {
        String[] splits = line.split(" ");
        return splits[splits.length - 1];
    }

    protected String getName(String line) {
        String[] splits = line.split(" ");
        return splits[0];
    }
}

