/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.inspector;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import de.biozentrum.bioinformatik.ca.gui.BrowserLauncher;
import de.biozentrum.bioinformatik.ca.gui.CAProtocolHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class CADataInspector
extends JComponent
implements CAExtension,
CADataListener {
    protected JEditorPane inspector = new JEditorPane();
    protected Hashtable protocolHandler = new Hashtable();
    protected CADataModel model = null;
    protected CAData data = null;
    protected boolean inSelectionTransaction;

    public CADataInspector() {
        this.inspector.setEditable(false);
        this.inspector.addHyperlinkListener(new CustomHyperlinkListener());
        EditorKit htmlKit = this.inspector.getEditorKitForContentType("text/html");
        HTMLDocument doc = (HTMLDocument)htmlKit.createDefaultDocument();
        this.inspector.setEditorKit(htmlKit);
        this.setLayout(new BorderLayout());
        this.add((Component)this.inspector, "Center");
    }

    public void registerProtocolHandler(CAProtocolHandler handler) {
        this.protocolHandler.put(handler.protocol(), handler);
    }

    private void setData(CAData data) {
        this.data = data;
        String html = "";
        this.setHTML(html);
    }

    public void setHTML(String html) {
        this.inspector.setText(html);
    }

    public String transform(Element element) throws TransformerException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(new File("data/data.xsl"));
        Transformer transformer = tFactory.newTransformer(stylesource);
        DOMSource source = new DOMSource(element);
        DOMResult dr = new DOMResult();
        PipedInputStream input = new PipedInputStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
        return ((ByteArrayOutputStream)result.getOutputStream()).toString();
    }

    public void setModel(CADataModel model) {
        this.model = model;
    }

    public JComponent getComponent() {
        return this;
    }

    public void selectionTransactionDidCommit() {
        this.updateData();
        this.inSelectionTransaction = false;
    }

    public void selectionTransactionWillBegin() {
        this.inSelectionTransaction = true;
    }

    public void updateData() {
        CAData[] selection = this.model.getSelectedData();
        if (selection.length == 1) {
            this.setData(selection[0]);
        } else if (selection.length == 0) {
            this.setData(null);
        }
    }

    public void selectionChanged(CADataChangedEvent e) {
        if (this.inSelectionTransaction) {
            return;
        }
        this.updateData();
    }

    public void highlightingChanged(CADataChangedEvent e) {
    }

    class CustomHyperlinkListener
    implements HyperlinkListener {
        CustomHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = e.getDescription();
                String[] protocolSplit = description.split(":\\/\\/");
                if (CADataInspector.this.protocolHandler.get(protocolSplit[0]) != null) {
                    ((CAProtocolHandler)CADataInspector.this.protocolHandler.get(protocolSplit[0])).invoke(protocolSplit[1], CADataInspector.this.data);
                } else {
                    try {
                        if (e.getURL() != null) {
                            BrowserLauncher.openURL(e.getURL().toString());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

