/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.plot;

import cern.colt.matrix.DoubleMatrix1D;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class CA2DComponentChooser
extends JComponent
implements ItemListener,
CAExtension {
    protected CADataModel model;
    protected JComboBox menuA;
    protected JComboBox menuB;

    public CA2DComponentChooser() {
        this.setLayout(new FlowLayout());
    }

    protected JComboBox generateMenu(String label, int itemcount, DoubleMatrix1D information) {
        JComboBox<String> menu = new JComboBox<String>();
        int i = 0;
        while (i < itemcount) {
            menu.addItem(String.valueOf(String.valueOf(i + 1)) + " ( " + (int)(information.get(i) * 100.0) + "% )");
            ++i;
        }
        return menu;
    }

    public void itemStateChanged(ItemEvent e) {
        int idxA = this.menuA.getSelectedIndex();
        int idxB = this.menuB.getSelectedIndex();
        this.model.setComponents(new int[]{idxA, idxB});
    }

    public void setModel(CADataModel model) {
        this.model = model;
        this.removeAll();
        int components = model.numberOfComponents();
        this.menuA = this.generateMenu("x Achse", components, model.getComponentInformations());
        this.menuB = this.generateMenu("y Achse", components, model.getComponentInformations());
        this.menuB.setSelectedIndex(1);
        this.menuA.addItemListener(this);
        this.menuB.addItemListener(this);
        this.add(this.menuA);
        this.add(this.menuB);
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public String getName() {
        return "Component Chooser";
    }
}

