/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.plot;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.plot.CAChartPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.ImageEncoder;
import org.jfree.chart.encoders.ImageEncoderFactory;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class CAPlot
extends JLayeredPane {
    public static final int ZOOM_MODE = 0;
    public static final int SELECT_MODE = 1;
    public static final int MOVE_MODE = 2;
    private int mouseMode;
    private XYPlot plot;
    private ChartRenderingInfo info;
    private int plotBufferWidth = 0;
    private int plotBufferHeight = 0;
    private CADataModel model = null;
    private CAChartPanel panel;
    private Point2D lastMousePos;
    private Rectangle2D selectionRect;
    private boolean drawSelectionRect = false;
    private SelectionPanel selectionPanel = new SelectionPanel();
    private Dimension lastSize;

    public void setModel(CADataModel model) {
        this.model = model;
        this.panel.setDataModel(model);
    }

    public CADataModel getModel() {
        return this.model;
    }

    private void configurePlot(XYDataset dataset, XYDataset selection) {
    }

    public CAPlot() {
        this.plot = new XYPlot();
        this.add((Component)this.panel, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.selectionPanel, JLayeredPane.DRAG_LAYER);
        this.lastSize = this.getSize();
    }

    public static void writeBufferedImage(BufferedImage image, String format, OutputStream outputStream) throws IOException {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(format);
        imageEncoder.encode(image, outputStream);
    }

    public void showAllData() {
        this.panel.restoreAutoBounds();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public void moveGraph(Point p) {
        if (this.lastMousePos != null) {
            ValueAxis domainAxis = this.plot.getDomainAxis();
            ValueAxis rangeAxis = this.plot.getRangeAxis();
            double domainValueNew = domainAxis.java2DToValue(p.getX(), this.panel.getScreenDataArea(), this.plot.getDomainAxisEdge());
            double domainValueOld = domainAxis.java2DToValue(this.lastMousePos.getX(), this.panel.getScreenDataArea(), this.plot.getDomainAxisEdge());
            double domainOffset = domainValueOld - domainValueNew;
            double rangeValueNew = rangeAxis.java2DToValue(p.getY(), this.panel.getScreenDataArea(), this.plot.getRangeAxisEdge());
            double rangeValueOld = rangeAxis.java2DToValue(this.lastMousePos.getY(), this.panel.getScreenDataArea(), this.plot.getRangeAxisEdge());
            double rangeOffset = rangeValueOld - rangeValueNew;
            domainAxis.setRange(domainAxis.getRange().getLowerBound() + domainOffset, domainAxis.getRange().getUpperBound() + domainOffset);
            rangeAxis.setRange(rangeAxis.getRange().getLowerBound() + rangeOffset, rangeAxis.getRange().getUpperBound() + rangeOffset);
        }
    }

    protected void setSelectionRectangle(MouseEvent e) {
        double width = (double)e.getX() - this.lastMousePos.getX();
        double height = (double)e.getY() - this.lastMousePos.getY();
        double originX = this.lastMousePos.getX();
        double originY = this.lastMousePos.getY();
        if (width < 0.0) {
            width = Math.abs(width);
            originX -= width;
        }
        if (height < 0.0) {
            height = Math.abs(height);
            originY -= height;
        }
        this.selectionRect = new Rectangle2D.Double(originX, originY, width, height);
        this.selectionPanel.repaint();
    }

    protected void selectItems() {
        this.selectionPanel.repaint();
    }

    protected void deselectItems() {
        this.model.clearSelection();
        this.selectionPanel.repaint();
    }

    public CAData[] getDataInRect(int dataSetIdentifier, Rectangle2D rect) {
        XYDataset dataset = this.plot.getDataset();
        ArrayList<CAData> list = new ArrayList<CAData>();
        int i = 0;
        while (i < dataset.getItemCount(dataSetIdentifier)) {
            double y;
            double x = dataset.getXValue(dataSetIdentifier, i);
            if (rect.contains(x, y = dataset.getYValue(dataSetIdentifier, i))) {
                list.add(this.model.getData(dataSetIdentifier, i));
            }
            ++i;
        }
        return list.toArray(new CAData[0]);
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity(e.getX() - insets.left, e.getY() - insets.top);
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    private void resizePlot(Dimension newSize) {
        this.selectionPanel.setBounds(0, 0, newSize.width, newSize.height);
        ValueAxis rangeAxis = this.plot.getRangeAxis();
        ValueAxis domainAxis = this.plot.getDomainAxis();
        double translatedWidthChange = this.java2DToLength(newSize.getWidth() - this.lastSize.getWidth(), domainAxis, this.panel.getScreenDataArea(), this.plot.getDomainAxisEdge());
        double translatedHeightChange = this.java2DToLength(newSize.getHeight() - this.lastSize.getHeight(), domainAxis, this.panel.getScreenDataArea(), this.plot.getDomainAxisEdge());
        domainAxis.setRange(domainAxis.getLowerBound() - translatedWidthChange / 2.0, domainAxis.getUpperBound() + translatedWidthChange / 2.0);
        rangeAxis.setRange(rangeAxis.getLowerBound() - translatedHeightChange / 2.0, rangeAxis.getUpperBound() + translatedHeightChange / 2.0);
        this.panel.setBounds(0, 0, newSize.width, newSize.height);
    }

    private double java2DToLength(double length, ValueAxis axis, Rectangle2D area, RectangleEdge edge) {
        double retval = -1.0;
        double origin = axis.java2DToValue(0.0, area, edge);
        double dest = axis.java2DToValue(length, area, edge);
        retval = dest - origin;
        return retval;
    }

    private class SelectionPanel
    extends JPanel {
        private SelectionPanel() {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (CAPlot.this.drawSelectionRect) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(10, 10, 10, 50));
                g2.fill(CAPlot.this.selectionRect);
                g2.setColor(Color.black);
                g2.draw(CAPlot.this.selectionRect);
            }
        }
    }
}

