/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.plot;

import de.biozentrum.bioinformatik.ca.CAComponentChangedEvent;
import de.biozentrum.bioinformatik.ca.CAComponentListener;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.annotation.CAAnnotationProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.dom.GenericDocument;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class CAXYPlot
extends XYPlot {
    private CADataModel model;
    private double plotBufferWidth;
    private double plotBufferHeight;
    private SelectedItemRenderer selectionRenderer;

    public CAXYPlot(CADataModel model) {
        this.model = model;
        this.setDomainPannable(true);
        this.setRangePannable(true);
        DS dataset = new DS(false);
        DS selection = new DS(true);
        NumberAxis xAxis = new NumberAxis(null);
        NumberAxis yAxis = new NumberAxis(null);
        Ellipse2D.Double firstShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        Area a = new Area(new Rectangle2D.Double(-3.0, -0.5, 6.0, 1.0));
        a.add(new Area(new Rectangle2D.Double(-0.5, -3.0, 1.0, 6.0)));
        Area secondShape = a;
        ItemRenderer renderer = new ItemRenderer(1);
        renderer.setSeriesShape(0, firstShape);
        renderer.setSeriesShape(1, secondShape);
        renderer.setToolTipGenerator(dataset);
        this.selectionRenderer = new SelectedItemRenderer(1);
        this.selectionRenderer.setSeriesShape(0, firstShape);
        this.selectionRenderer.setSeriesShape(1, secondShape);
        this.selectionRenderer.setToolTipGenerator(selection);
        this.selectionRenderer.setBaseItemLabelGenerator(selection);
        this.setDomainAxis(xAxis);
        this.setRangeAxis(yAxis);
        this.setDataset(dataset);
        this.setDataset(1, selection);
        this.setRenderer(renderer);
        this.setRenderer(1, this.selectionRenderer);
        this.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.setOrientation(PlotOrientation.VERTICAL);
    }

    public void showLabels(boolean labels) {
        this.selectionRenderer.setBaseItemLabelsVisible(labels);
    }

    public boolean showsLabels() {
        return this.selectionRenderer.getBaseItemLabelsVisible();
    }

    public void writeSVG(OutputStream outStream, PlotRenderingInfo renderingInfo, Dimension size) throws ParserConfigurationException, IOException {
        GenericDocument doc = new GenericDocument(null, new SVGDOMImplementation());
        SVGGraphics2D g = new SVGGraphics2D(doc);
        Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, size.width, size.height);
        this.draw(g, bufferArea, null, new PlotState(), renderingInfo);
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream, "UTF-8");
        g.stream(outWriter);
    }

    private class DS
    extends AbstractXYDataset
    implements XYItemLabelGenerator,
    CADataListener,
    CAComponentListener,
    XYToolTipGenerator {
        private boolean selectionOnly;
        private boolean inSelectionTransaction;

        public DS(boolean selectionOnly) {
            this.selectionOnly = selectionOnly;
            CAXYPlot.this.model.addCADataListener(this);
            CAXYPlot.this.model.addCAComponentListener(this);
        }

        public int getSeriesCount() {
            return 2;
        }

        public Comparable getSeriesKey(int series) {
            return new Integer(series);
        }

        public int getItemCount(int series) {
            if (this.selectionOnly) {
                return CAXYPlot.this.model.getSelectedData(series).length;
            }
            return CAXYPlot.this.model.getDataSet(series).length;
        }

        public Number getX(int series, int item) {
            if (this.selectionOnly) {
                return CAXYPlot.this.model.getSelectedData(series)[item].getValues()[0];
            }
            return CAXYPlot.this.model.getData(series, item).getValues()[0];
        }

        public Number getY(int series, int item) {
            if (this.selectionOnly) {
                return CAXYPlot.this.model.getSelectedData(series)[item].getValues()[1];
            }
            return CAXYPlot.this.model.getData(series, item).getValues()[1];
        }

        public void notifyListeners() {
            if (this.selectionOnly) {
                this.notifyListeners(new DatasetChangeEvent(this, this));
            }
        }

        public void selectionChanged(CADataChangedEvent e) {
            if (this.inSelectionTransaction) {
                return;
            }
            this.notifyListeners();
        }

        public void componentsChanged(CAComponentChangedEvent e) {
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }

        public String generateToolTip(XYDataset data, int series, int item) {
            CAAnnotationProvider annotation = CAXYPlot.this.model.getAnnotation();
            CAData d = null;
            d = this.selectionOnly ? CAXYPlot.this.model.getSelectedData(series)[item] : CAXYPlot.this.model.getDataSet(series)[item];
            return (String)annotation.getAnnotation(d, "name");
        }

        public String generateLabel(XYDataset dataset, int series, int item) {
            if (this.selectionOnly) {
                return this.generateToolTip(dataset, series, item);
            }
            return null;
        }

        public void selectionTransactionDidCommit() {
            this.notifyListeners();
            this.inSelectionTransaction = false;
        }

        public void selectionTransactionWillBegin() {
            this.inSelectionTransaction = true;
        }
    }

    private class ItemRenderer
    extends StandardXYItemRenderer {
        public ItemRenderer(int shapes) {
            super(shapes);
        }

        public Paint getItemPaint(int series, int item) {
            return series == 0 ? Color.GREEN : Color.BLUE;
        }
    }

    private class SelectedItemRenderer
    extends StandardXYItemRenderer {
        public SelectedItemRenderer(int shapes) {
            super(shapes);
        }

        public Paint getItemPaint(int series, int item) {
            return Color.RED;
        }
    }
}

