/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.selection;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import de.biozentrum.bioinformatik.ca.gui.CADataTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CASelectionExtension
extends JPanel
implements CAExtension {
    private CADataModel model;

    public CASelectionExtension() {
        this.setName("Selection");
        this.setLayout(new BorderLayout());
    }

    public void setModel(CADataModel model) {
        this.model = model;
        if (model == null) {
            return;
        }
        JSplitPane split = new JSplitPane(0);
        JTable first = new JTable(new CADataSelectionModel(model, 0));
        first.setAutoResizeMode(3);
        first.setTableHeader(null);
        first.setDefaultRenderer(CAData.class, new CADataTableCellRenderer());
        TableColumn checkBoxCol = first.getColumnModel().getColumn(0);
        checkBoxCol.setMinWidth(10);
        checkBoxCol.setMaxWidth(30);
        checkBoxCol.setPreferredWidth(20);
        JTable second = new JTable(new CADataSelectionModel(model, 1));
        second.setAutoResizeMode(3);
        second.setTableHeader(null);
        second.setDefaultRenderer(CAData.class, new CADataTableCellRenderer());
        checkBoxCol = second.getColumnModel().getColumn(0);
        checkBoxCol.setMinWidth(10);
        checkBoxCol.setMaxWidth(30);
        checkBoxCol.setPreferredWidth(20);
        split.add((Component)new JScrollPane(first), "top");
        split.add((Component)new JScrollPane(second), "bottom");
        this.removeAll();
        this.add((Component)split, "Center");
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    private class CADataSelectionModel
    extends DefaultTableModel
    implements CADataListener {
        private CADataModel caModel;
        private int dataSetIdentifier;
        private boolean inSelectionTransaction;

        public CADataSelectionModel(CADataModel caModel, int dataSetIdentifier) {
            this.caModel = caModel;
            caModel.addCADataListener(this);
            this.dataSetIdentifier = dataSetIdentifier;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Boolean.class;
            }
            return CAData.class;
        }

        public int getRowCount() {
            if (this.caModel == null) {
                return 0;
            }
            return this.caModel.getSelectedData(this.dataSetIdentifier).length;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void setValueAt(Object value, int row, int column) {
            CAData data = this.caModel.getSelectedData(this.dataSetIdentifier)[row];
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    data.select();
                } else {
                    data.deselect();
                }
            }
        }

        public Object getValueAt(int row, int column) {
            CAData data = this.caModel.getSelectedData(this.dataSetIdentifier)[row];
            if (column == 0) {
                return new Boolean(data.isSelected());
            }
            return data;
        }

        public void selectionChanged(CADataChangedEvent e) {
            if (this.inSelectionTransaction) {
                return;
            }
            this.fireTableDataChanged();
        }

        public void selectionTransactionDidCommit() {
            this.fireTableDataChanged();
            this.inSelectionTransaction = false;
        }

        public void selectionTransactionWillBegin() {
            this.inSelectionTransaction = true;
        }
    }
}

