/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.selection;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

public class SelectionExtension
implements CAExtension {
    private JTable table;
    private CADataModel model;
    private SelectionTableModel tableModel = new SelectionTableModel();
    private JScrollPane scrollPane;

    public SelectionExtension() {
        this.table = new JTable(this.tableModel);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    ListSelectionModel selModel = SelectionExtension.this.table.getSelectionModel();
                    ArrayList<CAData> toRemove = new ArrayList<CAData>();
                    int i = selModel.getMinSelectionIndex();
                    while (i <= selModel.getMaxSelectionIndex()) {
                        if (selModel.isSelectedIndex(i)) {
                            toRemove.add(SelectionExtension.this.model.getSelectedData()[i]);
                        }
                        ++i;
                    }
                    for (CAData d : toRemove) {
                        d.deselect();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.scrollPane = new JScrollPane(this.table);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public String getName() {
        return "Selection";
    }

    public void setModel(CADataModel model) {
        this.model = model;
        model.addCADataListener(this.tableModel);
    }

    private class SelectionTableModel
    extends AbstractTableModel
    implements CADataListener {
        private boolean inSelectionTransaction = false;

        private SelectionTableModel() {
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Type";
            }
            return "Name";
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (SelectionExtension.this.model == null) {
                return 0;
            }
            return SelectionExtension.this.model.getSelectedData().length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            CAData data = SelectionExtension.this.model.getSelectedData()[rowIndex];
            if (columnIndex == 0) {
                return data.getDataSetIdentifier() == 0 ? "Seq" : "Site";
            }
            return data.getName();
        }

        public void selectionChanged(CADataChangedEvent e) {
            if (this.inSelectionTransaction) {
                return;
            }
            this.fireTableDataChanged();
        }

        public void selectionTransactionDidCommit() {
            this.fireTableDataChanged();
            this.inSelectionTransaction = false;
        }

        public void selectionTransactionWillBegin() {
            this.inSelectionTransaction = true;
        }
    }
}

