/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.selection;

import de.biozentrum.bioinformatik.ca.CADataChangedEvent;
import de.biozentrum.bioinformatik.ca.CADataListener;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.ext.CAExtension;
import de.biozentrum.bioinformatik.cama.CAMAConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectionStorageExtension
implements CAExtension {
    private CADataModel model;
    private JScrollPane component;
    private JTable table;
    private CAMAConfiguration configuration;
    private transient boolean initiatedSelection;
    private transient boolean doNotClear;

    public SelectionStorageExtension(CAMAConfiguration configuration) {
        this.configuration = configuration;
        this.table = new JTable(configuration.getSelectionStore().getTableModel());
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && (selectedRow = SelectionStorageExtension.this.table.getSelectedRow()) > -1) {
                    SelectionStorageExtension.this.configuration.getSelectionStore().remove(selectedRow);
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = SelectionStorageExtension.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    SelectionStorageExtension.this.model.clearSelection();
                    SelectionStorageExtension.this.model.select(SelectionStorageExtension.this.configuration.getSelectionStore().getSelection(selectedRow).getData()[0]);
                    SelectionStorageExtension.this.model.select(SelectionStorageExtension.this.configuration.getSelectionStore().getSelection(selectedRow).getData()[1]);
                }
            }
        });
        this.component = new JScrollPane(this.table);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getName() {
        return "Selection Store";
    }

    public void setModel(CADataModel model) {
        this.model = model;
        this.model.addCADataListener(new CADataListener(){

            public void selectionChanged(CADataChangedEvent e) {
                if (!SelectionStorageExtension.this.doNotClear) {
                    SelectionStorageExtension.this.table.clearSelection();
                }
            }

            public void selectionTransactionDidCommit() {
            }

            public void selectionTransactionWillBegin() {
            }
        });
    }

    public Action createSelectionAction(char key) {
        return new SelectionAction(key);
    }

    private class SelectionAction
    extends AbstractAction {
        private char key;

        public SelectionAction(char key) {
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 2) != 0 || (e.getModifiers() & 0x80) != 0) {
                SelectionStorageExtension.this.configuration.getSelectionStore().addSelection("Selection", this.key);
                SelectionStorageExtension.this.doNotClear = true;
                SelectionStorageExtension.this.table.clearSelection();
                SelectionStorageExtension.this.table.setRowSelectionInterval(SelectionStorageExtension.this.configuration.getSelectionStore().size() - 1, SelectionStorageExtension.this.configuration.getSelectionStore().size() - 1);
                SelectionStorageExtension.this.doNotClear = false;
                SelectionStorageExtension.this.initiatedSelection = true;
            } else {
                int index = SelectionStorageExtension.this.configuration.getSelectionStore().indexForKey(this.key);
                if (index >= 0) {
                    SelectionStorageExtension.this.doNotClear = true;
                    SelectionStorageExtension.this.table.clearSelection();
                    SelectionStorageExtension.this.table.setRowSelectionInterval(index, index);
                    SelectionStorageExtension.this.doNotClear = false;
                    SelectionStorageExtension.this.initiatedSelection = true;
                }
            }
        }
    }
}

