/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.ext.selection;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SelectionStore
implements Serializable {
    private static final long serialVersionUID = 541326016135262468L;
    private List<Selection> selections = new ArrayList<Selection>();
    private HashMap<Character, Selection> hash = new HashMap();
    private transient CADataModel model;
    private transient SelectionTableModel tableModel = new SelectionTableModel();

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.tableModel = new SelectionTableModel();
    }

    public int size() {
        return this.selections.size();
    }

    public int indexForKey(char key) {
        return this.selections.indexOf(this.hash.get(Character.valueOf(key)));
    }

    public void remove(int index) {
        this.selections.remove(index);
        this.tableModel.fireTableRowsDeleted(index, index);
    }

    public Selection getSelection(int index) {
        return this.selections.get(index);
    }

    private void addSelection(Selection sel) {
        Selection s;
        int index;
        if (this.hash.containsKey(Character.valueOf(sel.getKey())) && (index = this.selections.indexOf(s = this.hash.get(Character.valueOf(sel.getKey())))) > -1) {
            this.remove(index);
        }
        if (sel.selections[0].length > 0 || sel.selections[1].length > 0) {
            this.selections.add(sel);
            Collections.sort(this.selections, new Comparator<Selection>(){

                @Override
                public int compare(Selection o1, Selection o2) {
                    return new Character(o1.getKey()).compareTo(Character.valueOf(o2.getKey()));
                }
            });
            this.hash.put(Character.valueOf(sel.getKey()), sel);
            int index2 = this.selections.size() - 1;
            this.tableModel.fireTableRowsInserted(index2, index2);
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void addSelection(String name, char key) {
        Selection sel = new Selection(name, key);
        this.addSelection(sel);
    }

    public void setModel(CADataModel model) {
        this.model = model;
    }

    public CADataModel getModel() {
        return this.model;
    }

    public class Selection
    implements Serializable {
        private static final long serialVersionUID = -2619702800941119716L;
        private int[][] selections;
        private String name;
        private char key;
        private transient CAData[][] selectionData;

        private int[] getPositions(CAData[] data) {
            int[] tmp = new int[data.length];
            int i = 0;
            while (i < data.length) {
                tmp[i] = data[i].getPosition();
                ++i;
            }
            return tmp;
        }

        private CAData[] getData(int dataSetIdentifier, int[] positions) {
            CAData[] tmp = new CAData[positions.length];
            int i = 0;
            while (i < positions.length) {
                tmp[i] = SelectionStore.this.getModel().getData(dataSetIdentifier, positions[i]);
                ++i;
            }
            return tmp;
        }

        public Selection(String name, char key) {
            this.name = name;
            this.key = key;
            this.selections = new int[2][];
            this.selections[0] = this.getPositions(SelectionStore.this.getModel().getSelectedData(0));
            this.selections[1] = this.getPositions(SelectionStore.this.getModel().getSelectedData(1));
        }

        public void setName(String name) {
            this.name = name;
        }

        public char getKey() {
            return this.key;
        }

        public int getSiteCount() {
            return this.selections[1].length;
        }

        public int getSequenceCount() {
            return this.selections[0].length;
        }

        public CAData[][] getData() {
            if (this.selectionData == null) {
                this.selectionData = new CAData[2][];
                this.selectionData[0] = this.getData(0, this.selections[0]);
                this.selectionData[1] = this.getData(1, this.selections[1]);
            }
            return this.selectionData;
        }

        public String getName() {
            return this.name;
        }
    }

    class SelectionTableModel
    extends AbstractTableModel {
        SelectionTableModel() {
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Key";
            }
            if (col == 1) {
                return "Name";
            }
            if (col == 2) {
                return "Seq's";
            }
            return "Sites";
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return SelectionStore.this.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Selection s = SelectionStore.this.getSelection(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return Character.valueOf(s.getKey());
                }
                case 1: {
                    return s.getName();
                }
                case 2: {
                    return new Integer(s.getSequenceCount());
                }
            }
            return new Integer(s.getSiteCount());
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                Selection s = SelectionStore.this.getSelection(row);
                s.setName((String)value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

