/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.gui;

import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.gui.CAPointRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class CADefaultPointRenderer
implements CAPointRenderer {
    protected Color[] colors = new Color[]{Color.BLUE, Color.GREEN};
    protected CAData[][] pixelArray;
    protected Dimension[] dimensions = new Dimension[2];

    public void setPixelArray(CAData[][] data) {
        this.pixelArray = data;
    }

    public void drawAt(Graphics2D g, Point2D point, CAData data) {
        int identifier = data.getDataSetIdentifier();
        g.setColor(this.colors[identifier]);
        this.drawIntern(g, point, data);
    }

    private void drawIntern(Graphics2D g, Point2D point, CAData data) {
        int identifier = data.getDataSetIdentifier();
        g.fillRect((int)(point.getX() - this.dimensions[identifier].getWidth() / 2.0), (int)(point.getY() - this.dimensions[identifier].getHeight() / 2.0), (int)this.dimensions[identifier].getWidth(), (int)this.dimensions[identifier].getHeight());
        int i = 0;
        while ((double)i < this.dimensions[identifier].getWidth()) {
            int j = 0;
            while ((double)j < this.dimensions[identifier].getHeight()) {
                try {
                    this.pixelArray[i + (int)(point.getX() - this.dimensions[identifier].getWidth() / 2.0)][j + (int)(point.getY() - this.dimensions[identifier].getHeight() / 2.0)] = data;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
    }

    public void drawHighlightingAt(Graphics2D g, Point2D point, CAData data) {
        g.setColor(Color.RED);
        this.drawIntern(g, point, data);
        int identifier = data.getDataSetIdentifier();
        if (this.dimensions[identifier].getWidth() < 4.0 || this.dimensions[identifier].getHeight() < 4.0) {
            g.drawRect((int)(point.getX() - (this.dimensions[identifier].getWidth() + 2.0) / 2.0), (int)(point.getY() - (this.dimensions[identifier].getHeight() + 2.0) / 2.0), (int)this.dimensions[identifier].getWidth() + 2, (int)this.dimensions[identifier].getHeight() + 2);
        }
    }

    public void drawSelectionAt(Graphics2D g, Point2D point, CAData data) {
        g.setColor(Color.RED);
        this.drawIntern(g, point, data);
        int identifier = data.getDataSetIdentifier();
        if (this.dimensions[identifier].getWidth() < 3.0 || this.dimensions[identifier].getHeight() < 3.0) {
            g.drawRect((int)(point.getX() - (this.dimensions[identifier].getWidth() + 3.0) / 2.0), (int)(point.getY() - (this.dimensions[identifier].getHeight() + 3.0) / 2.0), (int)this.dimensions[identifier].getWidth() + 3, (int)this.dimensions[identifier].getHeight() + 3);
        }
    }

    public void annotateDataAt(Graphics2D g, Point2D point, CAData data) {
        g.setColor(Color.DARK_GRAY);
        g.drawString(data.getName(), (int)point.getX() + 2, (int)point.getY() - 2);
    }

    public void setDataDimension(int dataSetIdentifier, Dimension dimension) {
        this.dimensions[dataSetIdentifier] = dimension;
    }
}

