/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusComponent
extends JPanel {
    public static final int MESSAGE_STATUS = 3;
    public static final int NORMAL_STATUS = 0;
    public static final int PROGRESS_STATUS = 1;
    public static final int ERROR_STATUS = 2;
    private int status;
    private JLabel messageLabel = new JLabel("not available");
    private JComponent contentComponent;
    private JComponent progressComponent;
    private JComponent errorComponent;
    private JComponent messageComponent;
    private JProgressBar progressBar;

    public StatusComponent() {
        this.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressComponent = new JPanel();
        this.progressComponent.setBackground(Color.WHITE);
        this.progressComponent.setLayout(new GridBagLayout());
        this.progressComponent.add((Component)this.progressBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.errorComponent = new JPanel();
        this.errorComponent.setBackground(Color.WHITE);
        this.errorComponent.setLayout(new GridBagLayout());
        this.errorComponent.add((Component)new JLabel("unexpected error"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.messageComponent = new JPanel();
        this.messageComponent.setBackground(Color.WHITE);
        this.messageComponent.setLayout(new GridBagLayout());
        this.messageComponent.add((Component)this.messageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setStatus(3);
    }

    public void setContent(JComponent component) {
        this.contentComponent = component;
    }

    public Dimension getPreferredSize() {
        if (this.contentComponent != null) {
            return this.contentComponent.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public void setStatus(int status) {
        this.removeAll();
        switch (status) {
            case 0: {
                this.add((Component)this.contentComponent, "Center");
                break;
            }
            case 1: {
                this.add((Component)this.progressComponent, "Center");
                break;
            }
            case 2: {
                this.add((Component)this.errorComponent, "Center");
                break;
            }
            case 3: {
                this.add((Component)this.messageComponent, "Center");
            }
        }
        this.status = status;
        this.revalidate();
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setIndeterminateProgress(boolean flag) {
        this.progressBar.setIndeterminate(flag);
    }

    public void setProgress(double percent) {
        this.progressBar.setValue((int)(percent * 100.0));
    }
}

