/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.io;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class MatrixReader
extends FileReader {
    public MatrixReader(String filename) throws FileNotFoundException {
        super(filename);
    }

    public DoubleMatrix2D readMatrix() throws IOException {
        BufferedReader br = new BufferedReader(this);
        ArrayList<double[]> vectors = new ArrayList<double[]>();
        String line = br.readLine();
        while (line != null) {
            String[] doubles = line.split("\t");
            double[] vec = new double[doubles.length];
            int i = 0;
            while (i < doubles.length) {
                try {
                    vec[i] = Double.parseDouble(doubles[i]);
                }
                catch (NumberFormatException e) {
                    vec[i] = 0.0;
                }
                ++i;
            }
            vectors.add(vec);
            line = br.readLine();
        }
        double[][] vecs = (double[][])vectors.toArray((T[])new double[0][]);
        DenseDoubleMatrix2D matrix = new DenseDoubleMatrix2D(vecs);
        br.close();
        return matrix;
    }
}

