/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.util;

import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataProvider;
import de.biozentrum.bioinformatik.ca.annotation.CAAnnotationProvider;
import de.biozentrum.bioinformatik.ca.util.CSVDoubleReader;
import java.io.IOException;

public class CACSVProvider
extends CSVDoubleReader
implements CAAnnotationProvider,
CADataProvider {
    public CACSVProvider(String filename, String seperator) throws IOException {
        super(filename, seperator);
    }

    public Object getAnnotation(CAData data, String key) {
        if (key.equals("name")) {
            switch (data.getDataSetIdentifier()) {
                case 0: {
                    return this.rowHeader[data.getPosition()];
                }
                case 1: {
                    return this.colHeader[data.getPosition()];
                }
            }
        } else if (key.equals("identifier")) {
            return String.valueOf(data.getDataSetIdentifier()) + "-" + data.getPosition();
        }
        return null;
    }

    public Class getClass(String key) {
        if (key.equals("name")) {
            return String.class;
        }
        if (key.equals("identifier")) {
            return String.class;
        }
        return null;
    }

    public String getLabel(String key) {
        if (key.equals("identifier")) {
            return "Identifier";
        }
        if (key.equals("name")) {
            return "Name";
        }
        return null;
    }

    public String getLabel(int dataSetIdentifier) {
        switch (dataSetIdentifier) {
            case 0: {
                return "Row data";
            }
            case 1: {
                return "Column data";
            }
        }
        return null;
    }

    public String[] getKeys(int dataSetIdentifier) {
        return new String[]{"identifier", "name"};
    }

    public DoubleMatrix2D getDataMatrix() {
        return this.doubledataMatrix;
    }
}

