/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.util;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import de.biozentrum.bioinformatik.ca.CAData;
import de.biozentrum.bioinformatik.ca.CADataProvider;
import de.biozentrum.bioinformatik.ca.annotation.CAAnnotationProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class CARTableProvider
implements CAAnnotationProvider,
CADataProvider {
    private String[] rowHeader;
    private String[] colHeader;
    private DoubleMatrix2D dataMatrix;

    public CARTableProvider(String filename, String seperator) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String columns = reader.readLine();
        int m = columns.split(seperator).length;
        int n = 0;
        while (reader.readLine() != null) {
            ++n;
        }
        reader.close();
        this.rowHeader = new String[n];
        this.colHeader = new String[m];
        this.dataMatrix = new DenseDoubleMatrix2D(n, m);
        reader = new BufferedReader(new FileReader(filename));
        String[] tmpColHeader = reader.readLine().split(seperator);
        int i = 0;
        while (i < tmpColHeader.length) {
            this.colHeader[i] = tmpColHeader[i];
            ++i;
        }
        String line = reader.readLine();
        int lineCount = 0;
        while (line != null) {
            String[] tmpRow = line.split(seperator);
            this.rowHeader[lineCount] = tmpRow[0];
            int i2 = 1;
            while (i2 < tmpRow.length) {
                double d = new Double(tmpRow[i2]);
                this.dataMatrix.set(lineCount, i2 - 1, d);
                ++i2;
            }
            line = reader.readLine();
            ++lineCount;
        }
        reader.close();
    }

    public Object getAnnotation(CAData data, String key) {
        if (key.equals("name")) {
            switch (data.getDataSetIdentifier()) {
                case 0: {
                    return this.rowHeader[data.getPosition()];
                }
                case 1: {
                    return this.colHeader[data.getPosition()];
                }
            }
        } else if (key.equals("identifier")) {
            return String.valueOf(data.getDataSetIdentifier()) + "-" + data.getPosition();
        }
        return null;
    }

    public Class getClass(String key) {
        if (key.equals("name")) {
            return String.class;
        }
        if (key.equals("identifier")) {
            return String.class;
        }
        return null;
    }

    public String getLabel(String key) {
        if (key.equals("identifier")) {
            return "Identifier";
        }
        if (key.equals("name")) {
            return "Name";
        }
        return null;
    }

    public String getLabel(int dataSetIdentifier) {
        switch (dataSetIdentifier) {
            case 0: {
                return "Row data";
            }
            case 1: {
                return "Column data";
            }
        }
        return null;
    }

    public String[] getKeys(int dataSetIdentifier) {
        return new String[]{"identifier", "name"};
    }

    public DoubleMatrix2D getDataMatrix() {
        return this.dataMatrix;
    }
}

