/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.util;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import de.biozentrum.bioinformatik.ca.util.CSVReader;
import java.io.File;
import java.io.IOException;

public class CSVDoubleReader {
    protected String[] rowHeader;
    protected String[] colHeader;
    protected DoubleMatrix2D doubledataMatrix;
    protected String filename;
    protected String seperator;

    public CSVDoubleReader(String filename, String seperator) throws IOException {
        this.filename = filename;
        this.seperator = seperator;
        this.read();
    }

    public void read() throws IOException {
        CSVReader csvReader = new CSVReader(new File(this.filename), this.seperator, true, true);
        String[][] mat = csvReader.readCSV();
        this.rowHeader = csvReader.getRowHeader();
        this.colHeader = csvReader.getColumnHeader();
        this.doubledataMatrix = new DenseDoubleMatrix2D(mat.length, mat[0].length);
        int i = 0;
        while (i < mat.length) {
            int j = 0;
            while (j < mat[0].length) {
                this.doubledataMatrix.set(i, j, Double.valueOf(mat[i][j]));
                ++j;
            }
            ++i;
        }
    }

    public String[] getColHeader() {
        return this.colHeader;
    }

    public void setColHeader(String[] colHeader) {
        this.colHeader = colHeader;
    }

    public DoubleMatrix2D getDoubleDataMatrix() {
        return this.doubledataMatrix;
    }

    public void setDoubleDataMatrix(DoubleMatrix2D dataMatrix) {
        this.doubledataMatrix = dataMatrix;
    }

    public String[] getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(String[] rowHeader) {
        this.rowHeader = rowHeader;
    }
}

