/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.ca.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CSVReader {
    private File file;
    private String seperator;
    private String[] columnHeader;
    private String[] rowHeader;
    private boolean hasRowHeaders;
    private boolean hasColumnHeaders;

    public CSVReader(File file, String seperator, boolean hasRowHeaders, boolean hasColumnHeaders) {
        this.file = file;
        this.seperator = seperator;
        this.hasRowHeaders = hasRowHeaders;
        this.hasColumnHeaders = hasColumnHeaders;
    }

    public String[] getColumnHeader() {
        return this.columnHeader;
    }

    public String[] getRowHeader() {
        return this.rowHeader;
    }

    public String[][] readCSV() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String columns = reader.readLine();
        int m = columns.split(this.seperator).length;
        int n = 0;
        while (reader.readLine() != null) {
            ++n;
        }
        this.rowHeader = new String[n];
        this.columnHeader = new String[m];
        String[][] matrix = new String[n][m];
        reader.close();
        reader = new BufferedReader(new FileReader(this.file));
        if (this.hasColumnHeaders) {
            String[] tmpColHeader = reader.readLine().split(this.seperator);
            int i = 0;
            while (i < tmpColHeader.length) {
                this.columnHeader[i] = tmpColHeader[i];
                ++i;
            }
        }
        String line = reader.readLine();
        int lineCount = 0;
        while (line != null) {
            String[] tmpRow = line.split(this.seperator);
            int i = 0;
            if (this.hasRowHeaders) {
                this.rowHeader[lineCount] = tmpRow[0];
                i = 1;
            }
            while (i < tmpRow.length) {
                String d = "";
                try {
                    d = new String(tmpRow[i]);
                }
                catch (NumberFormatException nfo) {
                    System.out.println(tmpRow[i]);
                    System.exit(0);
                }
                if (this.hasRowHeaders) {
                    matrix[lineCount][i - 1] = d;
                } else {
                    matrix[lineCount][i] = d;
                }
                ++i;
            }
            line = reader.readLine();
            ++lineCount;
        }
        reader.close();
        return matrix;
    }
}

