/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.sequence.Sequence;
import de.biozentrum.bioinformatik.sequence.SequenceAlphabet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioJavaHelper {
    public static Alignment createAlignment(RichSequenceIterator iterator, List<RichSequence> sequenceOrder) throws NoSuchElementException, BioException {
        HashMap<String, RichSequence> map = new HashMap<String, RichSequence>();
        while (iterator.hasNext()) {
            RichSequence seq = iterator.nextRichSequence();
            map.put(seq.getName(), seq);
            sequenceOrder.add(seq);
        }
        return new SimpleAlignment(map);
    }

    public static Set<Symbol> getAllSymbols(FiniteAlphabet alphabet) {
        HashSet<Symbol> set = new HashSet<Symbol>();
        String possibleSymbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        try {
            SymbolTokenization tokenization = alphabet.getTokenization("token");
            int i = 0;
            while (i < possibleSymbols.length()) {
                String token = possibleSymbols.substring(i, i + 1);
                try {
                    Symbol s = tokenization.parseToken(token);
                    set.add(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static AlphabetIndex createNonatomicAlphabetIndex(FiniteAlphabet alphabet) {
        return new NonatomicAlphabetIndex(alphabet);
    }

    public static Sequence convertSequence(org.biojava.bio.seq.Sequence sequence) {
        return new Sequence(sequence.getName(), sequence.seqString());
    }

    public static MultipleAlignment convertAlignment(Alignment alignment, Object[] labelOrder) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        FiniteAlphabet alph = null;
        Object[] objectArray = labelOrder;
        int n = labelOrder.length;
        int n2 = 0;
        while (n2 < n) {
            Object label = objectArray[n2];
            org.biojava.bio.seq.Sequence seq = (org.biojava.bio.seq.Sequence)alignment.symbolListForLabel(label);
            if (alph == null) {
                alph = (FiniteAlphabet)seq.getAlphabet();
            }
            sequences.add(BioJavaHelper.convertSequence(seq));
            ++n2;
        }
        MultipleAlignment mul = new MultipleAlignment(sequences);
        mul.setAlphabet(BioJavaHelper.convertAlphabet(alph));
        return mul;
    }

    public static SequenceAlphabet convertAlphabet(FiniteAlphabet alphabet) {
        SequenceAlphabet al = new SequenceAlphabet();
        try {
            SymbolTokenization tokenization = alphabet.getTokenization("token");
            Iterator<Symbol> it = alphabet.iterator();
            while (it.hasNext()) {
                Symbol next = it.next();
                al.addCharacter(new Character(tokenization.tokenizeSymbol(next).charAt(0)));
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return al;
    }

    private static class NonatomicAlphabetIndex
    implements AlphabetIndex {
        private FiniteAlphabet alphabet;
        private List<Symbol> symbols;
        private SymbolTokenization tokenization;

        public NonatomicAlphabetIndex(FiniteAlphabet alphabet) {
            this.alphabet = alphabet;
            this.symbols = new ArrayList<Symbol>(alphabet.size());
            try {
                this.tokenization = alphabet.getTokenization("token");
            }
            catch (BioException e1) {
                e1.printStackTrace();
            }
            Iterator<Symbol> iterator = alphabet.iterator();
            while (iterator.hasNext()) {
                this.symbols.add(iterator.next());
            }
            Set<Symbol> allSymbols = BioJavaHelper.getAllSymbols(alphabet);
            for (Symbol s : allSymbols) {
                if (this.symbols.contains(s)) continue;
                this.symbols.add(s);
            }
        }

        public FiniteAlphabet getAlphabet() {
            return this.alphabet;
        }

        public int indexForSymbol(Symbol arg0) throws IllegalSymbolException {
            return this.symbols.indexOf(arg0);
        }

        public Symbol symbolForIndex(int arg0) throws IndexOutOfBoundsException {
            return this.symbols.get(arg0);
        }

        public void addChangeListener(ChangeListener arg0) {
        }

        public void addChangeListener(ChangeListener arg0, ChangeType arg1) {
        }

        public boolean isUnchanging(ChangeType arg0) {
            return false;
        }

        public void removeChangeListener(ChangeListener arg0) {
        }

        public void removeChangeListener(ChangeListener arg0, ChangeType arg1) {
        }
    }
}

