/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.CorrespondenceAnalysis;
import de.biozentrum.bioinformatik.ca.ext.alignment.CAMADataProvider;
import de.biozentrum.bioinformatik.ca.ext.alignment.io.AlignmentReader;
import de.biozentrum.bioinformatik.cama.BioJavaHelper;
import de.biozentrum.bioinformatik.cama.CAMAConfiguration;
import de.biozentrum.bioinformatik.cama.CAMAFrame;
import de.biozentrum.bioinformatik.cama.FisherScoringParameterDialog;
import de.biozentrum.bioinformatik.cama.OpenSessionDialog;
import de.biozentrum.bioinformatik.cama.hmm.FisherScoring;
import de.biozentrum.bioinformatik.cama.hmm.ProfileHMMTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.biojava.bio.BioException;
import org.biojava.bio.dp.ProfileHMM;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.ClustalWAlignmentSAXParser;
import org.biojava.bio.program.sax.FastaSequenceSAXParser;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.xml.sax.XMLReader;

public class CAMA
extends JFrame {
    private static final long serialVersionUID = 3906649721656587832L;
    static File currentDirectory;
    JMenuItem saveItem = null;
    JMenuItem openItem = null;
    JMenuItem fisherExportItem = null;
    JMenuItem svgExportItem = null;
    JCheckBoxMenuItem toggleSelectionLabelsItem = null;
    CAMAFrame currentFrame;
    List<CAMAFrame> windows;
    JMenu windowMenu;
    JDesktopPane desktopPane = new JDesktopPane();
    JMenu exportMenu;

    public CAMA() {
        super("CAMA");
        this.setContentPane(this.desktopPane);
        this.windows = new ArrayList<CAMAFrame>();
        this.setJMenuBar(this.createMenuBar());
        this.setDefaultCloseOperation(3);
        this.setCurrentFrame(null);
    }

    public void setCurrentFrame(CAMAFrame frame) {
        this.currentFrame = frame;
        this.saveItem.setEnabled(this.currentFrame != null);
        this.exportMenu.setEnabled(this.currentFrame != null);
        this.toggleSelectionLabelsItem.setEnabled(this.currentFrame != null);
        if (this.currentFrame != null) {
            this.fisherExportItem.setAction(this.currentFrame.getFisherExportAction());
            this.svgExportItem.setAction(this.currentFrame.getSVGExportAction());
            this.toggleSelectionLabelsItem.setSelected(this.currentFrame.showsSelectedItemLabels());
        } else {
            this.fisherExportItem.setAction(null);
            this.svgExportItem.setAction(null);
            this.toggleSelectionLabelsItem.setSelected(false);
        }
    }

    public void openCamaFrame(CAMAConfiguration config) {
        CAMAFrame doc = new CAMAFrame(config);
        doc.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent e) {
            }

            public void internalFrameIconified(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                CAMAFrame f = (CAMAFrame)e.getInternalFrame();
                int index = CAMA.this.windows.indexOf(f);
                ((JCheckBoxMenuItem)CAMA.this.windowMenu.getItem(index)).setState(false);
                if (CAMA.this.currentFrame == f) {
                    CAMA.this.setCurrentFrame(null);
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                CAMAFrame f = (CAMAFrame)e.getInternalFrame();
                int index = CAMA.this.windows.indexOf(f);
                CAMA.this.windowMenu.remove(index);
                CAMA.this.windows.remove(index);
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                CAMAFrame f = (CAMAFrame)e.getInternalFrame();
                int index = CAMA.this.windows.indexOf(f);
                if (index < 0) {
                    CAMA.this.windows.add(f);
                    CAMA.this.windowMenu.add(new JCheckBoxMenuItem(f.getAction()));
                    index = CAMA.this.windows.size() - 1;
                }
                CAMA.this.setCurrentFrame(f);
                ((JCheckBoxMenuItem)CAMA.this.windowMenu.getItem(index)).setState(true);
            }
        });
        this.desktopPane.add(doc);
        doc.createGUI();
        doc.setVisible(true);
        try {
            doc.setMaximum(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            doc.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void saveFile() {
        JFileChooser fileChooser = new JFileChooser(currentDirectory);
        fileChooser.setAcceptAllFileFilterUsed(false);
        ArrayList<String> camaList = new ArrayList<String>();
        camaList.add("cama");
        GenericFileFilter camaFilter = new GenericFileFilter("CAMA", camaList);
        fileChooser.addChoosableFileFilter(camaFilter);
        fileChooser.setFileFilter(camaFilter);
        int returnVal = fileChooser.showSaveDialog(this);
        currentDirectory = fileChooser.getCurrentDirectory();
        if (returnVal == 0) {
            FileOutputStream fos = null;
            ObjectOutputStream out = null;
            try {
                String file = fileChooser.getSelectedFile().getAbsolutePath();
                if (!file.endsWith(".cama")) {
                    file = String.valueOf(file) + ".cama";
                }
                fos = new FileOutputStream(file);
                out = new ObjectOutputStream(fos);
                out.writeObject(this.currentFrame.getConfiguration());
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Unable to save this CAMA-Session.", "Unknown Error", 0);
            }
        }
    }

    public void openFile() {
        JFileChooser fileChooser = new JFileChooser(currentDirectory);
        fileChooser.setAcceptAllFileFilterUsed(false);
        ArrayList<String> camaList = new ArrayList<String>();
        camaList.add("cama");
        GenericFileFilter camaFastaFilter = new GenericFileFilter("CAMA", camaList);
        fileChooser.addChoosableFileFilter(camaFastaFilter);
        fileChooser.setFileFilter(camaFastaFilter);
        int returnVal = fileChooser.showOpenDialog(this);
        currentDirectory = fileChooser.getCurrentDirectory();
        if (returnVal == 0) {
            OpenSessionDialog dialog = new OpenSessionDialog(this, fileChooser.getSelectedFile());
            dialog.showModal();
            try {
                this.openCamaFrame(dialog.getConfiguration());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Unable to open file.\nPlease check if the file is a CAMA-Session file.", "Unknown Error", 0);
            }
        }
    }

    public void openAlignmentFile() {
        JFileChooser fileChooser = new JFileChooser(currentDirectory);
        fileChooser.setAcceptAllFileFilterUsed(false);
        ArrayList<String> fastaList = new ArrayList<String>();
        fastaList.add("fas");
        fastaList.add("fasta");
        fastaList.add("txt");
        ArrayList<String> clustalList = new ArrayList<String>();
        clustalList.add("aln");
        clustalList.add("txt");
        GenericFileFilter biojavaFastaFilter = new GenericFileFilter("Fasta Alignment", null);
        GenericFileFilter biojavaClustalFilter = new GenericFileFilter("Clustal Alignment", clustalList);
        fileChooser.addChoosableFileFilter(biojavaFastaFilter);
        fileChooser.addChoosableFileFilter(biojavaClustalFilter);
        fileChooser.setFileFilter(biojavaFastaFilter);
        int returnVal = fileChooser.showOpenDialog(this);
        currentDirectory = fileChooser.getCurrentDirectory();
        if (returnVal == 0) {
            AlignmentFormat format = fileChooser.getFileFilter().equals(biojavaFastaFilter) ? AlignmentFormat.FASTA : AlignmentFormat.CLUSTAL;
            Object[] possibilities = new Object[]{"DNA", "RNA", "Amino Acid", "From File"};
            Object option = possibilities[2];
            try {
                FiniteAlphabet alphabet = this.guessAlphabet(fileChooser.getSelectedFile());
                if (alphabet != null) {
                    if (alphabet == RNATools.getRNA()) {
                        option = possibilities[1];
                    }
                    if (alphabet == DNATools.getDNA()) {
                        option = possibilities[0];
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String s = (String)JOptionPane.showInputDialog(this, "Choose sequence type", "Sequence type", -1, null, possibilities, option);
            AlignmentType type = AlignmentType.DNA;
            if (s != null && s.length() > 0) {
                if (s.equals("DNA")) {
                    type = AlignmentType.DNA;
                } else if (s.equals("RNA")) {
                    type = AlignmentType.RNA;
                } else if (s.equals("Amino Acid")) {
                    type = AlignmentType.AminoAcid;
                } else if (s.equals("From File")) {
                    type = AlignmentType.Custom;
                }
                try {
                    CAMAAlignmentProcessing processing = new CAMAAlignmentProcessing(fileChooser.getSelectedFile(), format, type);
                    processing.processFile();
                }
                catch (NoSuchElementException e) {
                    this.presentException(e);
                }
                catch (IOException e) {
                    this.presentException(e);
                }
                catch (CustomAlphabetAbortedException e) {
                    JOptionPane.showMessageDialog(this, "Could not read alphabet file.\nPlease provide the alphabet in the following format:\nA A-Annotation\nB B-Annotation\n....", "Wrong alphabet format", 0);
                }
                catch (BioException e) {
                    this.presentException(e);
                }
            }
        }
    }

    public void presentException(Exception e) {
        e.printStackTrace();
        String msg = e.getLocalizedMessage();
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    private String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(filePath)));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private FiniteAlphabet guessAlphabet(File f) throws IOException {
        FileReader r = new FileReader(f);
        HashMap<Character, Integer> counts = new HashMap<Character, Integer>();
        int chars = 0;
        int c = ((Reader)r).read();
        ArrayList<Character> characters = new ArrayList<Character>();
        while (c != -1) {
            Character character = Character.valueOf((char)c);
            if (character.charValue() == ' ' || character.charValue() == '\t' || character.charValue() == '\n') {
                c = ((Reader)r).read();
                continue;
            }
            if (!characters.contains(character = Character.valueOf(String.valueOf(character).toUpperCase().charAt(0)))) {
                characters.add(character);
            }
            ++chars;
            if (!counts.containsKey(character)) {
                counts.put(character, 1);
            } else {
                counts.put(character, (Integer)counts.get(character) + 1);
            }
            c = ((Reader)r).read();
        }
        ArrayList<FiniteAlphabet> alphabets = new ArrayList<FiniteAlphabet>();
        alphabets.add(RNATools.getRNA());
        alphabets.add(DNATools.getDNA());
        alphabets.add(ProteinTools.getAlphabet());
        ArrayList<FiniteAlphabet> temp = new ArrayList<FiniteAlphabet>();
        Collections.sort(characters, new CharComparator(counts));
        ArrayList<Character> cc = new ArrayList<Character>();
        double pp = 0.0;
        for (Character character : characters) {
            if (!((pp += (double)((Integer)counts.get(character)).intValue() / (double)chars) < 0.5)) break;
            cc.add(character);
        }
        for (Character key : cc) {
            for (FiniteAlphabet a : alphabets) {
                try {
                    a.getTokenization("token").parseToken(String.valueOf(key));
                    temp.add(a);
                }
                catch (IllegalSymbolException illegalSymbolException) {
                }
                catch (BioException bioException) {
                    // empty catch block
                }
            }
            alphabets = temp;
            temp = new ArrayList();
            if (alphabets.size() == 0) break;
        }
        if (alphabets.size() > 0) {
            return (FiniteAlphabet)alphabets.get(0);
        }
        return null;
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem openFile = new JMenuItem("Open CAMA session ...");
        fileMenu.add(openFile);
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CAMA.this.openFile();
            }
        });
        JMenuItem openAlignmentFile = new JMenuItem("Open alignment ...");
        fileMenu.add(openAlignmentFile);
        openAlignmentFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CAMA.this.openAlignmentFile();
            }
        });
        fileMenu.addSeparator();
        this.saveItem = new JMenuItem("Save CAMA session ...");
        fileMenu.add(this.saveItem);
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CAMA.this.saveFile();
            }
        });
        fileMenu.addSeparator();
        this.exportMenu = new JMenu("Export ...");
        fileMenu.add(this.exportMenu);
        this.svgExportItem = new JMenuItem("Plot");
        this.exportMenu.add(this.svgExportItem);
        this.fisherExportItem = new JMenuItem("Fisher Scores");
        this.exportMenu.add(this.fisherExportItem);
        fileMenu.addSeparator();
        JMenuItem exitFile = new JMenuItem("Exit");
        fileMenu.add(exitFile);
        exitFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menuBar.add(fileMenu);
        JMenu viewMenu = new JMenu("View");
        this.toggleSelectionLabelsItem = new JCheckBoxMenuItem("Show/hide selected item labels");
        this.toggleSelectionLabelsItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.toggleSelectionLabelsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CAMA.this.currentFrame.setShowsSelectedItemLabels(!CAMA.this.currentFrame.showsSelectedItemLabels());
                CAMA.this.toggleSelectionLabelsItem.setSelected(CAMA.this.currentFrame.showsSelectedItemLabels());
            }
        });
        viewMenu.add(this.toggleSelectionLabelsItem);
        menuBar.add(viewMenu);
        this.windowMenu = new JMenu("Window");
        menuBar.add(this.windowMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem usageItem = new JMenuItem("Usage");
        helpMenu.add(usageItem);
        usageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JEditorPane jEditorPane = new JEditorPane();
                        jEditorPane.setEditable(false);
                        JScrollPane scrollPane = new JScrollPane(jEditorPane);
                        HTMLEditorKit kit = new HTMLEditorKit();
                        jEditorPane.setEditorKit(kit);
                        StyleSheet styleSheet = kit.getStyleSheet();
                        styleSheet.addRule("body {color:#000; font-family:helvetica; margin: 4px; font-size: 12pt;}");
                        styleSheet.addRule("pre {font : 10px monaco; color : black; background-color : #fafafa; }");
                        String htmlString = null;
                        try {
                            htmlString = CAMA.this.readFileAsString("de/biozentrum/bioinformatik/cama/usage.html");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Document doc = kit.createDefaultDocument();
                        jEditorPane.setDocument(doc);
                        JFrame j = new JFrame("Usage");
                        j.getContentPane().add((Component)scrollPane, "Center");
                        j.setDefaultCloseOperation(2);
                        j.setMinimumSize(new Dimension(500, 300));
                        j.setSize(new Dimension(500, 300));
                        j.setMaximumSize(new Dimension(500, 500));
                        j.setLocationRelativeTo(CAMA.this);
                        j.setVisible(true);
                        jEditorPane.setText(htmlString);
                        jEditorPane.setAutoscrolls(true);
                    }
                });
            }
        });
        JMenuItem supportFile = new JMenuItem("About");
        helpMenu.add(supportFile);
        supportFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JEditorPane jEditorPane = new JEditorPane();
                        jEditorPane.setEditable(false);
                        JScrollPane scrollPane = new JScrollPane(jEditorPane);
                        HTMLEditorKit kit = new HTMLEditorKit();
                        jEditorPane.setEditorKit(kit);
                        StyleSheet styleSheet = kit.getStyleSheet();
                        styleSheet.addRule("body {color:#000; font-family:helvetica; margin: 4px; font-size: 12pt;}");
                        styleSheet.addRule("pre {font : 10px monaco; color : black; background-color : #fafafa; }");
                        String htmlString = null;
                        try {
                            htmlString = CAMA.this.readFileAsString("de/biozentrum/bioinformatik/cama/about.html");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        JFrame j = new JFrame("About");
                        j.getContentPane().add((Component)scrollPane, "Center");
                        j.setDefaultCloseOperation(2);
                        j.setMinimumSize(new Dimension(350, 350));
                        j.setSize(new Dimension(350, 350));
                        j.setMaximumSize(new Dimension(350, 500));
                        j.setLocationRelativeTo(CAMA.this);
                        j.setVisible(true);
                        Document doc = kit.createDefaultDocument();
                        jEditorPane.setDocument(doc);
                        jEditorPane.setText(htmlString);
                    }
                });
            }
        });
        menuBar.add(helpMenu);
        return menuBar;
    }

    public static void main(String[] args) {
        CAMA cama = new CAMA();
        cama.setSize(800, 600);
        cama.setLocationRelativeTo(null);
        cama.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AlignmentFormat {
        FASTA,
        CLUSTAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AlignmentType {
        DNA,
        RNA,
        AminoAcid,
        Custom;

    }

    class CAMAAlignmentProcessing {
        private CAMAConfiguration config;
        private AlignmentFormat format;
        private File file;
        private HMMConstructionTask hmmConstructionTask;
        private FisherCalculationTask fisherTask;
        private ReadAlignmentTask readAlignmentTask;
        private CorrespondenceAnalysis correspondenceAnalysis;
        private ProgressMonitor progressMonitor;

        public CAMAAlignmentProcessing(File file, AlignmentFormat format, AlignmentType type) {
            this.format = format;
            this.file = file;
            this.config = new CAMAConfiguration();
            this.config.setAlignmentType(type);
        }

        public void processFile() throws IOException, CustomAlphabetAbortedException, NoSuchElementException, BioException {
            FiniteAlphabet alph = null;
            switch (this.config.getAlignmentType()) {
                case RNA: {
                    alph = RNATools.getRNA();
                    break;
                }
                case DNA: {
                    alph = DNATools.getDNA();
                    break;
                }
                case AminoAcid: {
                    alph = ProteinTools.getAlphabet();
                    break;
                }
                case Custom: {
                    JFileChooser fileChooser = new JFileChooser(currentDirectory);
                    int returnVal = fileChooser.showOpenDialog(CAMA.this);
                    if (returnVal == 0) {
                        File f = fileChooser.getSelectedFile();
                        BufferedReader breader = new BufferedReader(new FileReader(f));
                        String line = breader.readLine();
                        HashMap<Character, Symbol> map = new HashMap<Character, Symbol>();
                        HashSet<AtomicSymbol> symbols = new HashSet<AtomicSymbol>();
                        currentDirectory = fileChooser.getCurrentDirectory();
                        Symbol gap = AlphabetManager.getGapSymbol();
                        map.put(Character.valueOf('-'), gap);
                        while (line != null) {
                            if (line.length() > 0) {
                                String s = line.substring(0, 1);
                                String s2 = null;
                                if (line.length() > 2) {
                                    s2 = line.substring(2);
                                }
                                AtomicSymbol sym = null;
                                sym = s2 != null ? AlphabetManager.createSymbol(s2) : AlphabetManager.createSymbol(s);
                                map.put(Character.valueOf(s.charAt(0)), sym);
                                symbols.add(sym);
                            }
                            line = breader.readLine();
                        }
                        alph = new SimpleAlphabet(symbols);
                        CharacterTokenization tokenization = new CharacterTokenization(alph, true);
                        ((SimpleAlphabet)alph).putTokenization("token", tokenization);
                        for (Map.Entry entry : map.entrySet()) {
                            tokenization.bindSymbol((Symbol)entry.getValue(), ((Character)entry.getKey()).charValue());
                        }
                        break;
                    }
                    throw new CustomAlphabetAbortedException();
                }
            }
            this.config.setAlphabetIndex(BioJavaHelper.createNonatomicAlphabetIndex(alph));
            AbstractNativeAppSAXParser parser = null;
            switch (this.format) {
                case FASTA: {
                    parser = new FastaSequenceSAXParser();
                    break;
                }
                case CLUSTAL: {
                    parser = new ClustalWAlignmentSAXParser();
                    break;
                }
            }
            this.openAlignment(alph, parser);
        }

        public void openAlignment(FiniteAlphabet alphabet, XMLReader parser) throws IOException, NoSuchElementException, BioException {
            this.progressMonitor = new ProgressMonitor(CAMA.this, "Initializing...", null, 0, 2);
            this.progressMonitor.setNote("Reading file...");
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.readAlignmentTask = new ReadAlignmentTask(alphabet, parser);
            this.readAlignmentTask.execute();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FisherCalculationTask
        extends SwingWorker<DoubleMatrix2D, Void>
        implements Thread.UncaughtExceptionHandler {
            private Sequence[] sequenceOrder;
            private ProfileHMM profileHMM;
            private Sequence currentSequence;
            private Object activeMutex;
            private boolean done;
            private int activeCalculations;
            private int calculationsToPerform;
            private DoubleMatrix1D[] vectors;
            private int maxThreads;
            private FisherScoring.FisherScoringParameters parameters;
            boolean showMessage = true;

            public FisherCalculationTask(Sequence[] sequenceOrder, ProfileHMM profileHMM, int maxThreads, FisherScoring.FisherScoringParameters parameters) {
                this.sequenceOrder = sequenceOrder;
                this.profileHMM = profileHMM;
                this.activeMutex = new Object();
                this.maxThreads = maxThreads;
                this.parameters = parameters;
                this.done = false;
                Thread.setDefaultUncaughtExceptionHandler(this);
            }

            private synchronized void reportException(FisherVectorCalculation calc, Exception e) {
                CAMA.this.presentException(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void reportFinished(int index) {
                Object object = this.activeMutex;
                synchronized (object) {
                    --this.activeCalculations;
                }
                --this.calculationsToPerform;
                this.done = this.calculationsToPerform == 0;
            }

            public int getTotalProgress() {
                return 100;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected DoubleMatrix2D doInBackground() throws Exception {
                DoubleFactory2D F2D = DoubleFactory2D.dense;
                this.currentSequence = this.sequenceOrder[0];
                this.setProgress(1);
                this.calculationsToPerform = this.sequenceOrder.length;
                this.activeCalculations = 0;
                FisherScoring fs = new FisherScoring(this.profileHMM, CAMAAlignmentProcessing.this.config.getAlphabetIndex(), this.parameters);
                DoubleMatrix2D fsv = F2D.make(this.sequenceOrder.length, fs.getFisherScoreDimensions());
                int i = 0;
                while (i < this.sequenceOrder.length) {
                    Sequence sequence = this.sequenceOrder[i];
                    FisherVectorCalculation fc = new FisherVectorCalculation(i, fs, sequence, fsv);
                    Thread t = new Thread(fc);
                    Object object = this.activeMutex;
                    synchronized (object) {
                        ++this.activeCalculations;
                    }
                    t.start();
                    if (this.isCancelled()) {
                        return null;
                    }
                    this.updateProgress();
                    while (this.activeCalculations > this.maxThreads) {
                        Thread.sleep(10L);
                    }
                    ++i;
                }
                while (!this.done) {
                    this.updateProgress();
                    Thread.sleep(3L);
                }
                return fsv;
            }

            public void updateProgress() {
                this.setProgress((int)Math.ceil((double)(this.sequenceOrder.length - this.calculationsToPerform + 1) / (double)(this.sequenceOrder.length + 1) * 100.0));
            }

            @Override
            public void done() {
                try {
                    CAMAAlignmentProcessing.this.progressMonitor.close();
                    CAMAAlignmentProcessing.this.progressMonitor = new ProgressMonitor(CAMA.this, "Correspondence analysis...", null, 0, 8);
                    CAMAAlignmentProcessing.this.progressMonitor.setMillisToPopup(0);
                    CAMAAlignmentProcessing.this.progressMonitor.setMillisToDecideToPopup(0);
                    CAMAAlignmentProcessing.this.config.setFisherScores((DoubleMatrix2D)this.get());
                    CAMAAlignmentProcessing.this.config.setDataProvider(new CAMADataProvider(CAMAAlignmentProcessing.this.config.getFisherScores(), CAMAAlignmentProcessing.this.readAlignmentTask.getMultipleAlignment(), CAMAAlignmentProcessing.this.config.getAlphabetIndex()));
                    CAMAAlignmentProcessing.this.correspondenceAnalysis = new CorrespondenceAnalysis(CAMAAlignmentProcessing.this.config.getDataProvider());
                    CAMAAlignmentProcessing.this.correspondenceAnalysis.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("progress" == evt.getPropertyName()) {
                                Integer progress = (Integer)evt.getNewValue();
                                CAMAAlignmentProcessing.this.progressMonitor.setProgress(progress);
                                if (progress == 8) {
                                    try {
                                        CAMAAlignmentProcessing.this.config.setCorresponenceAnalysis(CAMAAlignmentProcessing.this.correspondenceAnalysis);
                                        CAMAAlignmentProcessing.this.config.setDataModel((CADataModel)CAMAAlignmentProcessing.this.correspondenceAnalysis.get());
                                    }
                                    catch (InterruptedException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (ExecutionException e1) {
                                        e1.printStackTrace();
                                    }
                                    CAMAAlignmentProcessing.this.config.getDataModel().setAnnotation(CAMAAlignmentProcessing.this.config.getDataProvider());
                                    int[] nArray = new int[2];
                                    nArray[1] = 1;
                                    CAMAAlignmentProcessing.this.config.getDataModel().setComponents(nArray);
                                    CAMAAlignmentProcessing.this.config.setName(CAMAAlignmentProcessing.this.file.getName());
                                    CAMA.this.openCamaFrame(CAMAAlignmentProcessing.this.config);
                                }
                            }
                        }
                    });
                    CAMAAlignmentProcessing.this.correspondenceAnalysis.execute();
                }
                catch (InterruptedException e) {
                    CAMA.this.presentException(e);
                }
                catch (ExecutionException e) {
                    CAMA.this.presentException(e);
                }
            }

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (this.showMessage) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(CAMA.this, "CAMA run out of memory.\nTo open this file please allow CAMA to take more memory.\nTo allow CAMA to take for example 100 to 500 megabyte,\nplease start CAMA like this: 'java -Xms100M -Xmx500M -jar CAMA.jar'", "Out of memory", 0);
                    this.showMessage = false;
                }
                this.cancel(true);
            }

            private class FisherVectorCalculation
            implements Runnable {
                private Sequence sequence;
                private FisherScoring scoring;
                private int index;
                private DoubleMatrix2D result;

                public FisherVectorCalculation(int index, FisherScoring scoring, Sequence sequence, DoubleMatrix2D result) {
                    this.index = index;
                    this.sequence = sequence;
                    this.scoring = scoring;
                    this.result = result;
                }

                public void run() {
                    try {
                        SymbolList[] symbolList = new SymbolList[]{new SimpleSymbolList(this.sequence.getAlphabet().getTokenization("token"), this.sequence.seqString().replaceAll("-", ""))};
                        this.scoring.matchFisherVector(symbolList, this.result, this.index);
                    }
                    catch (Exception e) {
                        FisherCalculationTask.this.reportException(this, e);
                        return;
                    }
                    FisherCalculationTask.this.reportFinished(this.index);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HMMConstructionTask
        extends SwingWorker<ProfileHMM, Void> {
            private Alignment alignment;
            private boolean[] columnMask;
            CAMADataProvider provider;

            public HMMConstructionTask(Alignment alignment) {
                this.alignment = alignment;
            }

            @Override
            protected ProfileHMM doInBackground() throws Exception {
                ProfileHMM profileHMM = ProfileHMMTools.createProfile(this.alignment, 0.51, 1);
                this.columnMask = ProfileHMMTools.profileColumnMask(this.alignment, 0.51);
                return profileHMM;
            }

            public boolean[] getColumnMask() {
                return this.columnMask;
            }

            @Override
            public void done() {
                try {
                    CAMAAlignmentProcessing.this.progressMonitor.setProgress(2);
                    CAMAAlignmentProcessing.this.progressMonitor.close();
                    FisherScoringParameterDialog dialog = new FisherScoringParameterDialog(CAMA.this);
                    if (dialog.showModal() == FisherScoringParameterDialog.CONFIRMED_OPTION) {
                        CAMAAlignmentProcessing.this.fisherTask = new FisherCalculationTask(CAMAAlignmentProcessing.this.readAlignmentTask.getSequencOrder(), (ProfileHMM)this.get(), dialog.getNumberOfThreads(), dialog.getFisherScoringParameters());
                        CAMAAlignmentProcessing.this.progressMonitor = new ProgressMonitor(CAMA.this, "Calculating fisher scores", "", 0, CAMAAlignmentProcessing.this.fisherTask.getTotalProgress());
                        CAMAAlignmentProcessing.this.progressMonitor.setMillisToPopup(0);
                        CAMAAlignmentProcessing.this.progressMonitor.setMillisToDecideToPopup(0);
                        CAMAAlignmentProcessing.this.config.setColumnMask(this.getColumnMask());
                        CAMAAlignmentProcessing.this.fisherTask.addPropertyChangeListener(new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress" == evt.getPropertyName()) {
                                    Integer progress = (Integer)evt.getNewValue();
                                    CAMAAlignmentProcessing.this.progressMonitor.setProgress(progress);
                                }
                            }
                        });
                        CAMAAlignmentProcessing.this.fisherTask.execute();
                    }
                }
                catch (InterruptedException e) {
                    CAMA.this.presentException(e);
                }
                catch (ExecutionException e) {
                    CAMA.this.presentException(e);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReadAlignmentTask
        extends SwingWorker<Alignment, Void> {
            private FiniteAlphabet alphabet;
            private XMLReader parser;
            private Sequence[] sequenceOrder;
            private MultipleAlignment multipleAlignment;

            public ReadAlignmentTask(FiniteAlphabet alphabet, XMLReader parser) {
                this.alphabet = alphabet;
                this.parser = parser;
            }

            @Override
            protected Alignment doInBackground() throws Exception {
                AlignmentReader clustalReader = new AlignmentReader(CAMAAlignmentProcessing.this.file, this.alphabet, this.parser);
                Alignment alignment = clustalReader.readAlignment();
                this.sequenceOrder = clustalReader.getSequenceOrder();
                Object[] labelOrder = new Object[this.sequenceOrder.length];
                int i = 0;
                while (i < this.sequenceOrder.length) {
                    labelOrder[i] = this.sequenceOrder[i].getName();
                    ++i;
                }
                this.multipleAlignment = BioJavaHelper.convertAlignment(alignment, labelOrder);
                return alignment;
            }

            public Sequence[] getSequencOrder() {
                return this.sequenceOrder;
            }

            public MultipleAlignment getMultipleAlignment() {
                return this.multipleAlignment;
            }

            @Override
            public void done() {
                try {
                    CAMAAlignmentProcessing.this.config.setMultipleAlignment(this.getMultipleAlignment());
                    CAMAAlignmentProcessing.this.config.setAlphabetIndex(CAMAAlignmentProcessing.this.config.getAlphabetIndex());
                    CAMAAlignmentProcessing.this.config.setAlphabet(CAMAAlignmentProcessing.this.config.getAlphabetIndex().getAlphabet());
                    CAMAAlignmentProcessing.this.config.setAlignment((Alignment)this.get());
                    CAMAAlignmentProcessing.this.config.setSequenceOrder(this.getSequencOrder());
                    CAMAAlignmentProcessing.this.progressMonitor.setProgress(1);
                    CAMAAlignmentProcessing.this.hmmConstructionTask = new HMMConstructionTask((Alignment)this.get());
                    CAMAAlignmentProcessing.this.progressMonitor.setNote("HMM processing...");
                    CAMAAlignmentProcessing.this.hmmConstructionTask.execute();
                }
                catch (InterruptedException e) {
                    String title = "Invalid file format";
                    String message = "Could not open Alignment file.";
                    JOptionPane.showMessageDialog(CAMA.this, message, title, 0);
                }
                catch (ExecutionException e) {
                    String title = "Reading Error";
                    String message = "Could not open Alignment file.";
                    e.printStackTrace();
                    message = e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().startsWith("All SymbolLists must be the same length") ? "Sequences must have equal lengths." : "Alignment could not be opened.\n Please check if you selected the right format\nand selected/provided the corresponding alphabet.";
                    JOptionPane.showMessageDialog(CAMA.this, message, title, 0);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CharComparator
    implements Comparator {
        private Map<Character, Integer> counts;

        public CharComparator(Map<Character, Integer> counts) {
            this.counts = counts;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Character && o2 instanceof Character) {
                Character c1 = (Character)o1;
                Character c2 = (Character)o2;
                return this.counts.get(c1) > this.counts.get(c2) ? -1 : 1;
            }
            return 0;
        }
    }

    public class CustomAlphabetAbortedException
    extends Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GenericFileFilter
    extends FileFilter {
        private Set<String> extensions;
        private String description;

        public GenericFileFilter(String description, Collection<String> extensions) {
            this.description = description;
            if (extensions != null) {
                this.extensions = new HashSet<String>(extensions);
            }
        }

        private String getExtension(File f) {
            int index = f.getName().lastIndexOf(46);
            if (index < 0) {
                return null;
            }
            return f.getName().substring(index + 1);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory() || this.extensions == null) {
                return true;
            }
            return this.extensions.contains(this.getExtension(f));
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

