/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.CADefaultModel;
import de.biozentrum.bioinformatik.ca.CorrespondenceAnalysis;
import de.biozentrum.bioinformatik.ca.ext.alignment.CAMADataProvider;
import de.biozentrum.bioinformatik.ca.ext.selection.SelectionStore;
import de.biozentrum.bioinformatik.cama.BioJavaHelper;
import de.biozentrum.bioinformatik.cama.CAMA;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;

public class CAMAConfiguration
implements Serializable {
    private static final long serialVersionUID = 7363718080340490835L;
    private SequenceColorModel sequenceColorModel;
    private String name;
    private CAMA.AlignmentType alignmentType;
    private FiniteAlphabet alphabet;
    private transient AlphabetIndex alphabetIndex;
    private transient MultipleAlignment multipleAlignment;
    private transient Alignment alignment;
    private DoubleMatrix2D fisherScores;
    private CorrespondenceAnalysis corresponenceAnalysis;
    private transient CADataModel dataModel;
    private transient CAMADataProvider dataProvider;
    private Sequence[] sequenceOrder;
    private boolean[] columnMask;
    private SelectionStore selectionStore = new SelectionStore();

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        Object[] sequenceNames = new String[this.sequenceOrder.length];
        int index = 0;
        HashMap<String, Sequence> map = new HashMap<String, Sequence>();
        Sequence[] sequenceArray = this.sequenceOrder;
        int n = this.sequenceOrder.length;
        int n2 = 0;
        while (n2 < n) {
            Sequence seq = sequenceArray[n2];
            sequenceNames[index] = seq.getName();
            ++index;
            map.put(seq.getName(), seq);
            ++n2;
        }
        this.alignment = new SimpleAlignment(map);
        this.setAlphabetIndex(BioJavaHelper.createNonatomicAlphabetIndex(this.getAlphabet()));
        this.setMultipleAlignment(BioJavaHelper.convertAlignment(this.getAlignment(), sequenceNames));
        this.setDataProvider(new CAMADataProvider(this.getFisherScores(), this.getMultipleAlignment(), this.getAlphabetIndex()));
        this.setDataModel(new CADefaultModel(this.getCorresponenceAnalysis()));
        this.getDataModel().setAnnotation(this.getDataProvider());
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    public void setAlignmentType(CAMA.AlignmentType alignmentType) {
        this.alignmentType = alignmentType;
    }

    public CAMA.AlignmentType getAlignmentType() {
        return this.alignmentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAlphabet(FiniteAlphabet alphabet) {
        this.alphabet = alphabet;
    }

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabetIndex(AlphabetIndex alphabetIndex) {
        this.alphabetIndex = alphabetIndex;
    }

    public AlphabetIndex getAlphabetIndex() {
        return this.alphabetIndex;
    }

    public void setMultipleAlignment(MultipleAlignment multipleAlignment) {
        this.multipleAlignment = multipleAlignment;
    }

    public MultipleAlignment getMultipleAlignment() {
        return this.multipleAlignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setFisherScores(DoubleMatrix2D fisherScores) {
        this.fisherScores = fisherScores;
    }

    public DoubleMatrix2D getFisherScores() {
        return this.fisherScores;
    }

    public void setCorresponenceAnalysis(CorrespondenceAnalysis corresponenceAnalysis) {
        this.corresponenceAnalysis = corresponenceAnalysis;
    }

    public CorrespondenceAnalysis getCorresponenceAnalysis() {
        return this.corresponenceAnalysis;
    }

    public void setDataModel(CADataModel dataModel) {
        this.dataModel = dataModel;
        this.selectionStore.setModel(dataModel);
    }

    public CADataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataProvider(CAMADataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public CAMADataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setColumnMask(boolean[] columnMask) {
        this.columnMask = columnMask;
    }

    public boolean[] getColumnMask() {
        return this.columnMask;
    }

    public void setSequenceOrder(Sequence[] sequenceOrder) {
        this.sequenceOrder = sequenceOrder;
    }

    public Sequence[] getSequenceOrder() {
        return this.sequenceOrder;
    }

    public SelectionStore getSelectionStore() {
        return this.selectionStore;
    }

    public void setSequenceColorModel(SequenceColorModel sequenceColorModel) {
        this.sequenceColorModel = sequenceColorModel;
    }

    public SequenceColorModel getSequenceColorModel() {
        return this.sequenceColorModel;
    }
}

