/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.alignment.MultipleAlignment;
import de.biozentrum.bioinformatik.ca.CADataModel;
import de.biozentrum.bioinformatik.ca.CorrespondenceAnalysis;
import de.biozentrum.bioinformatik.ca.ext.CAExtensionRegistry;
import de.biozentrum.bioinformatik.ca.ext.alignment.AlignmentExtension;
import de.biozentrum.bioinformatik.ca.ext.alignment.CAMADataProvider;
import de.biozentrum.bioinformatik.ca.ext.plot.CAChartPanel;
import de.biozentrum.bioinformatik.ca.ext.plot.CAPlotToolbar;
import de.biozentrum.bioinformatik.ca.ext.plot.CAXYPlot;
import de.biozentrum.bioinformatik.ca.ext.selection.SelectionExtension;
import de.biozentrum.bioinformatik.ca.ext.selection.SelectionStorageExtension;
import de.biozentrum.bioinformatik.cama.CAMA;
import de.biozentrum.bioinformatik.cama.CAMAConfiguration;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetIndex;
import org.jfree.chart.JFreeChart;

public class CAMAFrame
extends JInternalFrame {
    CAMA.AlignmentType type;
    CAMA.AlignmentFormat format;
    double caProgress;
    JPanel view;
    AlignmentExtension extension;
    SelectionExtension selectionExtension;
    SelectionStorageExtension selectionStorageExtension;
    JCheckBox annotate;
    CAExtensionRegistry extRegistry;
    CAMADataProvider provider;
    CorrespondenceAnalysis ca;
    MultipleAlignment alnmodel;
    CAChartPanel panel;
    AlphabetIndex alphabetIndex;
    Action action;
    Action svgExportAction;
    Action fisherExportAction;
    CAMAConfiguration configuration;

    public Action getSVGExportAction() {
        return this.svgExportAction;
    }

    public Action getFisherExportAction() {
        return this.fisherExportAction;
    }

    public Action getAction() {
        return this.action;
    }

    public CAMAConfiguration getConfiguration() {
        return this.configuration;
    }

    public CAMAFrame(CAMAConfiguration configuration) {
        super(configuration.getName(), true, true, true, true);
        this.configuration = configuration;
        this.svgExportAction = new AbstractAction("Plot"){

            public void actionPerformed(ActionEvent e) {
                try {
                    CAMAFrame.this.panel.doSaveAs();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.fisherExportAction = new AbstractAction("FisherScores"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int retval = chooser.showSaveDialog(CAMAFrame.this);
                if (retval == 0) {
                    try {
                        File file = chooser.getSelectedFile();
                        FileWriter writer = new FileWriter(file);
                        DoubleMatrix2D dataMatrix = CAMAFrame.this.configuration.getFisherScores();
                        AlphabetIndex index = CAMAFrame.this.configuration.getAlphabetIndex();
                        int symbolCount = index.getAlphabet().size();
                        SymbolTokenization tokenization = index.getAlphabet().getTokenization("token");
                        StringBuffer header = new StringBuffer();
                        int j = 0;
                        while (j < dataMatrix.columns()) {
                            header.append(",");
                            header.append(tokenization.tokenizeSymbol(index.symbolForIndex(j % symbolCount)));
                            header.append("_");
                            header.append(j / symbolCount);
                            ++j;
                        }
                        header.append("\n");
                        writer.write(header.toString());
                        int i = 0;
                        while (i < dataMatrix.rows()) {
                            StringBuffer fisherScores = new StringBuffer();
                            Sequence s = CAMAFrame.this.configuration.getSequenceOrder()[i];
                            fisherScores.append(s.getName());
                            fisherScores.append(",");
                            int j2 = 0;
                            while (j2 < dataMatrix.columns() - 1) {
                                fisherScores.append(dataMatrix.getQuick(i, j2));
                                fisherScores.append(",");
                                ++j2;
                            }
                            fisherScores.append(dataMatrix.getQuick(i, dataMatrix.columns() - 1));
                            fisherScores.append("\n");
                            writer.write(fisherScores.toString());
                            ++i;
                        }
                        writer.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.action = new AbstractAction(configuration.getName()){

            public void actionPerformed(ActionEvent e) {
                try {
                    CAMAFrame.this.setSelected(true);
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.setSize(200, 100);
    }

    public void createGUI() {
        this.extension = new AlignmentExtension();
        this.extension.setAlignment(this.configuration.getMultipleAlignment(), this.configuration.getAlphabetIndex(), this.configuration.getAlphabet());
        this.extension.setColumnMask(this.configuration.getColumnMask());
        this.configuration.getDataProvider().setPositionMap(this.extension);
        SequenceColorModel colorModel = this.configuration.getSequenceColorModel();
        if (colorModel == null) {
            colorModel = this.configuration.getAlignmentType() == CAMA.AlignmentType.AminoAcid ? SequenceColorModel.AMINOACID_MODEL : SequenceColorModel.NUCLEOTIDE_MODEL;
            this.configuration.setSequenceColorModel(colorModel);
        }
        this.extension.getAlignmentView().setSequenceColorModel(colorModel);
        this.selectionExtension = new SelectionExtension();
        this.selectionStorageExtension = new SelectionStorageExtension(this.configuration);
        JPanel c = new JPanel();
        c.setLayout(new BorderLayout());
        this.view = new JPanel();
        CADataModel model = this.configuration.getDataModel();
        CAXYPlot plot = new CAXYPlot(model);
        JFreeChart freeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        freeChart.setAntiAlias(false);
        this.panel = new CAChartPanel(freeChart);
        this.panel.setMouseWheelEnabled(true);
        this.panel.setMouseZoomable(true, true);
        this.panel.setDataModel(model);
        CAPlotToolbar bar = new CAPlotToolbar(this.panel);
        bar.setModel(model);
        this.view.setLayout(new BorderLayout());
        this.view.add((Component)bar, "North");
        this.view.add((Component)this.panel, "Center");
        this.extRegistry = new CAExtensionRegistry();
        this.extRegistry.add(this.selectionExtension);
        this.extRegistry.add(this.extension);
        this.extRegistry.add(this.selectionStorageExtension);
        JSplitPane sPane = new JSplitPane(0);
        sPane.setResizeWeight(0.5);
        sPane.setMinimumSize(new Dimension(200, 200));
        this.selectionExtension.getComponent().setSize(new Dimension(100, 200));
        this.selectionStorageExtension.getComponent().setSize(new Dimension(100, 200));
        sPane.add(this.selectionExtension.getComponent());
        sPane.add(this.selectionStorageExtension.getComponent());
        JSplitPane horizontalSplit = new JSplitPane(1, sPane, this.view);
        JSplitPane verticalSplit = new JSplitPane(0, horizontalSplit, this.extension.getComponent());
        verticalSplit.setResizeWeight(0.6);
        horizontalSplit.setResizeWeight(0.0);
        c.add((Component)verticalSplit, "Center");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)c, "Center");
        this.extRegistry.setDataModel(this.configuration.getDataModel());
        this.panel.restoreAutoBounds();
        this.panel.setFocusable(true);
        String chars = "0123456789qwertzuiopasdfghjklyxcvbnm";
        String upperCase = chars.toUpperCase();
        int i = 0;
        while (i < chars.length()) {
            char cc = chars.charAt(i);
            char uc = upperCase.charAt(i);
            String s = String.valueOf(String.valueOf(cc)) + "_CMD";
            ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(cc), s);
            ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke((int)uc, 2), s);
            ((JComponent)this.getContentPane()).getInputMap(1).put(KeyStroke.getKeyStroke((int)uc, 2), s);
            ((JComponent)this.getContentPane()).getInputMap(1).put(KeyStroke.getKeyStroke(cc), s);
            ((JComponent)this.getContentPane()).getActionMap().put(s, this.selectionStorageExtension.createSelectionAction(cc));
            ++i;
        }
        verticalSplit.setDividerLocation(0.6);
        sPane.setDividerLocation(0.5);
    }

    public void setShowsSelectedItemLabels(boolean flag) {
        ((CAXYPlot)this.panel.getChart().getXYPlot()).showLabels(flag);
    }

    public boolean showsSelectedItemLabels() {
        return ((CAXYPlot)this.panel.getChart().getXYPlot()).showsLabels();
    }
}

