/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import de.biozentrum.bioinformatik.cama.CAMAConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class OpenSessionDialog
extends JDialog {
    private OpenSessionWorker worker;
    private File file;

    public OpenSessionDialog(JFrame frame, File file) {
        super((Frame)frame, false);
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel label = new JLabel("Loading CAMA session ...");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        contentPane.add((Component)label, "North");
        contentPane.add((Component)progressBar, "South");
        this.setSize(250, 100);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.file = file;
    }

    public void showModal() {
        this.setVisible(true);
        this.worker = new OpenSessionWorker(this.file);
        this.worker.execute();
    }

    public CAMAConfiguration getConfiguration() throws InterruptedException, ExecutionException {
        return (CAMAConfiguration)this.worker.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OpenSessionWorker
    extends SwingWorker<CAMAConfiguration, Void> {
        private File file;

        public OpenSessionWorker(File file) {
            this.file = file;
        }

        @Override
        protected CAMAConfiguration doInBackground() throws Exception {
            FileInputStream fis = new FileInputStream(this.file);
            ObjectInputStream in = new ObjectInputStream(fis);
            CAMAConfiguration config = (CAMAConfiguration)in.readObject();
            in.close();
            return config;
        }

        @Override
        public void done() {
            OpenSessionDialog.this.setVisible(false);
        }
    }
}

