/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.cama;

import cern.colt.matrix.DoubleMatrix2D;
import de.biozentrum.bioinformatik.cama.BioJavaHelper;
import de.biozentrum.bioinformatik.cama.hmm.ProfileHMMTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.biojava.bio.dp.ProfileHMM;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class Test {
    public static void main(String[] args) throws Exception {
        File file = new File("/alignment.fasta");
        BufferedReader bufferedReaderB = new BufferedReader(new FileReader(file));
        FiniteAlphabet alphabet = DNATools.getDNA();
        RichSequenceIterator iterator = RichSequence.IOTools.readFastaDNA(bufferedReaderB, null);
        ArrayList<RichSequence> sequenceOrder = new ArrayList<RichSequence>();
        Alignment alignment = BioJavaHelper.createAlignment(iterator, sequenceOrder);
        ScoreType scoreType = ScoreType.PROBABILITY;
        ProfileHMM profileHMM = ProfileHMMTools.createProfile(alignment, 0.51, 1);
        AlphabetIndex index = AlphabetManager.getAlphabetIndex(alphabet);
        DoubleMatrix2D matrix = ProfileHMMTools.getEmissionMatrix(profileHMM, 0, index);
        int i = 0;
        while (i < matrix.rows()) {
            int j = 0;
            while (j < matrix.columns()) {
                System.out.print(String.valueOf(matrix.getQuick(i, j)) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println(profileHMM.columns());
        System.out.println(profileHMM.getInsert(0));
        System.out.println(profileHMM.getMatch(0));
    }
}

