/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.sequence;

import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.sequence.events.SequenceChangedEvent;
import de.biozentrum.bioinformatik.sequence.events.SequenceListener;
import de.biozentrum.bioinformatik.sequence.selection.DefaultSequenceSelectionModel;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sequence {
    protected transient ArrayList<SequenceListener> listeners;
    protected StringBuffer sequence;
    protected SequenceSelectionModel selectionModel;
    protected HashMap<String, Object> attributeList = new HashMap();
    protected String name;

    public Sequence(String name, String sequence) {
        this(name, new StringBuffer(sequence));
    }

    public Sequence(String name, StringBuffer sequence) {
        this.name = name;
        this.sequence = sequence;
        this.listeners = new ArrayList();
        this.selectionModel = new DefaultSequenceSelectionModel(this);
    }

    public void setAttribute(String key, Object value) {
        this.attributeList.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributeList.get(key);
    }

    public SequenceSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SequenceSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void deleteCharAt(Object source, int position) {
        this.sequence.deleteCharAt(position);
        this.fireSequenceChangedEvent(source, position, position + 1, MAEvent.MAEventType.DELETE);
    }

    public void delete(Object source, int from, int to) {
        this.sequence.delete(from, to);
        this.fireSequenceChangedEvent(source, from, to, MAEvent.MAEventType.DELETE);
    }

    public void insertCharAt(Object source, char c, int position) {
        this.sequence.insert(position, c);
        this.fireSequenceChangedEvent(source, position, position + 1, MAEvent.MAEventType.INSERT);
    }

    public void insert(Object source, char[] str, int position) {
        this.sequence.insert(position, str);
        this.fireSequenceChangedEvent(source, position, position + str.length, MAEvent.MAEventType.INSERT);
    }

    public CharSequence subSequence(int start, int end) {
        return this.sequence.subSequence(start, end);
    }

    public char charAt(int position) {
        return this.sequence.charAt(position);
    }

    public String getAlignedSequence() {
        return this.sequence.toString();
    }

    public String getSequence() {
        return this.getAlignedSequence().replaceAll("-", "");
    }

    public Matcher match(String regex, boolean alignedSequence) {
        if (alignedSequence) {
            return Pattern.compile(regex).matcher(this.getAlignedSequence());
        }
        return Pattern.compile(regex).matcher(this.getSequence());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int length() {
        return this.sequence.length();
    }

    public String toString() {
        return ">" + this.name + "\n" + this.sequence;
    }

    protected void fireSequenceChangedEvent(SequenceChangedEvent e) {
        ArrayList<SequenceListener> lists = new ArrayList<SequenceListener>(this.listeners);
        for (SequenceListener listener : lists) {
            listener.sequenceChanged(e);
        }
    }

    protected void fireSequenceChangedEvent(Object source, int from, int to, MAEvent.MAEventType type) {
        this.fireSequenceChangedEvent(new SequenceChangedEvent(source, this, from, to, type));
    }

    public void addSequenceListener(SequenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeSequenceListener(SequenceListener listener) {
        this.listeners.remove(listener);
    }

    public void fillUpWithGaps(int length) {
        int diff = length - this.length();
        char[] gaps = new char[diff];
        int i = 0;
        while (i < gaps.length) {
            gaps[i] = 45;
            ++i;
        }
        this.insert(this, gaps, this.length());
    }
}

