/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.sequence;

import de.biozentrum.bioinformatik.sequence.Sequence;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import de.biozentrum.bioinformatik.sequence.SequenceImages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class SequenceComponent
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 3761973756763320633L;
    protected final int boxPixels = 18;
    protected final int boxDistance = 1;
    protected Sequence sequenceModel;
    protected SequenceColorModel colorModel;
    protected SequenceImages images;
    protected boolean needsCompleteRedraw;
    protected BufferedImage buffer;
    protected Dimension preferredSize;

    public SequenceComponent(Sequence model) {
        this.sequenceModel = model;
        this.addMouseListener(this);
        this.preferredSize = new Dimension(19 * this.sequenceModel.length(), 20);
        this.needsCompleteRedraw = true;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        this.buffer = gc.createCompatibleImage(this.preferredSize.width, this.preferredSize.height, 3);
        this.colorModel = SequenceColorModel.NUCLEOTIDE_MODEL;
        this.images = new SequenceImages(this.colorModel);
    }

    public void setSequenceModel(Sequence model) {
        this.sequenceModel = model;
    }

    public Sequence getSequenceModel() {
        return this.sequenceModel;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gc = (Graphics2D)g;
        if (this.needsCompleteRedraw) {
            Graphics2D ic = (Graphics2D)this.buffer.getGraphics();
            int i = 0;
            while (i < this.sequenceModel.length()) {
                ic.drawImage(this.images.getBGImageForChar(this.sequenceModel.charAt(i)), null, 0, 0);
                ic.setColor(Color.black);
                ic.drawString(new String(new char[]{this.sequenceModel.charAt(i)}), 5, 13);
                ic.translate(19, 0);
                ++i;
            }
            this.needsCompleteRedraw = false;
        }
        gc.drawImage(this.buffer, null, 0, 0);
    }

    protected int getCharPositionForPoint(Point p) {
        return p.x / 19;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public int getWidth() {
        return this.sequenceModel.length() * 19;
    }

    public int getHeight() {
        return 20;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent arg0) {
    }
}

