/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.sequence;

import de.biozentrum.bioinformatik.color.ColorChangedEvent;
import de.biozentrum.bioinformatik.color.ColorModelListener;
import de.biozentrum.bioinformatik.sequence.SequenceColorModel;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

public class SequenceImages
implements ColorModelListener {
    protected SequenceColorModel colorModel;
    protected Hashtable images;
    protected BufferedImage defaultImage;

    public SequenceImages(SequenceColorModel colorModel) {
        this.colorModel = colorModel;
        this.colorModel.addColorModelListener(this);
        this.images = new Hashtable();
        this.refreshAllImages();
    }

    public void refreshAllImages() {
        char[] coloredChars = this.colorModel.getColoredChars();
        int i = 0;
        while (i < coloredChars.length) {
            this.generateImageForChar(coloredChars[i]);
            ++i;
        }
        this.defaultImage = this.generateImage(this.colorModel.getDefaultCharColor());
    }

    protected void generateImageForChar(char c) {
        Color color = this.colorModel.getColorForChar(c);
        this.images.put(String.valueOf(c), this.generateImage(color));
    }

    protected BufferedImage generateImage(Color color) {
        int[] nArray = new int[8];
        nArray[0] = 3;
        nArray[1] = 15;
        nArray[2] = 18;
        nArray[3] = 18;
        nArray[4] = 15;
        nArray[5] = 3;
        int[] nArray2 = new int[8];
        nArray2[2] = 3;
        nArray2[3] = 15;
        nArray2[4] = 18;
        nArray2[5] = 18;
        nArray2[6] = 15;
        nArray2[7] = 3;
        Polygon p = new Polygon(nArray, nArray2, 8);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(18, 18, 3);
        Color startColor = Color.white;
        Graphics2D ig = (Graphics2D)image.getGraphics();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, startColor, 0.0f, 25.0f, color, false);
        ig.setPaint(paint);
        ig.fill(p);
        ig.setColor(color);
        ig.draw(p);
        return image;
    }

    public BufferedImage getBGImageForChar(char c) {
        BufferedImage image = (BufferedImage)this.images.get(String.valueOf(c));
        if (image == null) {
            image = this.defaultImage;
        }
        return image;
    }

    public void colorModelChanged(ColorChangedEvent e) {
    }
}

