/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.sequence.selection;

import de.biozentrum.bioinformatik.alignment.events.MAEvent;
import de.biozentrum.bioinformatik.sequence.Sequence;
import de.biozentrum.bioinformatik.sequence.events.SequenceChangedEvent;
import de.biozentrum.bioinformatik.sequence.events.SequenceListener;
import de.biozentrum.bioinformatik.sequence.selection.SequenceRange;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionEvent;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionListener;
import de.biozentrum.bioinformatik.sequence.selection.SequenceSelectionModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSequenceSelectionModel
implements SequenceListener,
SequenceSelectionModel {
    protected ArrayList<Boolean> selectionMask;
    protected Sequence sequence;
    private ArrayList<SequenceSelectionListener> listeners = new ArrayList();

    public DefaultSequenceSelectionModel(Sequence sequence) {
        this.sequence = sequence;
        this.sequence.addSequenceListener(this);
        this.selectionMask = new ArrayList(sequence.length());
        int i = 0;
        while (i < sequence.length()) {
            this.selectionMask.add(false);
            ++i;
        }
    }

    @Override
    public void removeSequenceSelectionListener(SequenceSelectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addSequenceSelectionListener(SequenceSelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void select(Object source, int start, int end, boolean ignoreGaps) {
        if (this.isSelected(start, end, ignoreGaps)) {
            return;
        }
        if (ignoreGaps) {
            int i = start;
            while (i <= end) {
                if (this.sequence.charAt(i) != '-') {
                    this.selectionMask.set(i, true);
                }
                ++i;
            }
        } else {
            int i = start;
            while (i <= end) {
                this.selectionMask.set(i, true);
                ++i;
            }
        }
        this.fireSequenceSelectionInserted(source, start, end);
    }

    @Override
    public void select(Object source, SequenceRange range, boolean ignoreGaps) {
        this.select(source, range.getStart(), range.getEnd(), ignoreGaps);
    }

    @Override
    public void deselect(Object source, int start, int end) {
        if (this.isDeselected(start, end, false)) {
            return;
        }
        int i = start;
        while (i <= end) {
            this.selectionMask.set(i, false);
            ++i;
        }
        this.fireSequenceSelectionRemoved(source, start, end);
    }

    protected void fireSequenceSelectionInserted(Object source, int from, int to) {
        this.fireSequenceSelectionEvent(new SequenceSelectionEvent(source, new SequenceRange(this.sequence, from, to), MAEvent.MAEventType.INSERT));
    }

    protected void fireSequenceSelectionRemoved(Object source, int from, int to) {
        this.fireSequenceSelectionEvent(new SequenceSelectionEvent(source, new SequenceRange(this.sequence, from, to), MAEvent.MAEventType.DELETE));
    }

    protected void fireSequenceSelectionEvent(SequenceSelectionEvent e) {
        for (SequenceSelectionListener sequenceListener : this.listeners) {
            sequenceListener.selectionChanged(e);
        }
    }

    @Override
    public void deselect(Object source, SequenceRange range) {
        this.deselect(source, range.getStart(), range.getEnd());
    }

    @Override
    public Iterator<SequenceRange> iterator() {
        return new SequenceRangeIterator();
    }

    @Override
    public void deselectAll(Object source) {
        this.deselect(source, 0, this.selectionMask.size() - 1);
    }

    @Override
    public void select(int start, int end, boolean ignoreGaps) {
        this.select(this, start, end, ignoreGaps);
    }

    @Override
    public void select(SequenceRange range, boolean ignoreGaps) {
        this.select(this, range, ignoreGaps);
    }

    @Override
    public void deselect(int start, int end) {
        this.deselect(this, start, end);
    }

    @Override
    public void deselect(SequenceRange range) {
        this.deselect(this, range);
    }

    @Override
    public void deselectAll() {
        this.deselectAll(this);
    }

    @Override
    public boolean isSelected(int from, int to, boolean ignoreGaps) {
        boolean temp = true;
        int i = from;
        do {
            if (ignoreGaps && this.sequence.charAt(i) == '-') continue;
            temp = this.selectionMask.get(i);
        } while (++i <= to && temp);
        return temp;
    }

    @Override
    public boolean isSelected(SequenceRange range, boolean ignoreGaps) {
        return this.isSelected(range.getStart(), range.getEnd(), ignoreGaps);
    }

    @Override
    public void sequenceChanged(SequenceChangedEvent e) {
        block3: {
            block2: {
                if (e.getType() != MAEvent.MAEventType.DELETE) break block2;
                int i = e.getLastPos() - 1;
                while (i >= e.getFirstPos()) {
                    this.selectionMask.remove(i);
                    --i;
                }
                break block3;
            }
            if (e.getType() != MAEvent.MAEventType.INSERT) break block3;
            int i = e.getFirstPos();
            while (i < e.getLastPos()) {
                this.selectionMask.add(i, false);
                ++i;
            }
        }
    }

    @Override
    public void select(Object source, String regex) {
        Matcher m = Pattern.compile(regex).matcher(this.sequence.getAlignedSequence());
        int start = 0;
        while (m.find(start)) {
            this.select(m.start(), m.end() - 1, false);
            start = m.start() + 1;
        }
    }

    @Override
    public void select(String regex) {
        this.select(this, regex);
    }

    @Override
    public boolean isDeselected(int from, int to, boolean ignoreGaps) {
        boolean temp = true;
        int i = from;
        do {
            if (ignoreGaps && this.sequence.charAt(i) == '-') continue;
            boolean bl = temp = this.selectionMask.get(i) == false;
        } while (++i <= to && temp);
        return temp;
    }

    @Override
    public boolean isDeselected(SequenceRange range, boolean ignoreGaps) {
        return this.isDeselected(range.getStart(), range.getEnd(), ignoreGaps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceRangeIterator
    implements Iterator<SequenceRange> {
        int currentPosition = 0;
        int lastSelectedPosition;

        public SequenceRangeIterator() {
            int i = DefaultSequenceSelectionModel.this.selectionMask.size() - 1;
            while (!DefaultSequenceSelectionModel.this.selectionMask.get(i).booleanValue() && i >= 0) {
                --i;
            }
            this.lastSelectedPosition = i;
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition < this.lastSelectedPosition;
        }

        @Override
        public SequenceRange next() {
            while (!DefaultSequenceSelectionModel.this.selectionMask.get(this.currentPosition).booleanValue() && this.currentPosition < DefaultSequenceSelectionModel.this.selectionMask.size()) {
                ++this.currentPosition;
            }
            int start = this.currentPosition;
            while (DefaultSequenceSelectionModel.this.selectionMask.get(this.currentPosition).booleanValue() && this.currentPosition < DefaultSequenceSelectionModel.this.selectionMask.size()) {
                ++this.currentPosition;
            }
            int end = this.currentPosition - 1;
            if (end >= start) {
                return new SequenceRange(DefaultSequenceSelectionModel.this.sequence, start, end);
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

