/*
 * Decompiled with CFR 0.152.
 */
package de.biozentrum.bioinformatik.sequence.selection;

import de.biozentrum.bioinformatik.sequence.Sequence;

public class SequenceRange {
    protected Sequence sequence;
    protected int start;
    protected int end;

    public SequenceRange(Sequence sequence, int start, int end) {
        this.sequence = sequence;
        this.start = start;
        this.end = end;
    }

    public SequenceRange combine(SequenceRange otherRange) {
        if (this.start > otherRange.getEnd() + 1 || otherRange.getStart() > this.end + 1) {
            return null;
        }
        int newStart = Math.min(this.start, otherRange.getStart());
        int newEnd = Math.max(this.end, otherRange.getEnd());
        return new SequenceRange(this.sequence, newStart, newEnd);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public CharSequence charSequence() {
        return this.sequence.subSequence(this.start, this.end);
    }
}

