/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.alignment.SequenceAlignment;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeedlemanWunsch
extends SequenceAlignment {
    protected int[][] CostMatrix;
    protected SubstitutionMatrix subMatrix;
    protected Alignment pairalign;
    protected String alignment;
    private short insert;
    private short delete;
    private short gapExt;
    private short match;
    private short replace;

    public NeedlemanWunsch(short match, short replace, short insert, short delete, short gapExtend, SubstitutionMatrix subMat) {
        this.subMatrix = subMat;
        this.insert = insert;
        this.delete = delete;
        this.gapExt = gapExtend;
        this.match = match;
        this.replace = replace;
        this.alignment = "";
    }

    public void setSubstitutionMatrix(SubstitutionMatrix matrix) {
        this.subMatrix = matrix;
    }

    public void setInsert(short ins) {
        this.insert = ins;
    }

    public void setDelete(short del) {
        this.delete = del;
    }

    public void setGapExt(short ge) {
        this.gapExt = ge;
    }

    public void setMatch(short ma) {
        this.match = ma;
    }

    public void setReplace(short rep) {
        this.replace = rep;
    }

    public short getInsert() {
        return this.insert;
    }

    public short getDelete() {
        return this.delete;
    }

    public short getGapExt() {
        return this.gapExt;
    }

    public short getMatch() {
        return this.match;
    }

    public short getReplace() {
        return this.replace;
    }

    public static String printCostMatrix(int[][] CostMatrix, char[] queryChar, char[] targetChar) {
        int line;
        int col;
        String output = "\t";
        for (col = 0; col <= targetChar.length; ++col) {
            output = col == 0 ? output + "[" + col + "]\t" : output + "[" + targetChar[col - 1] + "]\t";
        }
        for (line = 0; line <= queryChar.length; ++line) {
            output = line == 0 ? output + System.getProperty("line.separator") + "[" + line + "]\t" : output + System.getProperty("line.separator") + "[" + queryChar[line - 1] + "]\t";
            for (col = 0; col <= targetChar.length; ++col) {
                output = output + CostMatrix[line][col] + "\t";
            }
        }
        output = output + System.getProperty("line.separator") + "delta[Edit] = " + CostMatrix[line - 1][col - 1] + System.getProperty("line.separator");
        return output;
    }

    public static void printAlignment(String align) {
        System.out.print(align);
    }

    @Override
    public Alignment getAlignment(SymbolList query, SymbolList target) throws Exception {
        this.pairwiseAlignment(query, target);
        return this.pairalign;
    }

    public int getEditDistance() {
        return this.CostMatrix[this.CostMatrix.length - 1][this.CostMatrix[this.CostMatrix.length - 1].length - 1];
    }

    protected static int min(int x, int y, int z) {
        if (x < y && x < z) {
            return x;
        }
        if (y < z) {
            return y;
        }
        return z;
    }

    @Override
    public String getAlignmentString() throws BioException {
        return this.alignment;
    }

    @Override
    public List<Alignment> alignAll(SequenceIterator source, SequenceDB subjectDB) throws NoSuchElementException, BioException {
        LinkedList<Alignment> l = new LinkedList<Alignment>();
        while (source.hasNext()) {
            Sequence query = source.nextSequence();
            SequenceIterator target = subjectDB.sequenceIterator();
            while (target.hasNext()) {
                try {
                    l.add(this.getAlignment(query, target.nextSequence()));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return l;
    }

    @Override
    public int pairwiseAlignment(SymbolList query, SymbolList subject) throws BioRuntimeException {
        Sequence squery = null;
        Sequence ssubject = null;
        squery = query instanceof Sequence ? (Sequence)query : new SimpleSequence(query, "", "query", new SimpleAnnotation());
        ssubject = subject instanceof Sequence ? (Sequence)subject : new SimpleSequence(subject, "", "subject", new SimpleAnnotation());
        if (squery.getAlphabet().equals(ssubject.getAlphabet()) && squery.getAlphabet().equals(this.subMatrix.getAlphabet())) {
            int j;
            int i;
            long time = System.currentTimeMillis();
            this.CostMatrix = new int[squery.length() + 1][ssubject.length() + 1];
            String[] align = new String[]{"", ""};
            String path = "";
            this.CostMatrix[0][0] = 0;
            if (this.gapExt != this.delete || this.gapExt != this.insert) {
                int j2;
                int i2;
                int[][] E = new int[squery.length() + 1][ssubject.length() + 1];
                int[][] F = new int[squery.length() + 1][ssubject.length() + 1];
                F[0][0] = Integer.MAX_VALUE;
                E[0][0] = Integer.MAX_VALUE;
                for (i2 = 1; i2 <= squery.length(); ++i2) {
                    E[i2][0] = Integer.MAX_VALUE;
                    int n = this.delete + i2 * this.gapExt;
                    F[i2][0] = n;
                    this.CostMatrix[i2][0] = n;
                }
                for (j2 = 1; j2 <= ssubject.length(); ++j2) {
                    F[0][j2] = Integer.MAX_VALUE;
                    int n = this.insert + j2 * this.gapExt;
                    E[0][j2] = n;
                    this.CostMatrix[0][j2] = n;
                }
                for (i2 = 1; i2 <= squery.length(); ++i2) {
                    for (j2 = 1; j2 <= ssubject.length(); ++j2) {
                        E[i2][j2] = Math.min(E[i2][j2 - 1], this.CostMatrix[i2][j2 - 1] + this.insert) + this.gapExt;
                        F[i2][j2] = Math.min(F[i2 - 1][j2], this.CostMatrix[i2 - 1][j2] + this.delete) + this.gapExt;
                        this.CostMatrix[i2][j2] = NeedlemanWunsch.min(E[i2][j2], F[i2][j2], this.CostMatrix[i2 - 1][j2 - 1] - this.matchReplace(squery, ssubject, i2, j2));
                    }
                }
                try {
                    boolean[] gap_extend = new boolean[]{false, false};
                    j2 = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                    SymbolTokenization st = this.subMatrix.getAlphabet().getTokenization("default");
                    i2 = this.CostMatrix.length - 1;
                    while (i2 > 0) {
                        do {
                            if (i2 == 0) {
                                align[0] = '~' + align[0];
                                align[1] = st.tokenizeSymbol(ssubject.symbolAt(j2--)) + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            if (j2 == 0) {
                                align[0] = st.tokenizeSymbol(squery.symbolAt(i2--)) + align[0];
                                align[1] = '~' + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            if (this.CostMatrix[i2][j2] == this.CostMatrix[i2 - 1][j2 - 1] - this.matchReplace(squery, ssubject, i2, j2) && !gap_extend[0] && !gap_extend[1]) {
                                path = squery.symbolAt(i2) == ssubject.symbolAt(j2) ? '|' + path : ' ' + path;
                                align[0] = st.tokenizeSymbol(squery.symbolAt(i2--)) + align[0];
                                align[1] = st.tokenizeSymbol(ssubject.symbolAt(j2--)) + align[1];
                                continue;
                            }
                            if (this.CostMatrix[i2][j2] == E[i2][j2] || gap_extend[0]) {
                                gap_extend[0] = E[i2][j2] != this.CostMatrix[i2][j2 - 1] + this.insert + this.gapExt;
                                align[0] = '-' + align[0];
                                align[1] = st.tokenizeSymbol(ssubject.symbolAt(j2--)) + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            gap_extend[1] = F[i2][j2] != this.CostMatrix[i2 - 1][j2] + this.delete + this.gapExt;
                            align[0] = st.tokenizeSymbol(squery.symbolAt(i2--)) + align[0];
                            align[1] = '-' + align[1];
                            path = ' ' + path;
                        } while (j2 > 0);
                    }
                }
                catch (BioException exc) {
                    throw new BioRuntimeException(exc);
                }
            }
            for (i = 1; i <= squery.length(); ++i) {
                this.CostMatrix[i][0] = this.CostMatrix[i - 1][0] + this.delete;
            }
            for (j = 1; j <= ssubject.length(); ++j) {
                this.CostMatrix[0][j] = this.CostMatrix[0][j - 1] + this.insert;
            }
            for (i = 1; i <= squery.length(); ++i) {
                for (j = 1; j <= ssubject.length(); ++j) {
                    this.CostMatrix[i][j] = NeedlemanWunsch.min(this.CostMatrix[i - 1][j] + this.delete, this.CostMatrix[i][j - 1] + this.insert, this.CostMatrix[i - 1][j - 1] - this.matchReplace(squery, ssubject, i, j));
                }
            }
            try {
                j = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                SymbolTokenization st = this.subMatrix.getAlphabet().getTokenization("default");
                i = this.CostMatrix.length - 1;
                while (i > 0) {
                    do {
                        if (i == 0) {
                            align[0] = '~' + align[0];
                            align[1] = st.tokenizeSymbol(ssubject.symbolAt(j--)) + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        if (j == 0) {
                            align[0] = st.tokenizeSymbol(squery.symbolAt(i--)) + align[0];
                            align[1] = '~' + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i - 1][j - 1] - this.matchReplace(squery, ssubject, i, j)) {
                            path = squery.symbolAt(i) == ssubject.symbolAt(j) ? '|' + path : ' ' + path;
                            align[0] = st.tokenizeSymbol(squery.symbolAt(i--)) + align[0];
                            align[1] = st.tokenizeSymbol(ssubject.symbolAt(j--)) + align[1];
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i][j - 1] + this.insert) {
                            align[0] = '-' + align[0];
                            align[1] = st.tokenizeSymbol(ssubject.symbolAt(j--)) + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        align[0] = st.tokenizeSymbol(squery.symbolAt(i--)) + align[0];
                        align[1] = '-' + align[1];
                        path = ' ' + path;
                    } while (j > 0);
                }
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
            try {
                squery = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(squery.getAlphabet().getTokenization("token"), align[0]), squery.getURN(), squery.getName(), squery.getAnnotation()));
                ssubject = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(ssubject.getAlphabet().getTokenization("token"), align[1]), ssubject.getURN(), ssubject.getName(), ssubject.getAnnotation()));
                HashMap<String, Sequence> m = new HashMap<String, Sequence>();
                m.put(squery.getName(), squery);
                m.put(ssubject.getName(), ssubject);
                this.pairalign = new SimpleAlignment(m);
                this.alignment = NeedlemanWunsch.formatOutput(squery.getName(), ssubject.getName(), align, path, 0, this.CostMatrix.length - 1, this.CostMatrix.length - 1, 0, this.CostMatrix[0].length - 1, this.CostMatrix[0].length - 1, this.getEditDistance(), System.currentTimeMillis() - time) + System.getProperty("line.separator");
                return this.getEditDistance();
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
        }
        throw new BioRuntimeException("Alphabet missmatch occured: sequences with different alphabet cannot be aligned.");
    }

    private int matchReplace(Sequence query, Sequence subject, int i, int j) {
        try {
            return this.subMatrix.getValueAt(query.symbolAt(i), subject.symbolAt(j));
        }
        catch (Exception exc) {
            if (query.symbolAt(i).getMatches().contains(subject.symbolAt(j)) || subject.symbolAt(j).getMatches().contains(query.symbolAt(i))) {
                return -this.match;
            }
            return -this.replace;
        }
    }
}

