/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DASComponentFeature;
import org.biojava.bio.program.das.DASFeatureSet;
import org.biojava.bio.program.das.DASRawSymbolList;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.DASSequenceI;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.LazyFeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.impl.AssembledSymbolList;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheReference;
import org.xml.sax.XMLReader;

public class DASSequence
extends AbstractChangeable
implements DASSequenceI {
    public static final ChangeType ANNOTATIONS = new ChangeType("Annotation sets have been added or removed from the DAS sequence", "org.biojava.bio.program.das.DASSequence", "ANNOTATIONS", Feature.FEATURES);
    public static final String PROPERTY_ANNOTATIONSERVER = "org.biojava.bio.program.das.annotation_server";
    public static final String PROPERTY_FEATUREID = "org.biojava.bio.program.das.feature_id";
    public static final String PROPERTY_FEATURELABEL = "org.biojava.bio.program.das.feature_label";
    public static final String PROPERTY_LINKS = "org.biojava.bio.program.das.links";
    public static final String PROPERTY_SEQUENCEVERSION = "org.biojava.bio.program.das.sequence_version";
    public static final int SIZE_THRESHOLD = 500000;
    private static final int SYMBOL_TILE_THRESHOLD = 100000;
    private static final int SYMBOL_TILE_SIZE = 20000;
    protected transient ChangeForwarder annotationForwarder;
    private DASSequenceDB parentdb;
    private URL dataSourceURL;
    private String seqID;
    private String version = null;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    private FeatureRequestManager.Ticket structureTicket;
    private CacheReference refSymbols;
    private int length = -1;
    private Map featureSets = new HashMap();
    private FeatureHolder structure;
    private MergeFeatureHolder features = new MergeFeatureHolder();

    DASSequence(DASSequenceDB db, URL dataSourceURL, String seqID, Set dataSources) throws BioException, IllegalIDException {
        this.parentdb = db;
        this.dataSourceURL = dataSourceURL;
        this.seqID = seqID;
        SkeletonListener listener = new SkeletonListener();
        FeatureRequestManager frm = this.getParentDB().getFeatureRequestManager();
        this.structureTicket = frm.requestFeatures(this.getDataSourceURL(), seqID, listener, null, "component");
        try {
            this.features.addFeatureHolder(new StructureWrapper());
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve);
        }
        for (URL annoURL : dataSources) {
            DASFeatureSet newFeatureSet = new DASFeatureSet(this, annoURL, seqID);
            this.featureSets.put(annoURL, newFeatureSet);
            try {
                this.features.addFeatureHolder(newFeatureSet);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve);
            }
        }
    }

    URL getDataSourceURL() {
        return this.dataSourceURL;
    }

    public DASSequenceDB getParentDB() {
        return this.parentdb;
    }

    FeatureHolder getStructure() throws BioException {
        if (!this.structureTicket.isFetched()) {
            this.structureTicket.doFetch();
        }
        return this.structure;
    }

    private void _addAnnotationSource(URL dataSourceURL) throws BioException, ChangeVetoException {
        FeatureHolder structure = this.getStructure();
        Iterator<Feature> i = structure.features();
        while (i.hasNext()) {
            DASComponentFeature dcf = (DASComponentFeature)i.next();
            DASSequence seq = dcf.getSequenceLazy();
            if (seq == null) continue;
            seq.addAnnotationSource(dataSourceURL);
        }
        DASFeatureSet fs = new DASFeatureSet(this, dataSourceURL, this.seqID);
        this.featureSets.put(dataSourceURL, fs);
        this.features.addFeatureHolder(fs);
    }

    public Set dataSourceURLs() {
        return Collections.unmodifiableSet(this.featureSets.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationSource(URL dataSourceURL) throws BioException, ChangeVetoException {
        if (!this.featureSets.containsKey(dataSourceURL)) {
            if (!this.hasListeners()) {
                this._addAnnotationSource(dataSourceURL);
            } else {
                ChangeSupport changeSupport;
                ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(ANNOTATIONS);
                synchronized (changeSupport2) {
                    ChangeEvent ce = new ChangeEvent(this, ANNOTATIONS, null, null);
                    changeSupport.firePreChangeEvent(ce);
                    this._addAnnotationSource(dataSourceURL);
                    changeSupport.firePostChangeEvent(ce);
                }
            }
        }
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct == null || ct == Annotatable.ANNOTATION)) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }

    private void _removeAnnotationSource(URL dataSourceURL) throws ChangeVetoException, BioException {
        FeatureHolder structure = this.getStructure();
        FeatureHolder fh = (FeatureHolder)this.featureSets.get(dataSourceURL);
        if (fh != null) {
            Iterator<Feature> i = structure.features();
            while (i.hasNext()) {
                DASComponentFeature dcf = (DASComponentFeature)i.next();
                DASSequence seq = dcf.getSequenceLazy();
                if (seq == null) continue;
                seq.removeAnnotationSource(dataSourceURL);
            }
            this.features.removeFeatureHolder(fh);
            this.featureSets.remove(dataSourceURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationSource(URL dataSourceURL) throws ChangeVetoException, BioException {
        if (this.featureSets.containsKey(dataSourceURL)) {
            if (!this.hasListeners()) {
                this._removeAnnotationSource(dataSourceURL);
            } else {
                ChangeSupport changeSupport;
                ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(ANNOTATIONS);
                synchronized (changeSupport2) {
                    ChangeEvent ce = new ChangeEvent(this, ANNOTATIONS, null, null);
                    changeSupport.firePreChangeEvent(ce);
                    this._removeAnnotationSource(dataSourceURL);
                    changeSupport.firePostChangeEvent(ce);
                }
            }
        }
    }

    private int registerLocalFeatureFetchers(Object regKey) {
        for (DASFeatureSet dfs : this.featureSets.values()) {
            dfs.registerFeatureFetcher(regKey);
        }
        return this.featureSets.size();
    }

    private int registerLocalFeatureFetchers(Location l, Object regKey) {
        for (DASFeatureSet dfs : this.featureSets.values()) {
            dfs.registerFeatureFetcher(l, regKey);
        }
        return this.featureSets.size();
    }

    int registerFeatureFetchers(Object regKey) throws BioException {
        for (DASFeatureSet dfs : this.featureSets.values()) {
            dfs.registerFeatureFetcher(regKey);
        }
        int num = this.featureSets.size();
        FeatureHolder structure = this.getStructure();
        if (this.length() < 500000 && structure.countFeatures() > 0) {
            ArrayList<DASSequence> sequences = new ArrayList<DASSequence>();
            Iterator<Feature> fi = structure.features();
            while (fi.hasNext()) {
                ComponentFeature cf = (ComponentFeature)fi.next();
                DASSequence cseq = (DASSequence)cf.getComponentSequence();
                sequences.add(cseq);
            }
            for (DASSequence cseq : sequences) {
                num += cseq.registerFeatureFetchers(regKey);
            }
        }
        return num;
    }

    int registerFeatureFetchers(Location l, Object regKey) throws BioException {
        for (DASFeatureSet dfs : this.featureSets.values()) {
            dfs.registerFeatureFetcher(l, regKey);
        }
        int num = this.featureSets.size();
        FeatureHolder structure = this.getStructure();
        if (structure.countFeatures() > 0) {
            Location partNeeded;
            DASSequence cseq;
            FeatureHolder componentsBelow = structure.filter(new FeatureFilter.OverlapsLocation(l), false);
            HashMap<DASSequence, Location> sequencesToRegions = new HashMap<DASSequence, Location>();
            Iterator<Feature> fi = componentsBelow.features();
            while (fi.hasNext()) {
                ComponentFeature cf = (ComponentFeature)fi.next();
                cseq = (DASSequence)cf.getComponentSequence();
                if (l.contains(cf.getLocation())) {
                    sequencesToRegions.put(cseq, null);
                    continue;
                }
                partNeeded = l.intersection(cf.getLocation());
                if (cf.getStrand() == StrandedFeature.POSITIVE) {
                    partNeeded = partNeeded.translate(cf.getComponentLocation().getMin() - cf.getLocation().getMin());
                    sequencesToRegions.put(cseq, partNeeded);
                    continue;
                }
                sequencesToRegions.put(cseq, null);
            }
            for (Map.Entry srme : sequencesToRegions.entrySet()) {
                cseq = (DASSequence)srme.getKey();
                partNeeded = (Location)srme.getValue();
                if (partNeeded != null) {
                    num += cseq.registerFeatureFetchers(partNeeded, regKey);
                    continue;
                }
                num += cseq.registerFeatureFetchers(regKey);
            }
        }
        return num;
    }

    public Alphabet getAlphabet() {
        try {
            return this.getSymbols().getAlphabet();
        }
        catch (BioException be) {
            throw new BioRuntimeException(be);
        }
    }

    public Iterator iterator() {
        try {
            return this.getSymbols().iterator();
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't iterate over symbols", be);
        }
    }

    public int length() {
        try {
            if (this.length < 0 && !this.structureTicket.isFetched()) {
                this.structureTicket.doFetch();
            }
            if (this.length < 0) {
                throw new BioError("Assertion Failure: structure fetch didn't get length");
            }
            return this.length;
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't calculate length", be);
        }
    }

    public String seqString() {
        try {
            return this.getSymbols().seqString();
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't create seqString", be);
        }
    }

    public String subStr(int start, int end) {
        try {
            return this.getSymbols().subStr(start, end);
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't create substring", be);
        }
    }

    public SymbolList subList(int start, int end) {
        try {
            return this.getSymbols().subList(start, end);
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't create subList", be);
        }
    }

    public Symbol symbolAt(int pos) {
        try {
            return this.getSymbols().symbolAt(pos);
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't fetch symbol", be);
        }
    }

    public List toList() {
        try {
            return this.getSymbols().toList();
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't create list", be);
        }
    }

    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("/You/ try implementing read-write DAS");
    }

    protected SymbolList getSymbols() throws BioException {
        SymbolList sl = null;
        if (this.refSymbols != null) {
            sl = (SymbolList)this.refSymbols.get();
        }
        if (sl == null) {
            FeatureHolder structure = this.getStructure();
            if (structure.countFeatures() == 0) {
                if (this.length() > 100000) {
                    AssembledSymbolList asl = new AssembledSymbolList();
                    int tileStart = 1;
                    while (tileStart <= this.length()) {
                        int tileEnd = Math.min(tileStart + 20000 - 1, this.length());
                        if (this.length() - tileEnd < 1000) {
                            tileEnd = this.length();
                        }
                        RangeLocation l = new RangeLocation(tileStart, tileEnd);
                        DASRawSymbolList symbols = new DASRawSymbolList(this, new Segment(this.getName(), tileStart, tileEnd));
                        asl.putComponent(l, symbols);
                        tileStart = tileEnd + 1;
                    }
                    sl = asl;
                } else {
                    sl = new DASRawSymbolList(this, new Segment(this.getName()));
                }
            } else {
                Location coverage = Location.empty;
                AssembledSymbolList asl = new AssembledSymbolList();
                asl.setLength(this.length);
                Iterator<Feature> i = structure.features();
                while (i.hasNext()) {
                    ComponentFeature cf = (ComponentFeature)i.next();
                    Location loc = cf.getLocation();
                    if (LocationTools.overlaps(loc, coverage)) continue;
                    asl.putComponent(cf);
                    coverage = LocationTools.union(coverage, loc);
                }
                sl = asl;
            }
            this.refSymbols = this.parentdb.getSymbolsCache().makeReference(sl);
        }
        return sl;
    }

    public String getName() {
        return this.seqID;
    }

    public String getURN() {
        try {
            return new URL(this.getDataSourceURL(), "?ref=" + this.seqID).toString();
        }
        catch (MalformedURLException ex) {
            throw new BioRuntimeException(ex);
        }
    }

    public Iterator features() {
        try {
            this.registerFeatureFetchers(null);
            return this.features.features();
        }
        catch (BioException be) {
            throw new BioRuntimeException("Couldn't create features iterator", be);
        }
    }

    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.filter(ff, !FilterUtils.areProperSubset(ff, FeatureFilter.top_level));
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        try {
            FeatureHolder structure = this.getStructure();
            FeatureFilter.ByClass structureMembershipFilter = new FeatureFilter.ByClass(ComponentFeature.class);
            if (FilterUtils.areProperSubset(ff, structureMembershipFilter)) {
                if (recurse) {
                    Iterator<Feature> fi = structure.features();
                    while (fi.hasNext()) {
                    }
                }
                return structure.filter(ff, recurse);
            }
            Location ffl = FilterUtils.extractOverlappingLocation(ff);
            if (recurse) {
                int numComponents = 1;
                numComponents = ffl != null ? this.registerFeatureFetchers(ffl, ff) : this.registerFeatureFetchers(ff);
                this.getParentDB().ensureFeaturesCacheCapacity(numComponents * 3);
            } else if (ffl != null) {
                this.registerLocalFeatureFetchers(ffl, ff);
            } else {
                this.registerLocalFeatureFetchers(ff);
            }
            return this.features.filter(ff, recurse);
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't filter", be);
        }
    }

    public FeatureFilter getSchema() {
        return this.features.getSchema();
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    public Feature realizeFeature(FeatureHolder dest, Feature.Template temp) throws BioException {
        if (temp.location.getMin() < 1 || temp.location.getMax() > this.length()) {
            temp.location = LocationTools.intersection(temp.location, new RangeLocation(1, this.length()));
        }
        return this.featureRealizer.realizeFeature(this, dest, temp);
    }

    public Annotation getAnnotation() {
        try {
            SmallAnnotation anno = new SmallAnnotation();
            anno.setProperty(PROPERTY_SEQUENCEVERSION, this.version);
            return anno;
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Expected to be able to modify annotation");
        }
    }

    static DocumentBuilder nonvalidatingParser() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            return dbf.newDocumentBuilder();
        }
        catch (Exception ex) {
            throw new BioError(ex);
        }
    }

    static XMLReader nonvalidatingSAXParser() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            return spf.newSAXParser().getXMLReader();
        }
        catch (Exception ex) {
            throw new BioError(ex);
        }
    }

    private class SkeletonListener
    extends SeqIOAdapter {
        private SimpleFeatureHolder structureF;

        private SkeletonListener() {
        }

        public void startSequence() {
            this.structureF = new SimpleFeatureHolder();
        }

        public void endSequence() {
            DASSequence.this.structure = this.structureF;
        }

        public void addSequenceProperty(Object key, Object value) throws ParseException {
            try {
                if (key.equals("sequence.start")) {
                    int start = Integer.parseInt(value.toString());
                    if (start != 1) {
                        throw new ParseException("Server doesn't think sequence starts at 1.  Wierd.");
                    }
                } else if (key.equals("sequence.stop")) {
                    DASSequence.this.length = Integer.parseInt(value.toString());
                } else if (key.equals("sequence.version")) {
                    DASSequence.this.version = value.toString();
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException(ex, "Expect numbers for segment start and stop");
            }
        }

        public void startFeature(Feature.Template temp) throws ParseException {
            if (temp instanceof ComponentFeature.Template) {
                try {
                    ComponentFeature.Template ctemp = (ComponentFeature.Template)temp;
                    DASComponentFeature cf = new DASComponentFeature(DASSequence.this, ctemp);
                    this.structureF.addFeature(cf);
                    DASSequence.this.length = Math.max(DASSequence.this.length, ctemp.location.getMax());
                }
                catch (BioException ex) {
                    throw new ParseException(ex, "Error instantiating DASComponent");
                }
                catch (ChangeVetoException ex) {
                    throw new BioError("Immutable FeatureHolder when trying to build structure", ex);
                }
            }
        }
    }

    private class StructureWrapper
    extends LazyFeatureHolder {
        public StructureWrapper() {
            super(new FeatureFilter.And(FeatureFilter.top_level, new FeatureFilter.ByClass(ComponentFeature.class)));
        }

        protected FeatureHolder createFeatureHolder() {
            try {
                return DASSequence.this.getStructure();
            }
            catch (BioException ex) {
                throw new BioRuntimeException("Error fetching structure", ex);
            }
        }
    }
}

