/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.GCGBlastSummaryLineHelper;
import org.biojava.bio.program.sax.HitSectionSAXParser;
import org.biojava.bio.program.sax.HmmerSummaryLineHelper;
import org.biojava.bio.program.sax.NcbiBlastSummaryLineHelper;
import org.biojava.bio.program.sax.QName;
import org.biojava.bio.program.sax.SummaryLineHelperIF;
import org.biojava.bio.program.sax.WuBlastSummaryLineHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class BlastSAXParser
extends AbstractNativeAppSAXParser {
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private ArrayList oBuffer = new ArrayList();
    private char[] aoChars;
    private char[] aoLineSeparator;
    private String[] aoKeys;
    private String[] aoArrayType = new String[1];
    private HashMap oMap = new HashMap();
    private int iVer;
    private BlastLikeVersionSupport oVersion;
    private HitSectionSAXParser oHits;
    private SummaryLineHelperIF oSummaryLineHelper;
    private String oQueryId;
    private String oDatabaseId;
    private String oQueryLength;
    private static final int STARTUP = 0;
    private static final int IN_TRAILER = 1;
    private static final int AT_END = 2;
    private static final int IN_HEADER = 3;
    private static final int IN_SUMMARY = 4;
    private static final int FINISHED_HITS = 5;
    private boolean tDoneSummary = false;

    BlastSAXParser(BlastLikeVersionSupport poVersion, String poNamespacePrefix) throws SAXException {
        this.oVersion = poVersion;
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
        this.oHits = new HitSectionSAXParser(this.oVersion, this.getNamespacePrefix());
        this.changeState(0);
        this.aoLineSeparator = System.getProperty("line.separator").toCharArray();
        this.choosePartImplementations();
    }

    public String parse(BufferedReader poContents, String poLine) throws SAXException {
        this.oHits = new HitSectionSAXParser(this.oVersion, this.getNamespacePrefix());
        String oLine = null;
        this.oQueryId = "";
        this.oDatabaseId = "";
        this.oContents = poContents;
        if (!this.oVersion.isStartOfDataSet(poLine)) {
            throw new SAXException("unexpected poLine parameter, expecting start of BLAST like record");
        }
        this.onNewBlastDataSet(poLine);
        try {
            oLine = this.oContents.readLine();
            while (oLine != null && !this.checkNewBlastLikeDataSet(oLine)) {
                this.interpret(oLine);
                oLine = this.oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interrupted");
        }
        if (this.iState == 1) {
            this.emitRawOutput(this.oBuffer);
            this.endElement(new QName(this, this.prefix("Trailer")));
            this.changeState(2);
        }
        this.endElement(new QName(this, this.prefix("BlastLikeDataSet")));
        return oLine;
    }

    private void interpret(String poLine) throws SAXException {
        if (this.iState == 3) {
            StringTokenizer st;
            if (poLine.startsWith("Query=")) {
                st = new StringTokenizer(poLine);
                st.nextToken();
                if (st.hasMoreTokens()) {
                    this.oQueryId = st.nextToken();
                }
            }
            if (poLine.matches("^\\s+\\(\\d+\\sletters\\)\\s*$")) {
                st = new StringTokenizer(poLine);
                this.oQueryLength = st.nextToken().substring(1);
            }
            if (poLine.startsWith("Database:")) {
                int i = poLine.indexOf(":");
                this.oDatabaseId = poLine.substring(i + 1);
                block4: while (true) {
                    try {
                        while (!(poLine = this.oContents.readLine()).startsWith("Searching")) {
                            if (poLine.startsWith("Results of")) {
                                System.err.println("this looks like a PSI-blast file, this is currently not supported, yet!");
                                break block4;
                            }
                            this.oDatabaseId = this.oDatabaseId.concat(poLine);
                        }
                    }
                    catch (IOException x) {
                        System.err.println(x.getMessage());
                        System.err.println("File read interrupted");
                        continue;
                    }
                    break;
                }
            }
            if (poLine.startsWith("Sequences producing significant alignments") || poLine.startsWith("Sequences producing High-scoring Segment Pairs") || poLine.startsWith(" ***** No hits found ******") || poLine.startsWith("-------- ")) {
                this.emitRawOutput(this.oBuffer);
                this.emitHeaderIds();
                this.oAtts.clear();
                this.endElement(new QName(this, this.prefix("Header")));
                if (poLine.startsWith(" ***** No hits found ******")) {
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Trailer")), this.oAtts);
                    this.changeState(1);
                    this.oBuffer.clear();
                    return;
                }
                this.changeState(4);
                this.oAtts.clear();
                this.startElement(new QName(this, this.prefix("Summary")), this.oAtts);
                try {
                    poLine = this.oContents.readLine();
                }
                catch (IOException x) {
                    System.err.println(x.getMessage());
                    System.err.println("File read interrupted");
                }
                if (!poLine.trim().equals("")) {
                    this.interpret(poLine);
                }
                return;
            }
            this.oBuffer.add(poLine);
        }
        if (this.iState == 4) {
            int iProgram = this.oVersion.getProgram();
            if (iProgram == 21) {
                if (poLine.trim().equals("")) {
                    return;
                }
                if (poLine.startsWith("Parsed for domains:")) {
                    return;
                }
            } else if (poLine.trim().equals("") || poLine.trim().startsWith("[no more scores") || poLine.trim().startsWith("\\")) {
                if (!this.tDoneSummary) {
                    this.tDoneSummary = true;
                    this.endElement(new QName(this, this.prefix("Summary")));
                }
                return;
            }
            if (poLine.startsWith(">")) {
                this.hitsSectionReached(poLine);
                return;
            }
            if (!this.tDoneSummary) {
                this.parseSummaryLine(poLine);
            }
            return;
        }
        if (this.iState == 5) {
            this.endElement(new QName(this, this.prefix("Detail")));
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("Trailer")), this.oAtts);
            this.changeState(1);
            this.oBuffer.clear();
            return;
        }
        if (this.iState == 1) {
            this.oBuffer.add(poLine);
        }
    }

    private void onNewBlastDataSet(String poLine) throws SAXException {
        if (!this.oVersion.isSupported()) {
            throw new SAXException("Program " + this.oVersion.getProgramString() + " Version " + this.oVersion.getVersionString() + " is not supported by the biojava blast-like parsing framework");
        }
        this.oAtts.clear();
        this.oAttQName.setQName("program");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getProgramString());
        this.oAttQName.setQName("version");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getVersionString());
        this.startElement(new QName(this, this.prefix("BlastLikeDataSet")), this.oAtts);
        this.iState = 3;
        this.oBuffer.clear();
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("Header")), this.oAtts);
    }

    private void emitRawOutput(ArrayList poList) throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("xml:space");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
        this.startElement(new QName(this, this.prefix("RawOutput")), this.oAtts);
        int iTmpListSize = poList.size();
        for (int i = 0; i < iTmpListSize; ++i) {
            this.aoChars = ((String)poList.get(i)).toCharArray();
            this.characters(this.aoLineSeparator, 0, 1);
            this.characters(this.aoChars, 0, this.aoChars.length);
        }
        this.endElement(new QName(this, this.prefix("RawOutput")));
    }

    private void parseSummaryLine(String poLine) throws SAXException {
        int i;
        this.oSummaryLineHelper.parse(poLine, this.oMap, this.oVersion);
        if (this.iVer == 32) {
            try {
                poLine = this.oContents.readLine();
                this.oSummaryLineHelper.parse(poLine, this.oMap, this.oVersion);
            }
            catch (IOException x) {
                System.out.println(x.getMessage());
                System.out.println("GCG File read interrupted");
            }
        }
        if (this.oMap.size() == 0) {
            return;
        }
        this.aoKeys = this.oMap.keySet().toArray(this.aoArrayType);
        this.oAtts.clear();
        for (i = 0; i < this.aoKeys.length; ++i) {
            if (this.aoKeys[i].equals("hitId") || this.aoKeys[i].equals("hitDescription")) continue;
            this.oAttQName.setQName(this.aoKeys[i]);
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[i]));
        }
        this.startElement(new QName(this, this.prefix("HitSummary")), this.oAtts);
        for (i = 0; i < this.aoKeys.length; ++i) {
            if (this.aoKeys[i].equals("hitId")) {
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[i]));
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("HitId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("HitId")));
                continue;
            }
            if (!this.aoKeys[i].equals("hitDescription")) continue;
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("HitDescription")), this.oAtts);
            this.aoChars = ((String)this.oMap.get(this.aoKeys[i])).toCharArray();
            this.characters(this.aoChars, 0, this.aoChars.length);
            this.endElement(new QName(this, this.prefix("HitDescription")));
        }
        this.endElement(new QName(this, this.prefix("HitSummary")));
        this.oMap.clear();
    }

    private void emitHeaderIds() throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("id");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oQueryId);
        this.oAttQName.setQName("metaData");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
        this.oAttQName.setQName("queryLength");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oQueryLength);
        this.startElement(new QName(this, this.prefix("QueryId")), this.oAtts);
        this.endElement(new QName(this, this.prefix("QueryId")));
        this.oAtts.clear();
        this.oAttQName.setQName("id");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oDatabaseId);
        this.oAttQName.setQName("metaData");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
        this.startElement(new QName(this, this.prefix("DatabaseId")), this.oAtts);
        this.endElement(new QName(this, this.prefix("DatabaseId")));
    }

    private void hitsSectionReached(String poLine) throws SAXException {
        ArrayList<String> hitEndSymbols;
        this.oHits.setContentHandler(this.oHandler);
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("Detail")), this.oAtts);
        int iProgram = this.oVersion.getProgram();
        if (iProgram == 1 || iProgram == 3 || iProgram == 2 || iProgram == 4 || iProgram == 5) {
            hitEndSymbols = new ArrayList<String>();
            hitEndSymbols.add("Database");
            hitEndSymbols.add("TBLAST");
            hitEndSymbols.add("BLAST");
            this.oHits.parse(this.oContents, poLine, hitEndSymbols);
        }
        if (iProgram == 11 || iProgram == 13 || iProgram == 12 || iProgram == 14 || iProgram == 15) {
            hitEndSymbols = new ArrayList();
            hitEndSymbols.add("Parameters:");
            this.oHits.parse(this.oContents, poLine, hitEndSymbols);
        }
        if (iProgram == 32) {
            hitEndSymbols = new ArrayList();
            hitEndSymbols.add("Database:");
            this.oHits.parse(this.oContents, poLine, hitEndSymbols);
        }
        this.changeState(5);
    }

    private boolean checkNewBlastLikeDataSet(String poLine) {
        return poLine.startsWith("BLAST") || poLine.startsWith("TBLAST");
    }

    private void choosePartImplementations() throws SAXException {
        this.iVer = this.oVersion.getProgram();
        if (this.iVer == 1 || this.iVer == 3 || this.iVer == 2 || this.iVer == 4 || this.iVer == 5) {
            this.oSummaryLineHelper = new NcbiBlastSummaryLineHelper();
            return;
        }
        if (this.iVer == 11 || this.iVer == 13 || this.iVer == 12 || this.iVer == 14 || this.iVer == 15) {
            this.oSummaryLineHelper = new WuBlastSummaryLineHelper();
            return;
        }
        if (this.iVer == 21) {
            this.oSummaryLineHelper = new HmmerSummaryLineHelper();
            return;
        }
        if (this.iVer == 32) {
            this.oSummaryLineHelper = new GCGBlastSummaryLineHelper();
            return;
        }
        throw new SAXException("Could not choose a suitable implementation of the ".concat("SummaryLineHelperIF for program ").concat(this.oVersion.getProgramString()).concat(" version ").concat(this.oVersion.getVersionString()));
    }
}

