/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.db.biosql.DBHelper;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.OntologyTerm;
import org.biojava.ontology.RemoteTerm;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class OntologySQL {
    private static HashMap ONTOLOGIES = new HashMap();
    private DataSource source;
    private DBHelper dbHelper;
    private Map ontologiesByID = new HashMap();
    private Map ontologiesByName = new HashMap();
    private Map termsByID = new HashMap();
    private Map IDsByTerm = new HashMap();
    private Map monitors = new HashMap();
    private Map blessedExternalAliases = new HashMap();
    private Map blessedExternalTerms = new HashMap();
    private Ontology guano;

    static synchronized OntologySQL getOntologySQL(DataSource source, DBHelper dbHelper) throws BioException, SQLException {
        OntologySQL ontologySQL = (OntologySQL)ONTOLOGIES.get(source);
        if (ontologySQL == null) {
            ontologySQL = new OntologySQL(source, dbHelper);
            ONTOLOGIES.put(source, ontologySQL);
        }
        return ontologySQL;
    }

    static synchronized void clearCache() {
        ONTOLOGIES.clear();
    }

    Ontology getLegacyOntology() {
        return this.guano;
    }

    public Ontology getOntology(String name) throws BioException {
        Object ont = this.ontologiesByName.get(name);
        if (ont == null) {
            throw new NoSuchElementException("Can't find ontology named " + name);
        }
        if (ont instanceof OntologyPlaceholder) {
            OntologyPlaceholder op = (OntologyPlaceholder)ont;
            Ontology onto = this.loadOntology(op.name, op.description, op.id);
            OntologyMonitor om = new OntologyMonitor(onto);
            this.monitors.put(onto, om);
            onto.addChangeListener(om, ChangeType.UNKNOWN);
            return onto;
        }
        return (Ontology)ont;
    }

    public Ontology createOntology(String name, String description) throws AlreadyExistsException, BioException {
        if (this.ontologiesByName.containsKey(name)) {
            throw new AlreadyExistsException("This BioSQL database already contains an ontology of name " + name);
        }
        Ontology.Impl ont = new Ontology.Impl(name, description);
        this.persistOntology(ont);
        OntologyMonitor om = new OntologyMonitor(ont);
        this.monitors.put(ont, om);
        ont.addChangeListener(om, ChangeType.UNKNOWN);
        return ont;
    }

    public Ontology addOntology(Ontology old) throws AlreadyExistsException {
        if (this.ontologiesByName.containsKey(old.getName())) {
            throw new AlreadyExistsException("This BioSQL database already contains an ontology of name " + old.getName());
        }
        Connection conn = null;
        try {
            conn = this.source.getConnection();
            conn.setAutoCommit(false);
            Ontology.Impl ont = new Ontology.Impl(old.getName(), old.getDescription());
            this.persistOntology(conn, ont);
            HashMap<Term, Term> localTerms = new HashMap<Term, Term>();
            for (Term term : old.getTerms()) {
                Term localTerm;
                if (term instanceof RemoteTerm) {
                    localTerm = ont.importTerm(((RemoteTerm)term).getRemoteTerm(), null);
                } else {
                    localTerm = ont.createTerm(term.getName(), term.getDescription(), term.getSynonyms());
                    this.persistTerm(conn, localTerm);
                }
                localTerms.put(term, localTerm);
            }
            for (Triple triple : old.getTriples(null, null, null)) {
                Triple localT = ont.createTriple((Term)localTerms.get(triple.getSubject()), (Term)localTerms.get(triple.getObject()), (Term)localTerms.get(triple.getPredicate()), null, null);
                this.persistTriple(conn, ont, localT);
            }
            conn.commit();
            OntologyMonitor om = new OntologyMonitor(ont);
            this.monitors.put(ont, om);
            ont.addChangeListener(om, ChangeType.UNKNOWN);
            return ont;
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error removing from BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
        catch (AlreadyExistsException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioError("Unexpected ontology duplication error", ex);
        }
        catch (ChangeVetoException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioError("Unexpected veto altering internal Ontology object", ex);
        }
    }

    public void addCore(Connection conn) throws SQLException {
        System.err.println("*** Importing a core ontology -- hope this is okay");
        try {
            conn.setAutoCommit(false);
            Ontology old = OntoTools.getCoreOntology();
            Ontology.Impl ont = new Ontology.Impl("__core_ontology", "BioSQL core ontology (imported by BioJava)");
            this.persistOntology(conn, ont);
            HashMap localTerms = new HashMap();
            System.err.println("*** Importing terms");
            for (Term t : old.getTerms()) {
                this.processTerm(t, localTerms, ont, conn);
            }
            conn.commit();
            OntologyMonitor om = new OntologyMonitor(ont);
            this.monitors.put(ont, om);
            ont.addChangeListener(om, ChangeType.UNKNOWN);
            this.blessExternal(ont, old);
        }
        catch (AlreadyExistsException ex) {
            throw new BioError("Unexpected ontology duplication error", ex);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Unexpected veto altering internal Ontology object", ex);
        }
    }

    private void processTerm(Term t, Map localTerms, Ontology ont, Connection conn) throws AlreadyExistsException, ChangeVetoException, SQLException {
        Term localTerm;
        if (localTerms.keySet().contains(t)) {
            return;
        }
        if (t instanceof Triple) {
            Triple trip = (Triple)t;
            this.processTerm(trip.getSubject(), localTerms, ont, conn);
            this.processTerm(trip.getObject(), localTerms, ont, conn);
            this.processTerm(trip.getPredicate(), localTerms, ont, conn);
            localTerm = ont.createTriple((Term)localTerms.get(trip.getSubject()), (Term)localTerms.get(trip.getObject()), (Term)localTerms.get(trip.getPredicate()), null, null);
            this.persistTriple(conn, ont, (Triple)localTerm);
        } else if (t instanceof RemoteTerm) {
            localTerm = ont.importTerm(((RemoteTerm)t).getRemoteTerm(), null);
        } else {
            localTerm = ont.createTerm(t.getName(), t.getDescription(), t.getSynonyms());
            this.persistTerm(conn, localTerm);
        }
        localTerms.put(t, localTerm);
    }

    private void loadTerms(Ontology ont, int id) throws SQLException, OntologyException, ChangeVetoException {
        Connection conn = this.source.getConnection();
        String query = " SELECT term.term_id, term.name, term.definition,        term_relationship.term_relationship_id,        term_relationship.subject_term_id,        term_relationship.object_term_id,        term_relationship.predicate_term_id ";
        query = this.dbHelper.getJoinStyle() == DBHelper.JOIN_ORACLE8 ? query + "FROM term, term_relationship_term, term_relationship      WHERE term.term_id = term_relationship_term.term_id (+)      AND term_relationship_term.term_relationship_id = term_relationship.term_relationship_id (+) AND term.ontology_id = ? " : query + "FROM term LEFT OUTER JOIN term_relationship_term      ON term.term_id = term_relationship_term.term_id LEFT OUTER JOIN term_relationship      ON term_relationship_term.term_relationship_id = term_relationship.term_relationship_id WHERE term.ontology_id = ? ";
        query = query + "ORDER BY term.term_id";
        PreparedStatement get_terms = conn.prepareStatement(query);
        String query2 = "SELECT synonym FROM term_synonym WHERE term_id = ?";
        PreparedStatement get_synonyms = conn.prepareStatement(query2);
        get_terms.setInt(1, id);
        ResultSet rs = get_terms.executeQuery();
        while (rs.next()) {
            int term_id = rs.getInt(1);
            Integer tid = new Integer(term_id);
            String name = rs.getString(2);
            String description = rs.getString(3);
            if (description == null) {
                description = "";
            }
            int term_relation_id = rs.getInt(4);
            Term t = null;
            if (term_relation_id == 0) {
                t = ont.createTerm(name, description);
            } else {
                int subject_term_id = rs.getInt(5);
                int object_term_id = rs.getInt(6);
                int predicate_term_id = rs.getInt(7);
                t = ont.createTriple((Term)this.termsByID.get(new Integer(subject_term_id)), (Term)this.termsByID.get(new Integer(object_term_id)), (Term)this.termsByID.get(new Integer(predicate_term_id)), name, description);
            }
            get_synonyms.setInt(1, term_id);
            ResultSet rs2 = get_synonyms.executeQuery();
            while (rs2.next()) {
                t.addSynonym(rs2.getString(1));
            }
            rs2.close();
            this.termsByID.put(tid, t);
            this.IDsByTerm.put(t, tid);
        }
        rs.close();
        get_terms.close();
        get_synonyms.close();
        conn.close();
        conn = null;
        if (ont.getName().equals("__core_ontology")) {
            this.blessExternal(ont, OntoTools.getCoreOntology());
        }
    }

    public void blessExternal(Ontology internalOntology, Ontology externalOntology) {
        for (Term extTerm : externalOntology.getTerms()) {
            Term intTerm = internalOntology.getTerm(extTerm.getName());
            this.blessedExternalAliases.put(extTerm, intTerm);
            this.blessedExternalTerms.put(intTerm, extTerm);
        }
    }

    OntologySQL(DataSource source, DBHelper dbHelper) throws SQLException, BioException {
        this.source = source;
        this.dbHelper = dbHelper;
        Connection conn = source.getConnection();
        try {
            PreparedStatement get_onts = conn.prepareStatement("select ontology_id, name, definition   from ontology ");
            ResultSet rs = get_onts.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                OntologyPlaceholder op = new OntologyPlaceholder(name, description, id);
                this.ontologiesByID.put(new Integer(id), op);
                this.ontologiesByName.put(name, op);
            }
            rs.close();
            get_onts.close();
            if (!this.ontologiesByName.containsKey("__core_ontology")) {
                this.addCore(conn);
            }
            this.guano = this.ontologiesByName.containsKey("__biojava_guano") ? this.getOntology("__biojava_guano") : this.createOntology("__biojava_guano", "Namespace for old, but still useful, shit imported from ontology-less BioJava data models");
        }
        catch (AlreadyExistsException ex) {
            try {
                conn.close();
            }
            catch (SQLException ex3) {
                // empty catch block
            }
            throw new BioException("Duplicate term name in BioSQL", ex);
        }
        conn.close();
        conn = null;
    }

    private Ontology loadOntology(String name, String description, int id) throws BioException {
        Ontology.Impl ont = new Ontology.Impl(name, description);
        try {
            this.loadTerms(ont, id);
        }
        catch (SQLException ex) {
            throw new BioException("Error loading ontology terms", ex);
        }
        catch (OntologyException ex) {
            throw new BioException("Error loading ontology terms", ex);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Assertion failed: couldn't modify Ontology", ex);
        }
        this.ontologiesByID.put(new Integer(id), ont);
        this.ontologiesByName.put(name, ont);
        return ont;
    }

    private void persistTerm(Term term) {
        Connection conn = null;
        try {
            conn = this.source.getConnection();
            conn.setAutoCommit(false);
            this.persistTerm(conn, term);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error commiting to BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    private void persistTerm(Connection conn, Term term) throws SQLException {
        try {
            PreparedStatement import_term = conn.prepareStatement("insert into term        (name, definition, ontology_id) values (?, ?, ?)");
            import_term.setString(1, term.getName());
            import_term.setString(2, term.getDescription());
            import_term.setInt(3, this.ontologyID(term.getOntology()));
            import_term.executeUpdate();
            import_term.close();
            int id = this.dbHelper.getInsertID(conn, "term", "term_id");
            Integer tid = new Integer(id);
            this.termsByID.put(tid, term);
            this.IDsByTerm.put(term, tid);
            PreparedStatement stored_synonym = conn.prepareStatement("insert into term_synonym (term_id, name) values (?,?) ");
            Object[] synonyms = term.getSynonyms();
            for (int i = 0; i < synonyms.length; ++i) {
                stored_synonym.setInt(1, id);
                stored_synonym.setString(2, "" + synonyms[i]);
                stored_synonym.executeUpdate();
            }
            stored_synonym.close();
        }
        catch (SQLException se) {
            throw (SQLException)new SQLException("Failed to persist term: " + term + " from ontology: " + term.getOntology() + " with error: " + se.getErrorCode() + " : " + se.getSQLState()).initCause(se);
        }
    }

    private void persistTriple(Ontology ont, Triple triple) {
        Connection conn = null;
        try {
            conn = this.source.getConnection();
            conn.setAutoCommit(false);
            this.persistTriple(conn, ont, triple);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding to BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    private void persistTriple(Connection conn, Ontology ont, Triple triple) throws SQLException {
        try {
            Term t = triple;
            while (t instanceof RemoteTerm) {
                t = ((RemoteTerm)t).getRemoteTerm();
            }
            if (this.blessedExternalAliases.containsKey(t)) {
                t = (Term)this.blessedExternalAliases.get(t);
            }
            if (!this.IDsByTerm.containsKey(t)) {
                this.persistTerm(conn, triple);
            }
            PreparedStatement import_trip = conn.prepareStatement("insert into term_relationship  (subject_term_id, predicate_term_id,object_term_id, ontology_id) values (?, ?, ?, ?)");
            import_trip.setInt(1, this.termID(triple.getSubject()));
            import_trip.setInt(2, this.termID(triple.getPredicate()));
            import_trip.setInt(3, this.termID(triple.getObject()));
            import_trip.setInt(4, this.ontologyID(ont));
            import_trip.executeUpdate();
            import_trip.close();
            int tripID = this.dbHelper.getInsertID(conn, "term_relationship", "term_relationship_id");
            PreparedStatement link_trip_to_term = conn.prepareStatement("insert into term_relationship_term  (term_relationship_id, term_id) values (?, ?)");
            link_trip_to_term.setInt(1, tripID);
            link_trip_to_term.setInt(2, this.termID(triple));
            link_trip_to_term.executeUpdate();
            link_trip_to_term.close();
        }
        catch (SQLException se) {
            throw (SQLException)new SQLException("Failed to persist triple: " + triple + " from ontology: " + triple.getOntology() + " with error: " + se.getErrorCode() + " : " + se.getSQLState()).initCause(se);
        }
    }

    private void persistOntology(Ontology onto) {
        Connection conn = null;
        try {
            conn = this.source.getConnection();
            conn.setAutoCommit(false);
            this.persistOntology(conn, onto);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding to BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    private void persistOntology(Connection conn, Ontology ont) throws SQLException {
        PreparedStatement insert_ontology = conn.prepareStatement("insert into ontology        (name, definition) values (?, ?)");
        insert_ontology.setString(1, ont.getName());
        insert_ontology.setString(2, ont.getDescription());
        insert_ontology.executeUpdate();
        insert_ontology.close();
        int id = this.dbHelper.getInsertID(conn, "ontology", "ontology_id");
        Integer tid = new Integer(id);
        this.ontologiesByID.put(tid, ont);
        this.ontologiesByName.put(ont.getName(), ont);
    }

    int ontologyID(Ontology ont) {
        for (Map.Entry me : this.ontologiesByID.entrySet()) {
            if (!me.getValue().equals(ont)) continue;
            return (Integer)me.getKey();
        }
        throw new BioError("Couldn't find ontology " + ont.getName());
    }

    int termID(Term t) {
        while (t instanceof RemoteTerm) {
            t = ((RemoteTerm)t).getRemoteTerm();
        }
        if (this.blessedExternalAliases.containsKey(t)) {
            t = (Term)this.blessedExternalAliases.get(t);
        }
        try {
            return (Integer)this.IDsByTerm.get(t);
        }
        catch (NullPointerException ex) {
            throw new BioError("Error looking up biosqlized ID for " + t.toString(), ex);
        }
    }

    Term termForID(int id) {
        Term t = (Term)this.termsByID.get(new Integer(id));
        if (t == null) {
            throw new BioError("Invalid term id " + id);
        }
        return t;
    }

    private class OntologyMonitor
    implements ChangeListener {
        private Ontology ontology;

        OntologyMonitor(Ontology o) {
            this.ontology = o;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ChangeType type = cev.getType();
            if (!type.isMatchingType(Ontology.TERM)) {
                if (!type.isMatchingType(Ontology.TRIPLE)) throw new ChangeVetoException("Biojava does not understand this change");
                return;
            }
            ChangeEvent chain = cev.getChainedEvent();
            if (chain != null) {
                throw new ChangeVetoException("Biojava does not handle mutable terms once persisted");
            }
            if (cev.getChange() != null && cev.getPrevious() == null) {
                if (!(cev.getChange() instanceof Term)) {
                    throw new ChangeVetoException("Can't understand this change");
                }
                Term addedTerm = (Term)cev.getChange();
                if (addedTerm instanceof OntologyTerm) {
                    throw new ChangeVetoException("BioSQL does (currently) represent OntologyTerms but Biojava wants to lie about that");
                }
                if (!(addedTerm instanceof RemoteTerm)) return;
                Term gopher = addedTerm;
                do {
                    if (!(gopher instanceof RemoteTerm)) return;
                    gopher = ((RemoteTerm)gopher).getRemoteTerm();
                } while (OntologySQL.this.ontologiesByID.values().contains(gopher.getOntology()) || OntologySQL.this.blessedExternalAliases.containsKey(gopher));
                throw new ChangeVetoException("BioSQL ontologies can't contain references to external ontologies");
            }
            if (cev.getChange() != null) throw new ChangeVetoException("Unknown TERM change");
            if (cev.getPrevious() == null) throw new ChangeVetoException("Unknown TERM change");
            throw new ChangeVetoException("FIXME: Biojava can't remove terms from biosql ontology");
        }

        public void postChange(ChangeEvent cev) {
            ChangeType type = cev.getType();
            if (type.isMatchingType(Ontology.TERM)) {
                if (cev.getChange() != null && cev.getPrevious() == null) {
                    if (!(cev.getChange() instanceof Term)) {
                        throw new BioError("Assertion failed: added object isn't a term: " + cev.getChange());
                    }
                    Term addedTerm = (Term)cev.getChange();
                    if (addedTerm instanceof RemoteTerm) {
                        // empty if block
                    }
                    OntologySQL.this.persistTerm(addedTerm);
                }
            } else if (type.isMatchingType(Ontology.TRIPLE) && cev.getChange() != null && cev.getPrevious() == null) {
                if (!(cev.getChange() instanceof Triple)) {
                    throw new BioError("Assertion failed: added object isn't a triple: " + cev.getChange());
                }
                OntologySQL.this.persistTriple(this.ontology, (Triple)cev.getChange());
            }
        }
    }

    private static class OntologyPlaceholder {
        final String name;
        final String description;
        final int id;

        public OntologyPlaceholder(String name, String description, int id) {
            this.name = name;
            this.description = description;
            this.id = id;
        }
    }
}

