/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class StructureTools {
    public static final String caAtomName = "CA";
    public static final String[] backboneAtomNames = new String[]{"N", "CA", "C", "O", "CB"};
    public static final Character UNKNOWN_GROUP_LABEL = new Character('x');
    private static Map<String, Integer> nucleotides30;
    private static Map<String, Integer> nucleotides23;
    private static SymbolTokenization threeLetter;
    private static SymbolTokenization oneLetter;
    public static Logger logger;

    public static int getNrAtoms(Structure s) {
        int nrAtoms = 0;
        GroupIterator iter = new GroupIterator(s);
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            nrAtoms += g.size();
        }
        return nrAtoms;
    }

    public static int getNrGroups(Structure s) {
        int nrGroups = 0;
        List<Chain> chains = s.getChains(0);
        for (Chain c : chains) {
            nrGroups += c.getAtomLength();
        }
        return nrGroups;
    }

    public static Atom[] getAtomArray(Structure s, String[] atomNames) {
        GroupIterator iter = new GroupIterator(s);
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
            boolean thisGroupAllAtoms = true;
            for (int i = 0; i < atomNames.length; ++i) {
                String atomName = atomNames[i];
                try {
                    Atom a = g.getAtom(atomName);
                    thisGroupAtoms.add(a);
                    continue;
                }
                catch (StructureException e) {
                    thisGroupAllAtoms = false;
                    break;
                }
            }
            if (!thisGroupAllAtoms) continue;
            for (Atom a : thisGroupAtoms) {
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static Atom[] getAtomCAArray(Structure s) {
        String[] atomNames = new String[]{caAtomName};
        return StructureTools.getAtomArray(s, atomNames);
    }

    public static Atom[] getBackboneAtomArray(Structure s) {
        String[] atomNames = backboneAtomNames;
        return StructureTools.getAtomArray(s, atomNames);
    }

    public static Character convert_3code_1code(String code3) throws IllegalSymbolException {
        Symbol sym = threeLetter.parseToken(code3);
        String code1 = oneLetter.tokenizeSymbol(sym);
        return new Character(code1.charAt(0));
    }

    public static Character get1LetterCode(String groupCode3) {
        Character aminoCode1 = null;
        try {
            aminoCode1 = StructureTools.convert_3code_1code(groupCode3);
        }
        catch (IllegalSymbolException e) {
            if (StructureTools.isNucleotide(groupCode3)) {
                aminoCode1 = null;
            }
            logger.warning("unknown group name " + groupCode3);
            aminoCode1 = UNKNOWN_GROUP_LABEL;
        }
        return aminoCode1;
    }

    public static boolean isNucleotide(String groupCode3) {
        String code = groupCode3.trim();
        if (nucleotides30.containsKey(code)) {
            return true;
        }
        return nucleotides23.containsKey(code);
    }

    static {
        logger = Logger.getLogger("org.biojava.bio.structure");
        nucleotides30 = new HashMap<String, Integer>();
        nucleotides30.put("DA", 1);
        nucleotides30.put("DC", 1);
        nucleotides30.put("DG", 1);
        nucleotides30.put("DT", 1);
        nucleotides30.put("DI", 1);
        nucleotides30.put("A", 1);
        nucleotides30.put("G", 1);
        nucleotides30.put("C", 1);
        nucleotides30.put("U", 1);
        nucleotides30.put("I", 1);
        nucleotides30.put("TAF", 1);
        nucleotides30.put("TC1", 1);
        nucleotides30.put("TFE", 1);
        nucleotides30.put("TFO", 1);
        nucleotides30.put("TGP", 1);
        nucleotides30.put("THX", 1);
        nucleotides30.put("TLC", 1);
        nucleotides30.put("TLN", 1);
        nucleotides30.put("TP1", 1);
        nucleotides30.put("TPC", 1);
        nucleotides30.put("TPN", 1);
        nucleotides23 = new HashMap<String, Integer>();
        String[] names = new String[]{"C", "G", "A", "T", "U", "I", "+C", "+G", "+A", "+T", "+U", "+I"};
        for (int i = 0; i < names.length; ++i) {
            String n = names[i];
            nucleotides23.put(n, 1);
        }
        try {
            FiniteAlphabet alpha_prot = ProteinTools.getAlphabet();
            threeLetter = alpha_prot.getTokenization("name");
            oneLetter = alpha_prot.getTokenization("token");
        }
        catch (Exception e) {
            logger.config(e.getMessage());
            e.printStackTrace();
        }
    }
}

