/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.SVDSuperimposer;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.ClusterAltAligs;
import org.biojava.bio.structure.align.StrucAligParameters;
import org.biojava.bio.structure.align.helper.AlignTools;
import org.biojava.bio.structure.align.helper.JointFragments;
import org.biojava.bio.structure.align.pairwise.AltAligComparator;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.align.pairwise.FragmentJoiner;
import org.biojava.bio.structure.align.pairwise.FragmentPair;
import org.biojava.bio.structure.gui.BiojavaJmol;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.jama.Matrix;

public class StructurePairAligner {
    AlternativeAlignment[] alts;
    Matrix distanceMatrix;
    StrucAligParameters params = StrucAligParameters.getDefaultParameters();
    FragmentPair[] fragPairs;
    boolean debug = false;

    public StructurePairAligner() {
        this.reset();
        this.alts = new AlternativeAlignment[0];
        this.distanceMatrix = new Matrix(0, 0);
    }

    public static void main(String[] args) {
        try {
            PDBFileReader pdbr = new PDBFileReader();
            pdbr.setPath("/Users/andreas/WORK/PDB/");
            String pdb1 = "1buz";
            String pdb2 = "1ali";
            String outputfile = "/tmp/alig_" + pdb1 + "_" + pdb2 + ".pdb";
            StructurePairAligner sc = new StructurePairAligner();
            System.out.println("aligning " + pdb1 + " vs. " + pdb2);
            Structure s1 = pdbr.getStructureById(pdb1);
            Structure s2 = pdbr.getStructureById(pdb2);
            sc.align(s1, s2);
            AlternativeAlignment[] aligs = sc.getAlignments();
            ClusterAltAligs.cluster(aligs);
            for (int i = 0; i < aligs.length; ++i) {
                AlternativeAlignment aa = aligs[i];
                System.out.println(aa);
            }
            if (aligs.length > 0) {
                AlternativeAlignment aa1 = aligs[0];
                String pdbstr = aa1.toPDB(s1, s2);
                System.out.println("writing alignment to " + outputfile);
                FileOutputStream out = new FileOutputStream(outputfile);
                PrintStream p = new PrintStream(out);
                p.println(pdbstr);
                p.close();
                out.close();
            }
            if (aligs.length > 0) {
                String[] pdbs2;
                String[] pdbs1;
                if (!BiojavaJmol.jmolInClassPath()) {
                    System.err.println("Could not find Jmol in classpath, please install first!");
                    return;
                }
                AlternativeAlignment aa1 = aligs[0];
                Structure artificial = aa1.getAlignedStructure(s1, s2);
                BiojavaJmol jmol = new BiojavaJmol();
                jmol.setTitle(artificial.getName());
                jmol.setStructure(artificial);
                jmol.evalString("select *; backbone 0.4; wireframe off; spacefill off; select not protein and not solvent; spacefill on;");
                jmol.evalString("select */1 ; color red; model 1; ");
                for (String res : pdbs1 = aa1.getPDBresnum1()) {
                    jmol.evalString("select " + res + "/1 ; backbone 0.6; color white;");
                }
                jmol.evalString("select */2; color blue; model 2;");
                for (String res : pdbs2 = aa1.getPDBresnum2()) {
                    jmol.evalString("select " + res + "/2 ; backbone 0.6; color yellow;");
                }
                jmol.evalString("model 0;");
                jmol.evalString("echo done.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        this.alts = new AlternativeAlignment[0];
        this.distanceMatrix = new Matrix(0, 0);
        this.fragPairs = new FragmentPair[0];
    }

    public FragmentPair[] getFragmentPairs() {
        return this.fragPairs;
    }

    public void setFragmentPairs(FragmentPair[] fragPairs) {
        this.fragPairs = fragPairs;
    }

    public AlternativeAlignment[] getAlignments() {
        return this.alts;
    }

    public Matrix getDistMat() {
        return this.distanceMatrix;
    }

    public StrucAligParameters getParams() {
        return this.params;
    }

    public void setParams(StrucAligParameters params) {
        this.params = params;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void align(Structure s1, Structure s2) throws StructureException {
        this.align(s1, s2, this.params);
    }

    public void align(Structure s1, Structure s2, StrucAligParameters params) throws StructureException {
        Atom[] ca1 = this.getAlignmentAtoms(s1);
        Atom[] ca2 = this.getAlignmentAtoms(s2);
        this.align(ca1, ca2, params);
    }

    public Atom[] getAlignmentAtoms(Structure s) {
        String[] atomNames = this.params.getUsedAtomNames();
        return StructureTools.getAtomArray(s, atomNames);
    }

    public void align(Atom[] ca1, Atom[] ca2, StrucAligParameters params) throws StructureException {
        this.reset();
        if (this.debug) {
            System.out.println(" length atoms1:" + ca1.length);
            System.out.println(" length atoms2:" + ca2.length);
            System.out.println("step 1 - get fragments with similar intramolecular distances ");
        }
        int k = params.getDiagonalDistance();
        int k2 = params.getDiagonalDistance2();
        int fragmentLength = params.getFragmentLength();
        if (ca1.length < fragmentLength + 1 || ca2.length < fragmentLength + 1) {
            throw new StructureException("structure too short, can not align");
        }
        int rows = ca1.length - fragmentLength + 1;
        int cols = ca2.length - fragmentLength + 1;
        this.distanceMatrix = new Matrix(rows, cols, 0.0);
        double[] dist1 = AlignTools.getDiagonalAtK(ca1, k);
        double[] dist2 = AlignTools.getDiagonalAtK(ca2, k);
        double[] dist3 = new double[]{};
        double[] dist4 = new double[]{};
        if (k2 > 0) {
            dist3 = AlignTools.getDiagonalAtK(ca1, k2);
            dist4 = AlignTools.getDiagonalAtK(ca2, k2);
        }
        double[][] utmp = new double[][]{{0.0, 0.0, 1.0}};
        AtomImpl unitvector = new AtomImpl();
        unitvector.setCoords(utmp[0]);
        ArrayList<FragmentPair> fragments = new ArrayList<FragmentPair>();
        block4: for (int i = 0; i < rows; ++i) {
            Atom[] catmp1 = AlignTools.getFragment(ca1, i, fragmentLength);
            Atom center1 = AlignTools.getCenter(ca1, i, fragmentLength);
            for (int j = 0; j < cols; ++j) {
                double rdd1 = AlignTools.rms_dk_diag(dist1, dist2, i, j, fragmentLength, k);
                double rdd2 = 0.0;
                if (k2 > 0) {
                    rdd2 = AlignTools.rms_dk_diag(dist3, dist4, i, j, fragmentLength, k2);
                }
                double rdd = rdd1 + rdd2;
                this.distanceMatrix.set(i, j, rdd);
                if (!(rdd < (double)params.getFragmentMiniDistance())) continue;
                FragmentPair f = new FragmentPair(fragmentLength, i, j);
                try {
                    Atom[] catmp2 = AlignTools.getFragment(ca2, j, fragmentLength);
                    Atom center2 = AlignTools.getCenter(ca2, j, fragmentLength);
                    f.setCenter1(center1);
                    f.setCenter2(center2);
                    SVDSuperimposer svd = new SVDSuperimposer(catmp1, catmp2);
                    Matrix rotmat = svd.getRotation();
                    f.setRot(rotmat);
                    Atom aunitv = (Atom)unitvector.clone();
                    Calc.rotate(aunitv, rotmat);
                    f.setUnitv(aunitv);
                    boolean doNotAdd = false;
                    if (params.reduceInitialFragments()) {
                        doNotAdd = FragmentJoiner.reduceFragments(fragments, f, this.distanceMatrix);
                    }
                    if (doNotAdd) continue;
                    fragments.add(f);
                    continue;
                }
                catch (StructureException e) {
                    e.printStackTrace();
                    continue block4;
                }
            }
        }
        FragmentPair[] fp = fragments.toArray(new FragmentPair[fragments.size()]);
        this.setFragmentPairs(fp);
        if (this.debug) {
            System.out.println(" got # fragment pairs: " + fp.length);
        }
        if (this.debug) {
            System.out.println("step 2 - join fragments");
        }
        FragmentJoiner joiner = new FragmentJoiner();
        JointFragments[] frags = !params.isJoinPlo() ? joiner.approach_ap3(ca1, ca2, fp, params) : joiner.frag_pairwise_compat(fp, params.getAngleDiff(), params.getFragCompat(), params.getMaxrefine());
        if (this.debug) {
            System.out.println(" number joint fragments:" + frags.length);
        }
        if (this.debug) {
            System.out.println("step 3 - refine alignments");
        }
        ArrayList<AlternativeAlignment> aas = new ArrayList<AlternativeAlignment>();
        for (int i = 0; i < frags.length; ++i) {
            JointFragments f = frags[i];
            AlternativeAlignment a = new AlternativeAlignment();
            a.apairs_from_idxlst(f);
            a.setAltAligNumber(i + 1);
            a.setDistanceMatrix(this.distanceMatrix);
            try {
                if (params.getMaxIter() > 0) {
                    a.refine(params, ca1, ca2);
                } else {
                    a.finish(params, ca1, ca2);
                }
            }
            catch (StructureException e) {
                e.printStackTrace();
            }
            a.calcScores(ca1, ca2);
            aas.add(a);
        }
        AltAligComparator comp = new AltAligComparator();
        Collections.sort(aas, comp);
        Collections.reverse(aas);
        this.alts = aas.toArray(new AlternativeAlignment[aas.size()]);
        int aanbr = 0;
        for (int i = 0; i < this.alts.length; ++i) {
            AlternativeAlignment a = this.alts[i];
            a.setAltAligNumber(++aanbr);
        }
    }
}

